package com.yeejoin.amos.boot.module.jg.biz.handler;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.boot.module.jg.api.enums.SafetyProblemSourceTypeEnum;
import com.yeejoin.amos.boot.module.jg.api.enums.SafetyProblemTypeEnum;
import com.yeejoin.amos.boot.module.jg.api.event.SafetyProblemEvent;
import com.yeejoin.amos.boot.module.jg.api.event.handler.SafetyProblemEventHandler;
import com.yeejoin.amos.boot.module.jg.biz.listener.SafetyProblemTopicMessage;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.SafetyProblemTracingServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * XKCQEventHandler 类实现了 SafetyProblemEventHandler 接口，
 * 用于处理企业资质超期安全问题事件。
 */
@Component
public class XKCQEventHandler implements SafetyProblemEventHandler {

    SafetyProblemTracingServiceImpl safetyProblemTracingService;

    @Autowired
    public XKCQEventHandler(SafetyProblemTracingServiceImpl safetyProblemTracingService) {
        this.safetyProblemTracingService = safetyProblemTracingService;
    }

    /**
     * 处理安全问题事件。
     *
     * @param event 安全问题事件对象，包含事件的详细信息。
     *              该参数用于描述发生的安全问题事件。
     */
    @Override
    public void handle(SafetyProblemEvent event) {
        // 此处为处理安全问题事件的逻辑代码
        JSONArray jsonArray = JSONObject.parseArray(event.getMessage().toString());
        generateProblem(jsonArray);
    }

    private void generateProblem(JSONArray jsonArray) {
        jsonArray.forEach(item -> {
            JSONObject problemObj = (JSONObject) item;
            problemObj.put("sourceType", SafetyProblemSourceTypeEnum.UNIT.getName());
            problemObj.put("sourceTypeCode", SafetyProblemSourceTypeEnum.UNIT.getCode());
            problemObj.put("problemDesc", "证书编号：" + problemObj.get("certNo") + SafetyProblemTypeEnum.XKCQ.getName());
        });
        SafetyProblemTopicMessage.generateUnitProblem(jsonArray, SafetyProblemTypeEnum.XKCQ, safetyProblemTracingService);
    }
}

