package com.yeejoin.amos.boot.module.jg.api.converter;

import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.CellData;
import com.alibaba.excel.metadata.GlobalConfiguration;
import com.alibaba.excel.metadata.property.ExcelContentProperty;
import java.util.HashMap;
import java.util.Map;

public class ChargingMediumConverter implements Converter<String> {

    private static final Map<String, String> EXCEL_TO_JAVA_MAP = new HashMap<>();
    private static final Map<String, String> JAVA_TO_EXCEL_MAP = new HashMap<>();

    static {
        EXCEL_TO_JAVA_MAP.put("液化天然气", "LIQUEFIED_NATURAL_GAS");
        EXCEL_TO_JAVA_MAP.put("液化石油气", "LIQUEFIED_PETROLEUM_GAS");
        EXCEL_TO_JAVA_MAP.put("压缩天然气", "COMPRESSED_NATURAL_GAS");
        EXCEL_TO_JAVA_MAP.put("氢气", "HYDROGEN");
        EXCEL_TO_JAVA_MAP.put("空气", "AIR");
        EXCEL_TO_JAVA_MAP.put("氧气", "OXYGEN");
        EXCEL_TO_JAVA_MAP.put("丙烷", "PROPANE");
        EXCEL_TO_JAVA_MAP.put("丁烷", "BUTANCE");
        EXCEL_TO_JAVA_MAP.put("液化二氧化碳", "LIQUEFIED_CARBON_DIOXIDE");
        EXCEL_TO_JAVA_MAP.put("液氧", "LIQUID_OXYGEN");
        EXCEL_TO_JAVA_MAP.put("氮气", "NITROGEN");
        EXCEL_TO_JAVA_MAP.put("氩气", "ARGON");
        EXCEL_TO_JAVA_MAP.put("液氩", "LIQUID_ARGON");
        EXCEL_TO_JAVA_MAP.put("液氮", "LIQUID_NITROGEN");

        JAVA_TO_EXCEL_MAP.put("LIQUEFIED_NATURAL_GAS", "液化天然气");
        JAVA_TO_EXCEL_MAP.put("LIQUEFIED_PETROLEUM_GAS", "液化石油气");
        JAVA_TO_EXCEL_MAP.put("COMPRESSED_NATURAL_GAS", "压缩天然气");
        JAVA_TO_EXCEL_MAP.put("HYDROGEN", "氢气");
        JAVA_TO_EXCEL_MAP.put("AIR", "空气");
        JAVA_TO_EXCEL_MAP.put("OXYGEN", "氧气");
        JAVA_TO_EXCEL_MAP.put("PROPANE", "丙烷");
        JAVA_TO_EXCEL_MAP.put("BUTANCE", "丁烷");
        JAVA_TO_EXCEL_MAP.put("LIQUEFIED_CARBON_DIOXIDE", "液化二氧化碳");
        JAVA_TO_EXCEL_MAP.put("LIQUID_OXYGEN", "液氧");
        JAVA_TO_EXCEL_MAP.put("NITROGEN", "氮气");
        JAVA_TO_EXCEL_MAP.put("ARGON", "氩气");
        JAVA_TO_EXCEL_MAP.put("LIQUID_ARGON", "液氩");
        JAVA_TO_EXCEL_MAP.put("LIQUID_NITROGEN", "液氮");
    }

    @Override
    public Class<?> supportJavaTypeKey() {
        return String.class;
    }

    @Override
    public CellDataTypeEnum supportExcelTypeKey() {
        return CellDataTypeEnum.STRING;
    }

    @Override
    public String convertToJavaData(CellData cellData, ExcelContentProperty excelContentProperty,
                                    GlobalConfiguration globalConfiguration) {
        return EXCEL_TO_JAVA_MAP.getOrDefault(cellData.getStringValue(), "COMPRESSED_NATURAL_GAS");
    }

    @Override
    public CellData convertToExcelData(String o, ExcelContentProperty excelContentProperty,
                                       GlobalConfiguration globalConfiguration) {
        return new CellData(JAVA_TO_EXCEL_MAP.getOrDefault(o, "压缩天然气"));
    }
}
