package com.yeejoin.amos.boot.module.jg.biz.controller;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.yeejoin.amos.boot.module.jg.api.dto.JgReformNoticeDto;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.JgReformNoticeServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

/**
 * 改造告知
 *
 * @author system_generator
 * @date 2023-12-12
 */
@RestController
@Api (tags = "改造告知工作流相关Api")
@RequestMapping (value = "/jg-reform-workflow")
public class JgReformByWorkFlowController {

    @Autowired
    JgReformNoticeServiceImpl jgReformNoticeService;

    /**
     * 提交
     *
     * @return
     */
    @Deprecated
    @TycloudOperation (ApiLevel = UserType.AGENCY)
    @PostMapping (value = "/submit")
    @ApiOperation (httpMethod = "POST", value = "改造告知提交", notes = "改造告知提交")
    public ResponseModel<JgReformNoticeDto> submit(@RequestBody JgReformNoticeDto model, String op) {
        // TODO 发起改造告知流程
        // jgReformNoticeService.submit(model, op);
        return ResponseHelper.buildResponse(model);
    }

    /**
     * 撤销
     *
     * @return
     */
    @TycloudOperation (ApiLevel = UserType.AGENCY)
    @PostMapping (value = "/cancel")
    @ApiOperation (httpMethod = "POST", value = "改造告知撤销", notes = "改造告知撤销")
    public ResponseModel<JgReformNoticeDto> cancel(@RequestBody JgReformNoticeDto model) {
        if (Objects.isNull(model)) {
            throw new IllegalArgumentException("参数reformInfo不能为空");
        }
        jgReformNoticeService.cancel(model);
        return ResponseHelper.buildResponse(model);
    }

    /**
     * 受理
     *
     * @return
     */
    @TycloudOperation (ApiLevel = UserType.AGENCY)
    @PostMapping (value = "/accept")
    @ApiOperation (httpMethod = "POST", value = "改造告知受理", notes = "改造告知受理")
    public ResponseModel<JgReformNoticeDto> accept(@RequestBody Map<String, Object> model, String op) {
        // TODO 受理改造告知流程
        LinkedHashMap model1 = (LinkedHashMap) model.get("model");
        String opinion = (String) model.get("opinion");
        JgReformNoticeDto jgReformNoticeDto = JSON.parseObject(JSON.toJSONString(model1), JgReformNoticeDto.class);
        jgReformNoticeDto.setRemark(opinion);
        jgReformNoticeService.accept(jgReformNoticeDto, op);
        return ResponseHelper.buildResponse(null);
    }
}
