package com.yeejoin.amos.boot.module.jyjc.biz.service.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import com.yeejoin.amos.boot.biz.common.utils.RedisKey;
import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import com.yeejoin.amos.boot.module.jyjc.api.enums.OpenBizTypeEnum;
import com.yeejoin.amos.boot.module.jyjc.api.mapper.JyjcBaseMapper;
import com.yeejoin.amos.boot.module.jyjc.api.model.InstanceRuntimeData;
import com.yeejoin.amos.boot.module.ymt.api.dto.TzBaseEnterpriseInfoDto;
import com.yeejoin.amos.boot.module.ymt.api.entity.TzBaseEnterpriseInfo;
import com.yeejoin.amos.boot.module.ymt.api.entity.TzsUserInfo;
import com.yeejoin.amos.boot.module.ymt.api.mapper.TzBaseEnterpriseInfoMapper;
import com.yeejoin.amos.boot.module.ymt.api.mapper.TzsUserInfoMapper;
import com.yeejoin.amos.component.feign.model.FeignClientResult;
import com.yeejoin.amos.feign.privilege.Privilege;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import com.yeejoin.amos.feign.privilege.model.CompanyModel;
import com.yeejoin.amos.feign.systemctl.Systemctl;
import com.yeejoin.amos.feign.systemctl.model.DictionarieValueModel;
import org.redisson.api.RBucket;
import org.redisson.api.RedissonClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;

import java.util.Collections;
import java.util.List;

/**
 * @author Administrator
 */
@Service
public class CommonServiceImpl {

    @Value("${jyjc.user-post:6615}")
    private String jyjcUserPost;

    @Value("${jyjc.user-post:6616}")
    private String jyjcBizUserPost;

    @Value("${jy.user-post:66151}")
    private String jyUserPost;

    @Value("${jc.user-post:66152}")
    private String jcUserPost;

    @Autowired
    RedisUtils redisUtils;
    @Autowired
    TzsUserInfoMapper userInfoMapper;

    @Autowired
    TzBaseEnterpriseInfoMapper enterpriseInfoMapper;

    @Autowired
    RedissonClient redissonClient;

    @Autowired
    JyjcBaseMapper jyjcBaseMapper;

    /**
     * 检验-人员级别字典KEY
     */
    private final static String RYJB_DICT_KEY_JY = "RYJB_JY";

    /**
     * 检测-人员级别字典KEY
     */
    private final static String RYJB_DICT_KEY_JC = "RYJB_JC";


    /**
     * @return ReginParams
     * @description 获取当前用户注册信息
     */
    ReginParams getReginParamsOfCurrentUser() {
        return JSONObject.parseObject(redisUtils.get(RedisKey.buildReginKey(RequestContext.getExeUserId(), RequestContext.getToken())).toString(), ReginParams.class);
    }

    public List<TzsUserInfo> getUserInfosByUnitCode(String unitCode) {
        LambdaQueryWrapper<TzsUserInfo> userInfoQueryWrapper = new LambdaQueryWrapper<>();
        userInfoQueryWrapper.eq(TzsUserInfo::getUnitCode, unitCode);
        userInfoQueryWrapper.like(TzsUserInfo::getPost, jyjcUserPost);
        userInfoQueryWrapper.eq(BaseEntity::getIsDelete, false);
        return userInfoMapper.selectList(userInfoQueryWrapper);
    }

    public List<TzsUserInfo> getUserListByUnitCodeAndPost(String unitCode, String personType) {
        LambdaQueryWrapper<TzsUserInfo> userInfoQueryWrapper = new LambdaQueryWrapper<>();
        userInfoQueryWrapper.eq(TzsUserInfo::getUnitCode, unitCode);
        this.castPersonType2Post(userInfoQueryWrapper, personType);
        userInfoQueryWrapper.eq(BaseEntity::getIsDelete, false);
        userInfoQueryWrapper.select(TzsUserInfo::getPost, TzsUserInfo::getPhone, TzsUserInfo::getName, TzsUserInfo::getInnerPersonCode, BaseEntity::getSequenceNbr);
        return userInfoMapper.selectList(userInfoQueryWrapper);
    }


    private void castPersonType2Post(LambdaQueryWrapper<TzsUserInfo> userInfoQueryWrapper, String personType) {
        if (personType.equals(OpenBizTypeEnum.JY.getCode())) {
            userInfoQueryWrapper.like(TzsUserInfo::getPost, jyUserPost);
        }
        if (personType.equals(OpenBizTypeEnum.JC.getCode())) {
            userInfoQueryWrapper.like(TzsUserInfo::getPost, jcUserPost);
        }
    }

    public List<TzsUserInfo> getBizUserInfosByUnitCode(String unitCode) {
        QueryWrapper userInfoQueryWrapper = new QueryWrapper<>();
        userInfoQueryWrapper.eq("unit_code", unitCode);
        userInfoQueryWrapper.like("post", jyjcBizUserPost);
        userInfoQueryWrapper.isNotNull("amos_user_id");
        userInfoQueryWrapper.eq("is_delete", false);
        List<TzsUserInfo> userInfos = userInfoMapper.selectList(userInfoQueryWrapper);
        return userInfos;
    }

    public List<TzsUserInfo> getUserPhonesByPersonCode(String personCode) {
        List<String> ids = StrUtil.split(personCode, ",");
        QueryWrapper userInfoQueryWrapper = new QueryWrapper<>();
        userInfoQueryWrapper.in("sequence_nbr", ids);
        return userInfoMapper.selectList(userInfoQueryWrapper);
    }


    public List<TzBaseEnterpriseInfoDto> getInspectionUnitList(String openBizType) {
        return enterpriseInfoMapper.getInspectionUnitList(openBizType);
    }

    public TzBaseEnterpriseInfo getInspectionUnitBySequenceNbr(Long sequenceNbr) {
        return enterpriseInfoMapper.selectBySeq(sequenceNbr);
    }


    /**
     * 执行流程时前置校验是否已经执行
     *
     * @param taskId     任务id
     * @param instanceId 实例id
     */
    public void checkForExecuteFlow(String taskId, String instanceId) {
        InstanceRuntimeData instanceRuntimeData = getInstanceRuntimeData(instanceId);
        if (instanceRuntimeData == null) {
            throw new BadRequest("当前流程已经被执行！请重新打开页面查看并执行！");
        }
        // 当前任务id与当前任务id不一致时，不让操作，解决老页面没关闭，但是流程已经被被人执行（通过、驳回、撤回），工作流未限制错误
        String currentTaskId = instanceRuntimeData.getNextTaskId();
        if (!taskId.equals(currentTaskId)) {
            throw new BadRequest("当前流程已经被执行！请重新打开页面查看并执行！");
        }
        // 当前流程已经被转办给其他人或者页面按钮问题导致的权限未控制
        String nextExecuteUserIds = instanceRuntimeData.getNextExecuteUserIds();
        if (!nextExecuteUserIds.contains(RequestContext.getExeUserId())) {
            throw new BadRequest("当前登录人无执行权限！");
        }

    }

    private InstanceRuntimeData getInstanceRuntimeData(String instanceId) {
        RBucket<InstanceRuntimeData> rBucket = redissonClient.getBucket(buildJcInstanceDataKey(instanceId));
        return rBucket.get();
    }

    private String buildJcInstanceDataKey(String instanceId) {
        return "JC_INSTANCE_DATA:" + instanceId;
    }

    public static String buildJcExecuteLockKey(String instanceId) {
        return "JC_INSTANCE_LOCK:" + instanceId;
    }


    /**
     * 最新流程数据缓存
     *
     * @param instanceId   实例id
     * @param instanceData 流程数据
     */
    public void saveExecuteFlowData2Redis(String instanceId, InstanceRuntimeData instanceData) {
        redissonClient.getBucket(buildJcInstanceDataKey(instanceId)).set(instanceData);
    }


    /**
     * 撤回时校验流程是否已经执行
     *
     * @param taskId     前端业务上送任务id
     * @param instanceId 实例id
     */
    public void checkForRevocationFlow(String taskId, String instanceId) {
        InstanceRuntimeData instanceRuntimeData = getInstanceRuntimeData(instanceId);
        if (instanceRuntimeData == null) {
            throw new BadRequest("当前流程已经被执行！请重新打开页面查看并执行！");
        }
        // 前端页面上送任务id与当前任务id不一致时，不让操作，解决老页面没关闭，但是流程已经被被人执行（通过、驳回、撤回），工作流未限制错误
        String currentTaskId = instanceRuntimeData.getNextTaskId();
        if (!taskId.equals(currentTaskId)) {
            throw new BadRequest("当前流程已经被执行！请重新打开页面查看并执行！");
        }
        if (!instanceRuntimeData.getPromoter().equals(RequestContext.getExeUserId())) {
            throw new BadRequest("无权限执行该任务");
        }
    }

    public List<AgencyUserModel> getAmosUseListByCompanyCode(String unitCode) {
        CompanyModel companyModel = jyjcBaseMapper.selectOneCompanyByCode(unitCode);
        FeignClientResult<List<AgencyUserModel>> result = Privilege.agencyUserClient.queryByCompanyId(companyModel.getSequenceNbr(), null, null, false);
        return result.getResult();
    }

    public void personPermissionUpdate() {
        // 1.查询需处理的检验、检验人员类型的数据
        LambdaQueryWrapper<TzsUserInfo> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.like(TzsUserInfo::getPost, jyUserPost).or().like(TzsUserInfo::getPost, jcUserPost);
        queryWrapper.eq(BaseEntity::getIsDelete, false);
        queryWrapper.select(BaseEntity::getSequenceNbr, TzsUserInfo::getPermissionLevel, TzsUserInfo::getPermissionItem);
        List<TzsUserInfo> jyjcUsers = userInfoMapper.selectList(queryWrapper);
        // 2.人员级别枚举，用来判断是检验检验资质还是检测人员资质，判断key
        List<DictionarieValueModel> jyDicts = getUserLevel(RYJB_DICT_KEY_JY);
        jyjcUsers.forEach(user -> {
            JSONObject jsonObject = new JSONObject();
            // 检验人员逻辑
            if (jyDicts.stream().anyMatch(d -> d.getDictDataKey().equals(user.getPermissionLevel()))) {
                // key格式固定为permissionData + 人员类型
                jsonObject.put(String.format("permissionData%s", jyUserPost), this.buildLength1ArrayData(user));
            } else {
                // 检测人员逻辑
                jsonObject.put(String.format("permissionData%s", jcUserPost), this.buildLength1ArrayData(user));
            }
            userInfoMapper.update(null, new LambdaUpdateWrapper<TzsUserInfo>()
                    .eq(BaseEntity::getSequenceNbr, user.getSequenceNbr())
                    .set(TzsUserInfo::getPermissionLevel, null)
                    .set(TzsUserInfo::getPermissionItem, null).set(TzsUserInfo::getPermissionData, jsonObject.toJSONString()));
        });
    }

    private JSONArray buildLength1ArrayData(TzsUserInfo user) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("permissionItem", JSONArray.parseArray(user.getPermissionItem()));
        jsonObject.put("permissionLevel", user.getPermissionLevel());
        return new JSONArray(Collections.singletonList(jsonObject));
    }

    private List<DictionarieValueModel> getUserLevel(String dictKey) {
        FeignClientResult<List<DictionarieValueModel>> jyItemDictResult = Systemctl.dictionarieClient.dictValues(dictKey);
        return jyItemDictResult.getResult();
    }
}
