package com.yeejoin.amos.boot.module.common.api.dto;

import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * 反馈建议表
 *
 * @author system_generator
 * @date 2025-05-15
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "FeedbackSuggestionsDto", description = "反馈建议表")
public class FeedbackSuggestionsDto extends BaseDto {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "创建人id")
    private String createUserId;

    @ApiModelProperty(value = "创建人")
    private String createUserName;

    @ApiModelProperty(value = "创建时间（填报时间）")
    private Date createDate;

    @ApiModelProperty(value = "问题类型（字典值）")
    private String problemType;

    @ApiModelProperty(value = "问题描述")
    private String problemDescription;

    @ApiModelProperty(value = "管辖机构org_code")
    private String superviseOrgCode;

    @ApiModelProperty(value = "ed")
    private String superviseOrgName;

    @ApiModelProperty(value = "上报企业统一信用代码")
    private String companyCode;

    @ApiModelProperty(value = "上报企业名称")
    private String companyName;

    @ApiModelProperty(value = "上报人员id")
    private Integer reporterUserId;

    @ApiModelProperty(value = "上报人员姓名")
    private String reporterUserName;

    @ApiModelProperty(value = "联系人")
    private String contactPerson;

    @ApiModelProperty(value = "联系电话")
    private String contactPhone;

    @ApiModelProperty(value = "回复状态（1：回复，0：未回复）")
    private String status;

}
