package com.yeejoin.amos.boot.module.common.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * 反馈回复表
 *
 * @author system_generator
 * @date 2025-05-15
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("tzs_feedback_replies")
public class FeedbackReplies extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 创建人id
     */
	@TableField("create_user_id")
    private String createUserId;

    /**
     * 创建人
     */
	@TableField("create_user_name")
    private String createUserName;

    /**
     * 创建时间（回复时间）
     */
	@TableField("create_date")
    private Date createDate;

    /**
     * 回复描述
     */
	@TableField("reply_description")
    private String replyDescription;

    /**
     * 回复用户id
     */
	@TableField("reply_user_id")
    private Integer replyUserId;

    /**
     * 回复用户姓名
     */
	@TableField("reply_user_name")
    private String replyUserName;

    /**
     * 反馈建议表seq
     */
	@TableField("suggestions_seq")
    private String suggestionsSeq;

    /**
     * 已读状态（1：已读，0：未读）
     */
	@TableField("read_status")
    private String readStatus;

    /**
     * 回复单位code
     */
	@TableField("reply_company_code")
    private String replyCompanyCode;

    /**
     * 回复单位名称
     */
	@TableField("reply_company_name")
    private String replyCompanyName;

}
