package com.yeejoin.amos.boot.module.common.biz.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.common.api.entity.FeedbackSuggestions;
import com.yeejoin.amos.boot.module.common.biz.service.impl.FeedbackSuggestionsServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 *
 * @author system_generator
 * @date 2025-05-15
 */
@RestController
@Api(tags = "反馈建议表")
@RequestMapping(value = "/feedback-suggestions")
public class FeedbackSuggestionsController extends BaseController {

    @Autowired
    FeedbackSuggestionsServiceImpl feedbackSuggestionsServiceImpl;

    /**
     * 新增
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增", notes = "新增")
	public ResponseModel<FeedbackSuggestions> save(@RequestBody FeedbackSuggestions suggestions) {
		suggestions = feedbackSuggestionsServiceImpl.createWithModel(suggestions);
	    return ResponseHelper.buildResponse(suggestions);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新", notes = "根据sequenceNbr更新")
	public ResponseModel<FeedbackSuggestions> updateBySequenceNbrFeedbackSuggestions(@RequestBody FeedbackSuggestions entity,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    entity.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(feedbackSuggestionsServiceImpl.updateWithModel(entity));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除", notes = "根据sequenceNbr删除")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(feedbackSuggestionsServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个",  notes = "根据sequenceNbr查询单个")
	public ResponseModel<FeedbackSuggestions> selectOne(@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(feedbackSuggestionsServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "分页查询",  notes = "分页查询")
	public ResponseModel<Page<FeedbackSuggestions>> queryForPage(@RequestParam(value = "current") int current,@RequestParam
                    (value = "size") int size) {
	    Page<FeedbackSuggestions> page = new Page<FeedbackSuggestions>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(feedbackSuggestionsServiceImpl.queryForFeedbackSuggestionsPage(page));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "列表全部数据查询",   notes = "列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<FeedbackSuggestions>> selectForList() {
	    return ResponseHelper.buildResponse(feedbackSuggestionsServiceImpl.queryForFeedbackSuggestionsList());
	}
}
