package com.yeejoin.amos.boot.module.jg.api.dto;

import com.alibaba.fastjson.JSON;
import com.yeejoin.amos.boot.biz.common.annotation.FieldDisplayDefine;
import com.yeejoin.amos.boot.biz.common.annotation.Group;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 管道工程装置表
 *
 * @author system_generator
 * @date 2024-12-11
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Group(value = "idx_biz_jg_project_contraption")
@ApiModel(value = "ProjectContraptionChangeFieldDto", description = "管道工程装置表")
public class ProjectContraptionChangeDataDto extends BaseChangeDataDto {

    @FieldDisplayDefine(value = "主键", isExist = false)
    private String projectContraptionId;

    private static final long serialVersionUID = 1L;

    @FieldDisplayDefine(value = "工程（装置）名称/项目名称")
    private String projectContraption;

    @FieldDisplayDefine(value = "工程（装置）编号/项目编号")
    private String projectContraptionNo;

    @FieldDisplayDefine(value = "设备品种代码")
    private String equDefineCode;

    @FieldDisplayDefine(value = "设备品种名称")
    private String equDefine;

    @FieldDisplayDefine(value = "装置管道总长度(m)", isExist = false)
    private Double pipelineLength;

    @FieldDisplayDefine(value = "产品照片附件", type = JSON.class)
    private String productPhoto;

    @FieldDisplayDefine(value = "其他附件", type = JSON.class)
    private String otherAccessories;

    @FieldDisplayDefine(value = "产品质量合格证明", type = JSON.class)
    private String productQualificationCertificate;
}
