package com.yeejoin.amos.boot.module.jg.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import java.util.Date;

/**
 * 监管履历信息
 *
 * @author system_generator
 * @date 2024-05-29
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("tzs_jg_resume_info")
public class JgResumeInfo extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 申请编号
     */
	@TableField("apply_no")
    private String applyNo;

    /**
     * 业务状态
     */
	@TableField("status")
    private String status;

    /**
     * 业务id
     */
	@TableField("business_id")
    private String businessId;

    /**
     * 创建时间
     */
	@TableField("create_date")
    private Date createDate;

    /**
     * 创建人id 
     */
	@TableField("create_user_id")
    private String createUserId;

    /**
     * 创建人
     */
	@TableField("create_user_name")
    private String createUserName;

    /**
     * 设备ID
     */
	@TableField("equ_id")
    private String equId;

    /**
     * 业务类型
     */
	@TableField("business_type")
    private String businessType;

    /**
     * 审批单位
     */
	@TableField("approval_unit")
    private String approvalUnit;

    /**
     * 审批单位code
     */
    @TableField("approval_unit_code")
    private String approvalUnitCode;

    /**
     * 详情路径
     */
    @TableField("route_path")
    private String routePath;

    /**
     * 数据来源（新增：0、导入：1)
     */
    @TableField("data_source")
    private String dataSource;

    /**
     * 设备编辑记录表主键
     */
    @TableField("change_log_id")
    private String changeLogId;

    /**
     * 业务类型(默认0,告知登记业务,1设备编辑)
     */
    @TableField("resume_type")
    private String resumeType;
}
