package com.yeejoin.amos.boot.module.jg.biz.controller;


import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.map.MapBuilder;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yeejoin.amos.boot.biz.common.annotation.FieldMapping;
import com.yeejoin.amos.boot.biz.common.bo.CompanyBo;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.biz.common.entity.DataDictionary;
import com.yeejoin.amos.boot.biz.common.service.impl.DataDictionaryServiceImpl;
import com.yeejoin.amos.boot.module.jg.api.dto.CodeGenerateDto;
import com.yeejoin.amos.boot.module.jg.api.dto.EquipmentClassifyDto;
import com.yeejoin.amos.boot.module.jg.api.dto.UseFlagParamDto;
import com.yeejoin.amos.boot.module.jg.api.entity.JgRegistrationHistory;
import com.yeejoin.amos.boot.module.jg.api.entity.JgUseRegistrationManage;
import com.yeejoin.amos.boot.module.jg.api.mapper.JgUseRegistrationMapper;
import com.yeejoin.amos.boot.module.jg.api.service.IJgCertificateReplenishService;
import com.yeejoin.amos.boot.module.jg.api.service.IJgInstallationNoticeService;
import com.yeejoin.amos.boot.module.jg.biz.service.ICommonService;
import com.yeejoin.amos.boot.module.jg.biz.service.IPdfService;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.CommonServiceImpl;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.JgRegistrationHistoryServiceImpl;
import com.yeejoin.amos.boot.module.jg.biz.utils.CodeUtil;
import com.yeejoin.amos.boot.module.ymt.api.dto.EquipmentCategoryDto;
import com.yeejoin.amos.boot.module.ymt.api.entity.EquipmentCategory;
import com.yeejoin.amos.boot.module.ymt.api.enums.ApplicationFormTypeEnum;
import com.yeejoin.amos.boot.module.ymt.api.enums.FlowStatusEnum;
import com.yeejoin.amos.feign.systemctl.Systemctl;
import com.yeejoin.amos.feign.systemctl.model.DictionarieValueModel;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.component.event.RestEventTrigger;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletResponse;
import java.util.*;
import java.util.stream.Collectors;

import static com.yeejoin.amos.boot.module.jg.biz.service.impl.JgCertificateReplenishServiceImpl.FORM_DATA;

/**
 * 监管公共Api
 *
 * @author system_generator
 * @date 2021-10-20
 */
@RestController
@Api(tags = "监管公共Api")
@RequestMapping(value = "/common")
@RequiredArgsConstructor
public class CommonController extends BaseController {
    private final ICommonService commonService;
    private final IPdfService pdfService;
    private final JgRegistrationHistoryServiceImpl jgRegistrationHistoryService;
    private final JgUseRegistrationMapper jgUseRegistrationMapper;
    private final IJgCertificateReplenishService iJgCertificateReplenishService;
    private final CodeUtil codeUtil;
    private final DataDictionaryServiceImpl iDataDictionaryService;

    /**
     * 监管机构
     */
    public static final String COMPANY_TYPE_SUPERVISION_NAME = "监管机构";

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/currentLoginInfo")
    @ApiOperation(httpMethod = "GET", value = "当前登录人信息", notes = "当前登录人信息")
    public ResponseModel<ReginParams> getChildren() {
        return ResponseHelper.buildResponse(getSelectedOrgInfo());
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/getChildren")
    @ApiOperation(httpMethod = "GET", value = "通过设备种类code获取设备类别", notes = "通过设备种类code获取设备类别")
    public ResponseModel<List<EquipmentCategory>> getChildren(@RequestParam(value = "code", required = false) String code,
                                                              @RequestParam(value = "type", required = false) String type) {
        return ResponseHelper.buildResponse(commonService.getEquipmentCategoryList(code, type));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/getRegion")
    @ApiOperation(httpMethod = "GET", value = "获取行政区划", notes = "获取行政区划")
    public ResponseModel<Object> getRegion(@RequestParam(value = "level", required = false) String level,
                                           @RequestParam(value = "parentId", required = false) String parentId) {
        return ResponseHelper.buildResponse(commonService.getRegion(level, parentId));
    }

    /**
     * 获取管辖分局树
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/creatTree")
    @ApiOperation(httpMethod = "GET", value = "获取管辖分局树", notes = "获取管辖分局树")
    public ResponseModel<Object> creatTree() {
        return ResponseHelper.buildResponse(commonService.getTree(getSelectedOrgInfo()));
    }


    /**
     * 工作台接收机构树
     *
     * @param bizType 业务类型：notice-告知类， register-登记类
     * @return 树
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/{bizType}/receive-unit/tree")
    @ApiOperation(httpMethod = "GET", value = "接收机构树", notes = "接收机构树")
    public ResponseModel<Object> getNoticeReceiveTree(@PathVariable String bizType) {
        return ResponseHelper.buildResponse(commonService.getReceiveUnitTree(bizType));
    }


    /**
     * 获取行政审批局树
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/getApproveTree")
    @ApiOperation(httpMethod = "GET", value = "获取行政审批局树", notes = "获取行政审批局树")
    public ResponseModel<Object> getApproveTree() {
        ReginParams reginParams = getSelectedOrgInfo();
        return ResponseHelper.buildResponse(commonService.getApproveTree(reginParams));
    }

    /**
     * 通过单位类型获取单位列表
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/getUnitList")
    @ApiOperation(httpMethod = "GET", value = "通过单位类型获取单位列表", notes = "通过单位类型获取单位列表")
    public ResponseModel<List<Map<String, Object>>> getUnitList(@RequestParam(value = "type") String type,
                                                                @RequestParam(value = "business", required = false) String business) {
        return ResponseHelper.buildResponse(commonService.getUnitListByType(type, business, false));
    }

    /**
     * 需求 【3197】
     * 根据当前登录人获取使用单位列表（用作设备列表查询）
     *  当前登录人：监管 -> 获取所有使用单位
     *            其他 -> 当前登录人所在单位
     * @return unitLists
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/getUseUnitListByCurrentLoginUser")
    @ApiOperation(httpMethod = "GET", value = "根据当前登录人获取使用单位列表（用作设备列表查询）", notes = "根据当前登录人获取使用单位列表（用作设备列表查询）")
    public ResponseModel<List<Map<String, Object>>> getUseUnitListByCurrentLoginUser() {
        String companyType = getSelectedOrgInfo().getCompany().getCompanyType();
        List<Map<String, Object>> result = new ArrayList<>();
        if (COMPANY_TYPE_SUPERVISION_NAME.equals(companyType)) {
            result = commonService.getUnitListByType("use", null, false);
        }else {
            result.add(MapBuilder.<String, Object>create()
                    .put("useCode", getSelectedOrgInfo().getCompany().getCompanyCode())
                    .put("useUnit", getSelectedOrgInfo().getCompany().getCompanyName())
                    .build());
        }
        return ResponseHelper.buildResponse(result);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "列表全部数据查询", notes = "列表全部数据查询")
    @GetMapping(value = "/getMessage")
    public ResponseModel<Map<String, Object>> getMessage() {
        ReginParams selectedOrgInfo = getSelectedOrgInfo();
        HashMap<String, Object> map = new HashMap<>();
        String companyType = selectedOrgInfo.getCompany().getCompanyType();
        if ("个人主体".equals(companyType)) {
            String[] code = selectedOrgInfo.getCompany().getCompanyCode().split("_");
            String useUnitCode = code.length > 1 ? code[1] : code[0];
            map.put("useUnitCreditCode", useUnitCode);
            String[] companyName = selectedOrgInfo.getCompany().getCompanyName().split("_");
            map.put("useUnitName", companyName.length > 1 ? companyName[1] : companyName[0]);
            map.put("address", commonService.getEnterpriseInfo(useUnitCode).get("address"));
            // 冗余兼容其他业务
            map.put("useUnitAddress", map.get("address"));
            map.put("companyType", "person");
        } else {
            map.put("useUnitCreditCode", selectedOrgInfo.getCompany().getCompanyCode());
            map.put("useUnitName", selectedOrgInfo.getCompany().getCompanyName());
            map.put("address", commonService.getEnterpriseInfo(selectedOrgInfo.getCompany().getCompanyCode()).get("address"));
            // 冗余兼容其他业务
            map.put("useUnitAddress", map.get("address"));
            map.put("companyType", "company");
        }
        return ResponseHelper.buildResponse(map);
    }

    /**
     * 查找当前公司下所属的安全管理员
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/getSecurityAdmin")
    @ApiOperation(httpMethod = "GET", value = "查找当前公司下所属的安全管理员", notes = "查找当前公司下所属的安全管理员")
    public ResponseModel<List<Map<String, Object>>> getSecurityAdmin(@RequestParam(value = "type") String type,
                                                                     @RequestParam(value = "useUnitCode", required = false) String useUnitCode) {
        return ResponseHelper.buildResponse(commonService.getSecurityAdmin(type, useUnitCode));
    }

    /**
     * 设备分类
     *
     * @param type 1，设备种类  2，设备类别  3，设备品种
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/equipmentClassification")
    @ApiOperation(httpMethod = "GET", value = "设备分类", notes = "1，设备种类  2，设备类别  3，设备品种")
    public ResponseModel<List<EquipmentCategoryDto>> equipmentClassification(@RequestParam(value = "type") String type) {
        return ResponseHelper.buildResponse(commonService.equipmentClassification(type));
    }

    /**
     * 设备管道品种
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/equipmentPipeType3ByParentCode")
    @ApiOperation(httpMethod = "GET", value = "设备管道品种", notes = "设备管道品种")
    public ResponseModel<List<EquipmentCategoryDto>> equipmentPipeType3ByParentCode(@RequestParam(value = "parentCode", required = false) String parentCode) {
        return ResponseHelper.buildResponse(commonService.equipmentPipeType3ByParentCode(parentCode));
    }


    /**
     * 设备分类
     *
     * @param type 1，设备种类  2，设备类别  3，设备品种
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/equipmentClassificationByParentCode")
    @ApiOperation(httpMethod = "GET", value = "设备分类", notes = "1，设备种类  2，设备类别  3，设备品种")
    public ResponseModel<List<EquipmentCategoryDto>> equipmentClassificationByParentCode(@RequestParam(value = "type") String type, @RequestParam(value = "parentCode", required = false) String parentCode) {
        return ResponseHelper.buildResponse(commonService.equipmentClassificationByParentCode(type, parentCode));
    }


    /**
     * 设备分类 去掉管道分类
     *
     * @param type 1，设备种类  2，设备类别  3，设备品种
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/equipmentClassificationNoPipeline")
    @ApiOperation(httpMethod = "GET", value = "设备分类", notes = "1，设备种类  2，设备类别  3，设备品种")
    public ResponseModel<List<EquipmentCategoryDto>> equipmentClassificationNoPipeline(@RequestParam(value = "type") String type) {
        return ResponseHelper.buildResponse(commonService.equipmentClassificationNoPipeline(type));
    }

    /**
     * 根据设备种类code获取设备类别
     *
     * @param type 1，设备种类  2，设备类别  3，设备品种
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/equipmentClassificationNoPipelineByParentCode")
    @ApiOperation(httpMethod = "GET", value = "设备分类", notes = "1，设备种类  2，设备类别  3，设备品种")
    public ResponseModel<List<EquipmentCategoryDto>> equipmentClassificationNoPipelineByParentCode(@RequestParam(value = "type") String type, @RequestParam(value = "parentCode", required = false) String parentCode) {
        return ResponseHelper.buildResponse(commonService.equipmentClassificationNoPipelineByParentCode(type, parentCode));
    }

    /**
     * 设备品种
     *
     * @param parentId 父级ID
     * @return list
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/getEquDefineByParentId")
    @ApiOperation(httpMethod = "GET", value = "根据父级ID查询设备品种", notes = "根据父级ID查询设备品种")
    public ResponseModel<List<EquipmentCategoryDto>> getEquDefineByParentId(@RequestParam(value = "parentId") String parentId) {
        return ResponseHelper.buildResponse(commonService.getEquDefineByParentId(parentId));
    }

    /**
     * 查询安全管理员的基本信息
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/getUserInfo")
    @ApiOperation(httpMethod = "GET", value = "查询用户对应联系方式，证件编号", notes = "查询用户对应联系方式，证件编号")
    public ResponseModel<Map<String, Object>> getUserInfo(@RequestParam(value = "sequenceNbr") String sequenceNbr) {
        return ResponseHelper.buildResponse(commonService.getUserInfo(sequenceNbr));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/getUserInfoSplit")
    @ApiOperation(httpMethod = "GET", value = "查询安全管理员的基本信息", notes = "查询安全管理员的基本信息")
    public ResponseModel<Map<String, Object>> getUserInfoSplit(@RequestParam(value = "sequenceNbr", required = false) String sequenceNbr) {
        return Optional.ofNullable(sequenceNbr)
                .filter(s -> s.contains("_"))
                .map(s -> ResponseHelper.buildResponse(commonService.getUserInfo(s.split("_")[0])))
                .orElse(null);
    }

    /**
     * 查询企业的基本信息
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/getEnterpriseInfo")
    @ApiOperation(httpMethod = "GET", value = "查询企业的基本信息", notes = "查询企业的基本信息")
    public ResponseModel<Map<String, Object>> getEnterpriseInfo(@RequestParam(value = "useCode") String useCode) {
        return ResponseHelper.buildResponse(commonService.getEnterpriseInfo(useCode));
    }

    /**
     * 查询企业的下面的人员
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/getEnterpriseEmployee")
    @ApiOperation(httpMethod = "GET", value = "查询企业的下面的人员", notes = "查询企业的下面的人员")
    public ResponseModel<List<Map<String, Object>>> getEnterpriseEmployee(@RequestParam String unitCode) {
        String companyCode = unitCode.split("_")[0];
        return ResponseHelper.buildResponse(commonService.getEnterpriseEmployee(companyCode));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "流程状态枚举列表", notes = "流程状态枚举列表")
    @GetMapping(value = "/flow-status/list")
    public ResponseModel<List<Map<String, Object>>> selectForFlowStatusList() {
        return ResponseHelper.buildResponse(Arrays.stream(FlowStatusEnum.values()).map(this::mapPointTypeToMap).filter(Objects::nonNull).collect(Collectors.toList()));
    }

    private Map<String, Object> mapPointTypeToMap(FlowStatusEnum e) {
        if (FlowStatusEnum.TO_SUBMITTED.getCode() == e.getCode()) {
            return null;
        }
        Map<String, Object> record = new HashMap<>();
        record.put("key", e.getCode());
        record.put("label", e.getName());
        return record;
    }

    /**
     * 查询监管业务名称列表
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "查询监管业务名称列表", notes = "查询监管业务名称列表")
    @GetMapping(value = "/superviseBusinessCategory")
    public ResponseModel<Object> equipTree(@RequestParam(value = "businessType") String businessType, String dataSource) {
        return ResponseHelper.buildResponse(commonService.superviseBusinessCategory(businessType, dataSource));
    }

    /**
     * 查询各类型业务场景
     * 使用单位：按照设备种类，按照应用场景
     * 安装改造维修单位：按照设备种类
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "查询监管业务名称列表", notes = "查询监管业务名称列表")
    @GetMapping(value = "/businessScenarios")
    public ResponseModel<Object> businessScenarios(String type) {
        return ResponseHelper.buildResponse(commonService.businessScenarios(type));
    }


    @Autowired
    private IJgInstallationNoticeService iJgInstallationNoticeService;


    /**
     * 业务发起公共接口
     * /jg/jg-installation-notice/save
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/saveOrSubmit")
    @ApiOperation(httpMethod = "POST", value = "业务发起公共接口", notes = "业务发起公共接口")
    @RestEventTrigger(value = "operateLogRestEventHandler")
    @FieldMapping({
            @FieldMapping.FieldMap(
                    sourceField = "notice.estateUnitSeq",
                    paramIndex = 1,
                    targetField = "notice.estateUnitName",
                    serviceClass = CommonServiceImpl.class,
                    queryMethod = "queryUnitCreditInfoBySeq"),
            @FieldMapping.FieldMap(
                    sourceField = "notice.propertyUnitSeq",
                    paramIndex = 1,
                    targetField = "notice.propertyUnitName",
                    serviceClass = CommonServiceImpl.class,
                    queryMethod = "queryUnitCreditInfoBySeq"),
            @FieldMapping.FieldMap(
                    sourceField = "notice.useUnitSeq",
                    paramIndex = 1,
                    targetField = "notice.useUnitCreditCode",
                    serviceClass = CommonServiceImpl.class,
                    queryMethod = "queryUnitCreditInfoBySeq")
    })
    public ResponseModel<Object> save(@RequestParam(value = "submitType", required = false) String submitType,
                                      @RequestBody Map<String, Object> map) {
        ReginParams reginParams = getSelectedOrgInfo();
        Object result = commonService.invokeBusinessProcess(submitType, map, reginParams);
        return ResponseHelper.buildResponse(result);
    }

    /**
     * 历史平台登记业务发起公共接口
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/saveOrUpdateHistory")
    @ApiOperation(httpMethod = "POST", value = "历史平台登记业务发起公共接口", notes = "历史平台登记业务发起公共接口")
    @RestEventTrigger(value = "operateLogRestEventHandler")
    public ResponseModel<Object> saveOrUpdateHistory(@RequestBody Map<String, Object> map) {
        return ResponseHelper.buildResponse(commonService.invokeBusinessType(map));
    }


    /**
     * 历史平台登记业务使用登记单编辑公共入口
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/updateHistory")
    @ApiOperation(httpMethod = "POST", value = "历史平台登记业务使用登记单编辑公共入口", notes = "历史平台登记业务使用登记单编辑公共入口")
    @RestEventTrigger(value = "operateLogRestEventHandler")
    public ResponseModel<Object> updateHistory(@RequestBody Map<String, Object> map) {
        return ResponseHelper.buildResponse(commonService.updateHistory(map));
    }

    /**
     * 根据公司id获取公司下人员
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/getCompanyUser")
    @ApiOperation(httpMethod = "GET", value = "根据公司id获取公司下人员", notes = "根据公司id获取公司下人员")
    public ResponseModel<Object> getCompanyUser(@RequestParam(value = "companyId", required = false) Long companyId) {
        if (ObjectUtils.isEmpty(companyId)) {
            return null;
        }
        Object result = commonService.getCompanyUser(companyId);
        return ResponseHelper.buildResponse(result);
    }

    /**
     * 获取当前登录人企业类型
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/getCompanyType")
    @ApiOperation(httpMethod = "GET", value = "获取当前登录人企业类型", notes = "获取当前登录人企业类型")
    public ResponseModel<Object> getCompanyType() {
        return ResponseHelper.buildResponse(iJgInstallationNoticeService.getCompanyType());
    }

    /**
     * 获取管辖分局树
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/getCreatTree")
    @ApiOperation(httpMethod = "GET", value = "获取管辖分局树", notes = "获取管辖分局树")
    public ResponseModel<Object> getCreatTree() {
        return ResponseHelper.buildResponse(commonService.getCreatTree());
    }

    /**
     * 获取当前登录人单位及以下管辖分局树
     *
     * @return result
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/loginUnitAndBelow/getCreatTree")
    @ApiOperation(httpMethod = "GET", value = "获取当前登录人单位及以下管辖分局树", notes = "获取当前登录人单位及以下管辖分局树")
    public ResponseModel<Object> loginUnitAndBelowGetTree() {
        String orgCode = getSelectedOrgInfo().getCompany().getOrgCode();
        return ResponseHelper.buildResponse(commonService.loginUnitAndBelowGetTree(orgCode));
    }


    /**
     * 获取当前登录人单位及以下管辖分局树
     *
     * @return result
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/getOrgTreeByCompanyLevel")
    @ApiOperation(httpMethod = "GET", value = "按照当前登录人单位类型返回管辖机构树", notes = "按照当前登录人单位类型返回管辖机构树，")
    public ResponseModel<Object> getOrgTreeByCompanyLevel() {
        ReginParams reginParams = getSelectedOrgInfo();
        String orgCode = reginParams.getCompany().getOrgCode();

        if (reginParams.getCompany().getLevel().equals(BaseController.COMPANY_TYPE_COMPANY)) {  // 公司类型人员返回全部树
            return getCreatTree();
        } else {                                                                               //  监管机构返回当前登录人机构及一下（只考虑非审批机构使用）
            return ResponseHelper.buildResponse(commonService.loginUnitAndBelowGetTree(orgCode));
        }
    }


    /**
     * 获取管辖分局树
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/getCreatTreeByInstallation")
    @ApiOperation(httpMethod = "GET", value = "获取管辖分局树安装告知使用", notes = "获取管辖分局树安装告知使用")
    public ResponseModel<Object> getCreatTreeByInstallation(String county) {
        List<LinkedHashMap> creatTree = commonService.getCreatTreeByInstallation();
        String code = county.split("_")[0];
        List<LinkedHashMap> infoByCounty = getInfoByCounty(code, creatTree);
        return ResponseHelper.buildResponse(infoByCounty);
    }

    private List<LinkedHashMap> getInfoByCounty(String county, List<LinkedHashMap> children) {
        for (LinkedHashMap item : children) {
            if (item.get("companyCode").toString().equals(county)) {
                return (List<LinkedHashMap>) item.get("children");
            } else {
                if (!ObjectUtils.isEmpty(item.get("children"))) {
                    List<LinkedHashMap> children1 = getInfoByCounty(county, (List<LinkedHashMap>) item.get("children"));
                    if (!CollectionUtils.isEmpty(children1)) {
                        return children1;
                    }
                }
            }
        }
        return new ArrayList<>();
    }


    /**
     * 公共转办接口
     * /jg/common/transfer
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/transfer")
    @ApiOperation(httpMethod = "POST", value = "公共转办接口", notes = "公共转办接口")
    @RestEventTrigger(value = "operateLogRestEventHandler")
    public ResponseModel<Object> transfer(@RequestBody Map<String, Object> map) {
        Object result = commonService.transfer(map);
        return ResponseHelper.buildResponse(result);
    }


    /**
     * 校验EQUCODE的唯一性
     *
     * @param equCode EQUCODE
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @GetMapping(value = "/checkUniquenessOfEQUCODE")
    @ApiOperation(httpMethod = "GET", value = "校验EQUCODE的唯一性", notes = "校验EQUCODE的唯一性")
    public ResponseModel<Object> checkUniquenessOfEQUCODE(String equCode) {
        Boolean bool = commonService.checkUniquenessOfEQUCODE(equCode);
        return ResponseHelper.buildResponse(bool);
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @GetMapping(value = "/test-file")
    @ApiOperation(httpMethod = "GET", value = "文件测试", notes = "文件测试")
    public ResponseModel<String> testFile() {
        return ResponseHelper.buildResponse(pdfService.signToPdf("upload/tzs/pdf/1708911268708_temp.pdf", "已作废"));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @GetMapping(value = "/water-print")
    @ApiOperation(httpMethod = "GET", value = "文件测试", notes = "文件测试")
    public ResponseModel<String> signToPdfWaterPrint() {
        return ResponseHelper.buildResponse(pdfService.signToPdfWaterPrint("upload/tzs/pdf/1708911268708_temp.pdf", "已作废"));
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/equList")
    @ApiOperation(httpMethod = "GET", value = "按照业务类型查询设备种类，工作台使用", notes = "按照业务类型查询设备种类，工作台使用")
    public ResponseModel<List<Map<String, Object>>> equList(@RequestParam(value = "type") String bizType) {
        // 在平台字典配置的自定义业务的设备种类：格式{bizType}_SBZL,如BF_YZ_SBZL==》移装注销-设备种类
        String suffix = "_SBZL";
        String dictCode = bizType + suffix;

        List<DictionarieValueModel> resultObj = Systemctl.dictionarieClient.dictValues(dictCode).getResult();
        List<Map<String, Object>> result = resultObj.stream().filter(Objects::nonNull)
                .map(obj -> BeanUtil.beanToMap(obj)).collect(Collectors.toList());
        if (bizType.equals("DJ_CSJ")) {
            result.forEach(e -> {
                if (e.getOrDefault("dictDataKey", "").equals("2000")) {
                    e.put("tips", "变更前需先进行委托检验，在办理变更登记时上传委托检验报告!");
                } else {
                    e.put("tips", "变更前需先进行安全评估，评估结果为改造或重大维修，需办理改造或维修告知，进行监督检验后，再进行变更登记；评估结果为一般维修，需办理定期检验，再进行变更登记!");
                }
            });
        } else {
            result.forEach(e -> e.remove("tips"));
        }
        return ResponseHelper.buildResponse(result);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/equ-category/{categoryCode}/list")
    @ApiOperation(httpMethod = "GET", value = "按照业务类型、设备种类查询设备类别", notes = "按照业务类型、设备种类查询设备类别")
    public ResponseModel<List<DictionarieValueModel>> equCategoryList(@RequestParam(value = "type") String bizType,
                                                                      @RequestParam(value = "businessScenarios") String businessScenarios,
                                                                      @PathVariable String categoryCode) {
        if ("DJ_CSJ".equals(bizType)) { // 超设计年限变更和使用变更共用压力容器字典
            bizType = "DJ_SY";
        }
        // 在平台字典配置的自定义业务的设备种类：格式{bizType}_{categoryCode},如BF_YZ_1000==》移装注销-锅炉
        String dictCode = String.format("%s_%s", bizType, categoryCode);
        List<DictionarieValueModel> result = Systemctl.dictionarieClient.dictValues(dictCode).getResult();
        // 使用登记bizType(DJ_SY) + 压力容器categoryCode（2000） +  按照场景选择businessScenarios（1） => 只展示固定式压力容器（2100）
        boolean isFlag = "DJ_SY".equals(bizType) && "2000".equals(categoryCode) && "1".equals(businessScenarios);
        List<DictionarieValueModel> collect = result.stream()
                .filter(x -> !isFlag || x.getDictDataKey().equals("2100")).collect(Collectors.toList());
        return ResponseHelper.buildResponse(collect);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/equ-category/list")
    @ApiOperation(httpMethod = "GET", value = "告知业务-按照设备类型、设备种类查询设备类别", notes = "按照业务类型、设备种类查询设备类别")
    public ResponseModel<List<DictionarieValueModel>> equCategoryByCodeList(@RequestParam(value = "type") String bizType,
                                                                            @RequestParam(value = "businessScenarios") String businessScenarios,
                                                                            @RequestParam(value = "code") String code) {
        // 在平台字典配置的自定义业务的设备种类：格式{bizType}_{categoryCode},如BF_YZ_1000==》移装注销-锅炉
        String dictCode = String.format("%s_%s", bizType, code);
        List<DictionarieValueModel> result = Systemctl.dictionarieClient.dictValues(dictCode).getResult();
        // 使用登记bizType(DJ_SY) + 压力容器categoryCode（2000） +  按照场景选择businessScenarios（1） => 只展示固定式压力容器（2100）
        //        boolean isFlag = "DJ_SY".equals(bizType) && "2000".equals(code) && "1".equals(businessScenarios);
        //        List<DictionarieValueModel> collect = result.stream()
        //                .filter(x -> !isFlag || x.getDictDataKey().equals("2100")).collect(Collectors.toList());
        return ResponseHelper.buildResponse(result);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/workbench/permission")
    @ApiOperation(httpMethod = "GET", value = "菜单及登录人信息", notes = "菜单及登录人信息")
    public ResponseModel<Map<String, Object>> permissionTree(@RequestParam String menuAgent,
                                                             @RequestParam String permissionType,
                                                             @RequestParam(required = false) String path) {
        Map<String, Object> result = commonService.getPermissionTreeWithCompany(menuAgent, permissionType, path, getSelectedOrgInfo().getCompany());
        return ResponseHelper.buildResponse(result);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/equOnJgServiceOperationRecords")
    @ApiOperation(httpMethod = "GET", value = "查询设备在jg业务中的记录", notes = "查询设备在jg业务中的记录")
    public ResponseModel<List<Map<String, String>>> equOnJgServiceOperationRecords(@RequestParam(value = "record") String record) {
        return ResponseHelper.buildResponse(commonService.equOnJgServiceOperationRecords(record));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/getUserPhone")
    @ApiOperation(httpMethod = "GET", value = "查询当前登录用户公司下的管理员对应联系方式", notes = "查询当前登录用户公司下的管理员对应联系方式，证件编号")
    public ResponseModel<Map<String, Object>> getUserPhone(@RequestParam(value = "name") String name) {
        return ResponseHelper.buildResponse(commonService.getUserPhone(name));
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @GetMapping(value = "/use-flag-test")
    @ApiOperation(httpMethod = "GET", value = "使用标志生成测试", notes = "使用标志生成测试")
    public ResponseModel<String> getUserPhone(HttpServletResponse response) {
        UseFlagParamDto useFlagParamDto = buildUseFlagParam();
        commonService.useFlagGenerate(useFlagParamDto, response);
        return ResponseHelper.buildResponse("succese");
    }

    private UseFlagParamDto buildUseFlagParam() {
        UseFlagParamDto useFlagParamDto = new UseFlagParamDto();
        useFlagParamDto.setEquList("设备种类名称");
        useFlagParamDto.setEquListCode("3000");
        useFlagParamDto.setEquipCode("10001101");
        useFlagParamDto.setEquipDefine("设备品种");
        useFlagParamDto.setUseUnitName("使用单位名称");
        useFlagParamDto.setEquipCategory("设备类别名称");
        useFlagParamDto.setUseInnerCode("单位内编号");
        useFlagParamDto.setReceiveOrgName("登记机关");
        useFlagParamDto.setInspectionUnitName("检验机构名称");
        useFlagParamDto.setUseRegistrationCode("11111");
        useFlagParamDto.setNextInspectionDate(new Date());
        useFlagParamDto.setMaintenanceUnitName("陕西国翔锅炉集团有限公司天水安装销售公司");
        useFlagParamDto.setEmergencyTel("17792961611");
        useFlagParamDto.setCarNumber("车牌号");
        useFlagParamDto.setFactoryNumber("产品编号");
        useFlagParamDto.setCylinderNumOrVolume("12");
        useFlagParamDto.setFillingMedium("氮气");
        useFlagParamDto.setCertificateNo("101");
        return useFlagParamDto;
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/vehicleInformationDict")
    @ApiOperation(httpMethod = "GET", value = "按照类型查询车载气瓶相关的字典值", notes = "按照类型查询车载气瓶相关的字典值")
    public ResponseModel<List<DictionarieValueModel>> vehicleInformationDict(@RequestParam(value = "type") String ype) {
        return ResponseHelper.buildResponse(Systemctl.dictionarieClient.dictValues(ype).getResult());
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @GetMapping(value = "/refreshTheDetailsDataOfCompletedUsageRegistration")
    @ApiOperation(httpMethod = "GET", value = "刷新历史数据脚本：since之前完成使用登记的单子，向历史表中刷入设备的维保信息和安装信息",
            notes = "刷新历史数据脚本：since之前完成使用登记的单子，向历史表中刷入设备的维保信息和安装信息")
    public ResponseModel<Object> refreshTheDetailsDataOfCompletedUsageRegistration(@RequestParam(value = "since") String since) {
        // 查询时间在since之前的已经完成的使用登记单子的seqIds
        List<String> seqLists = commonService.refreshTheDetailsDataOfCompletedUsageRegistration(since);
        // 遍历查询历史表，补充changeData中维保信息和安装信息的数据
        seqLists.forEach(sequenceNbr -> {
            LambdaQueryWrapper<JgRegistrationHistory> lambda = new QueryWrapper<JgRegistrationHistory>().lambda();
            lambda.eq(JgRegistrationHistory::getCurrentDocumentId, sequenceNbr);
            lambda.eq(JgRegistrationHistory::getIsDelete, false);
            JgRegistrationHistory jgRegistrationHistory = jgRegistrationHistoryService.getBaseMapper().selectOne(lambda);
            JSONObject jsonObject = JSONObject.parseObject(jgRegistrationHistory.getChangeData());
            String equipId = String.valueOf(jsonObject.get("equipId"));
            if (!ObjectUtils.isEmpty(equipId)) {
                // 维保信息
                Map<String, Object> maintenanceDetail = jgUseRegistrationMapper.getMaintenanceDetail(equipId);
                if (!ObjectUtils.isEmpty(maintenanceDetail)) {
                    jsonObject.putAll(maintenanceDetail);
                }
                // 安装信息
                Map<String, Object> installDetail = jgUseRegistrationMapper.getiInstallDetail(equipId);
                if (!ObjectUtils.isEmpty(installDetail)) {
                    jsonObject.putAll(installDetail);
                }
                jgRegistrationHistory.setChangeData(JSON.toJSONString(jsonObject));
            }
            jgRegistrationHistoryService.updateById(jgRegistrationHistory);
        });
        return ResponseHelper.buildResponse("success");
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PutMapping(value = "/test-code")
    @ApiOperation(httpMethod = "PUT", value = "code生成测试", notes = "code生成测试")
    public ResponseModel<String> codeTest(@ApiParam("设备种类") @RequestParam String equList,
                                          @ApiParam("设备类别") @RequestParam String equCategory,
                                          @ApiParam("设备品种") @RequestParam(required = false) String equDefine,
                                          @ApiParam("接收机构行政区划") @RequestParam String receiveCompanyCode,
                                          @ApiParam("制造日期") @RequestParam @DateTimeFormat(pattern = "yyyy-MM-dd") Date produceDate) {
        CodeGenerateDto codeGenerateDto = new CodeGenerateDto();
        codeGenerateDto.setEquList(equList);
        codeGenerateDto.setEquCategory(equCategory);
        codeGenerateDto.setEquDefine(equDefine);
        codeGenerateDto.setProduceDate(produceDate);
        codeGenerateDto.setReceiveCompanyCode(receiveCompanyCode);
        return ResponseHelper.buildResponse(codeUtil.generateEquipmentCode(codeGenerateDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PutMapping(value = "/init-code")
    @ApiOperation(httpMethod = "PUT", value = "设备代码初始化-运维专用", notes = "设备代码初始化-运维专用")
    public ResponseModel<String> initEquCode(@ApiParam("设备种类") @RequestParam String equList,
                                             @ApiParam("设备类别") @RequestParam String equCategory,
                                             @ApiParam("设备品种") @RequestParam(required = false) String equDefine,
                                             @ApiParam("接收机构行政区划") @RequestParam String receiveCompanyCode,
                                             @ApiParam("制造日期") @RequestParam @DateTimeFormat(pattern = "yyyy-MM-dd") Date produceDate,
                                             @ApiParam("重置的序列号") @RequestParam(required = false, defaultValue = "0") Long intNumber) {
        CodeGenerateDto codeGenerateDto = new CodeGenerateDto();
        codeGenerateDto.setEquList(equList);
        codeGenerateDto.setEquCategory(equCategory);
        codeGenerateDto.setEquDefine(equDefine);
        codeGenerateDto.setProduceDate(produceDate);
        codeGenerateDto.setReceiveCompanyCode(receiveCompanyCode);
        codeUtil.initCode(codeGenerateDto, intNumber);
        return ResponseHelper.buildResponse("succese");
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PutMapping(value = "/unitType/selected")
    @ApiOperation(httpMethod = "PUT", value = "更新缓存中信息", notes = "更新缓存中信息")
    public ResponseModel<String> updateUnitTypeCache(@ApiParam("单位类型") @RequestParam String unitType, @ApiParam("选择角色") @RequestParam String selectedRoleSeqs) {
        commonService.updateUnitTypeCache(getSelectedOrgInfo(), unitType, selectedRoleSeqs);
        return ResponseHelper.buildResponse("success");
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @GetMapping(value = "/historicalDataProcessingOfPressurePipeline")
    @ApiOperation(httpMethod = "GET", value = "更新压力管道按照单位办理的使用登记历史单子中，管道长度从mm变成m", notes = "更新压力管道按照单位办理的使用登记历史单子中，管道长度从mm变成m")
    public ResponseModel<String> historicalDataProcessingOfPressurePipeline() {
        commonService.historicalDataProcessingOfPressurePipeline();
        return ResponseHelper.buildResponse("success");
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/getLatestJgUseRegistrationManage")
    @ApiOperation(httpMethod = "GET", value = "获取单位下的使用登记证编号", notes = "按照类型查询车载气瓶相关的字典值")
    public ResponseModel<JgUseRegistrationManage> getLatestJgUseRegistrationManage(@RequestParam(value = "equDefineCode") String equDefineCode) {
        CompanyBo company = getSelectedOrgInfo().getCompany();
        return ResponseHelper.buildResponse(commonService.getLatestJgUseRegistrationManage(company.getCompanyCode(), equDefineCode));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/checkEquCodeUniqueness")
    @ApiOperation(httpMethod = "GET", value = "检查设备代码的唯一性", notes = "检查设备代码的唯一性")
    public Boolean checkEquCodeUniqueness(@RequestParam("equCode") String equCode) {
        return commonService.checkEquCodeUniqueness(equCode);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/checkRecordUniqueness")
    @ApiOperation(httpMethod = "GET", value = "检查record的唯一性", notes = "检查record的唯一性")
    public Boolean checkRecordUniqueness(@RequestParam("record") String record) {
        return commonService.checkRecordUniqueness(record);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/checkFactoryNumUniquenessForVehicleCylinder")
    @ApiOperation(httpMethod = "GET", value = "车用气瓶业务里面的 出厂编号/产品编码 校验唯一性（产品编号在车用气瓶范围内全局唯一）", notes = "车用气瓶业务里面的 出厂编号/产品编码 校验唯一性（产品编号在车用气瓶范围内全局唯一）")
    public Integer checkFactoryNumUniquenessForVehicleCylinder(@RequestParam("factoryNum") String factoryNum) {
        return commonService.checkFactoryNumUniquenessForVehicleCylinder(factoryNum, null);
    }

    /**
     * 根据父级code查询子设备分类
     *
     * @param parentCode 父级code
     * @return list
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/getEquClassifyByCode")
    @ApiOperation(httpMethod = "GET", value = "根据父级code查询子设备分类", notes = "根据父级code查询子设备分类")
    public ResponseModel<List<EquipmentClassifyDto>> getEquClassifyByCode(@RequestParam(value = "parentCode", required = false) String parentCode) {
        return ResponseHelper.buildResponse(commonService.getEquClassifyByCode(parentCode));
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "使用登记表生成", notes = "使用登记表生成")
    @PostMapping(value = "/getRegistrationFormUrl")
    @FieldMapping({@FieldMapping.FieldMap(sourceField = "formData.estateUnitSeq", targetField = "formData.estateUnitName", serviceClass = CommonServiceImpl.class, queryMethod = "queryUnitCreditInfoBySeq", overrideSource = true)})
    public ResponseModel<Map<String, Object>> getRegistrationFormUrl(@RequestBody JSONObject map) {
        JSONObject formData = JSONObject.parseObject(JSONObject.toJSONString(map.get("formData")));
        String manageType = String.valueOf(map.get("manageType"));
        ReginParams selectedOrgInfo = getSelectedOrgInfo();
        formData.put("userName", selectedOrgInfo.getUserModel().getRealName());
        return ResponseHelper.buildResponse(commonService.getRegistrationFormUrl(manageType, formData));
    }

    /**
     * 超设计使用变更登记变更证明生成
     *
     * @param map 参数
     * @return 变更证明url
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "超设计使用变更登记变更证明生成", notes = "超设计使用变更登记变更证明生成")
    @PostMapping(value = "/getRegistrationChangeCertificateUrl")
    public ResponseModel<Map<String, Object>> getRegistrationChangeCertificateUrl(@RequestBody JSONObject map) {
        JSONObject formData = JSONObject.parseObject(JSONObject.toJSONString(map.get("formData")));
        ReginParams selectedOrgInfo = getSelectedOrgInfo();
        formData.put("userName", selectedOrgInfo.getUserModel().getRealName());
        return ResponseHelper.buildResponse(commonService.getRegistrationChangeCertificateUrl(formData));
    }

    /**
     * 超设计使用变更登记变更证明生成pdf流生成
     * @param response
     * @param jsonObject
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "超设计使用变更登记变更证明生成pdf流生成", notes = "超设计使用变更登记变更证明生成pdf流生成")
    @PostMapping(value = "/getRegistrationChangeCertificateFormStream")
    public void getRegistrationChangeCertificateFormStream(HttpServletResponse response, @RequestBody JSONObject jsonObject) {
        commonService.getRegistrationChangeCertificateFormStream(jsonObject, response);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "pdf流生成", notes = "pdf流生成")
    @PostMapping(value = "/getRegistrationFormStream")
    @FieldMapping({@FieldMapping.FieldMap(sourceField = "formData.estateUnitSeq", targetField = "formData.estateUnitName", serviceClass = CommonServiceImpl.class, queryMethod = "queryUnitCreditInfoBySeq")})
    public void getRegistrationFormStream(@RequestBody JSONObject map, HttpServletResponse response) {
        JSONObject formData = JSONObject.parseObject(JSONObject.toJSONString(map.get("formData")));
        String manageType = String.valueOf(map.get("manageType"));
        ReginParams selectedOrgInfo = getSelectedOrgInfo();
        formData.put("userName", selectedOrgInfo.getUserModel().getRealName());
        commonService.getRegistrationFormStream(formData, manageType, response);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "补证申请表生成", notes = "补证申请表生成")
    @PostMapping(value = "/getCertReplenishFormUrl")
    public ResponseModel<Map<String, Object>> getCertReplenishFormUrl(@RequestBody JSONObject jsonObject) {
        return ResponseHelper.buildResponse(iJgCertificateReplenishService.getCertReplenishFormUrl(jsonObject.getJSONObject(FORM_DATA), null));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "补证pdf流生成", notes = "补证pdf流生成")
    @PostMapping(value = "/getCertReplenishFormStream")
    public void getCertReplenishFormStream(HttpServletResponse response, @RequestBody JSONObject jsonObject) {
        iJgCertificateReplenishService.getCertReplenishFormStream(jsonObject, response);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "使用登记表/补证申请表生成", notes = "使用登记表/补证申请表生成")
    @PostMapping(value = "/getRegistrationOrCertReplenishFormUrl")
    @FieldMapping({@FieldMapping.FieldMap(sourceField = "formData.estateUnitSeq", targetField = "formData.estateUnitName", serviceClass = CommonServiceImpl.class, queryMethod = "queryUnitCreditInfoBySeq")})
    public ResponseModel<Map<String, Object>> getRegistrationOrCertReplenishFormUrl(@RequestBody JSONObject jsonObject) {
        String formBusinessType = Objects.toString(jsonObject.get("formBusinessType"));
        if (ApplicationFormTypeEnum.BZDJ.getBusinessCode().equals(formBusinessType)) {
            return ResponseHelper.buildResponse(iJgCertificateReplenishService.getCertReplenishFormUrl(jsonObject.getJSONObject(FORM_DATA), null));
        }
        if (ApplicationFormTypeEnum.SYDJ.getBusinessCode().equals(formBusinessType)) {
            JSONObject formData = JSONObject.parseObject(JSONObject.toJSONString(jsonObject.get("formData")));
            String manageType = String.valueOf(jsonObject.get("manageType"));
            ReginParams selectedOrgInfo = getSelectedOrgInfo();
            formData.put("userName", selectedOrgInfo.getUserModel().getRealName());
            return ResponseHelper.buildResponse(commonService.getRegistrationFormUrl(manageType, formData));
        }
        return ResponseHelper.buildResponse(null);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/getDictListWithParentIds")
    @ApiOperation(httpMethod = "GET", value = "根据字典的父Ids获取字典值", notes = "根据字典的父Ids获取字典值")
    public ResponseModel<List<DataDictionary>> getDictListWithParentIds(@RequestParam(value = "parentIds") String parentIds) {
        return ResponseHelper.buildResponse(iDataDictionaryService.lambdaQuery()
                .eq(DataDictionary::getIsDelete, Boolean.FALSE)
                .in(DataDictionary::getParent, new ArrayList<>(Arrays.asList(parentIds.split(","))))
                .list());
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/getUnitInfoList")
    @ApiOperation(httpMethod = "GET", value = "通过单位类型获取单位列表-返回数据主键", notes = "通过单位类型获取单位列表-返回数据主键")
    public ResponseModel<List<Map<String, Object>>> getUnitInfoList(@RequestParam(value = "type") String type,
                                                                @RequestParam(value = "business", required = false) String business) {
        return ResponseHelper.buildResponse(commonService.getUnitListByType(type, business, true));
    }
}
