package com.yeejoin.amos.boot.module.jg.biz.controller;

import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.JgBizChangeLogServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import java.util.Map;

@RestController
@RequestMapping(value = "/change-log")
@Api(tags = "设备编辑操作日志控制器")
@RequiredArgsConstructor
public class JgBizChangeLogController extends BaseController {

    private final JgBizChangeLogServiceImpl jgBizChangeLogService;

    /**
     * 根据changeLogId查询详情
     *
     * @param changeLogId 主键
     * @return ResponseModel
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/details")
    @ApiOperation(httpMethod = "GET", value = "根据changeLogId查询设备编辑详情", notes = "根据changeLogId查询设备编辑详情")
    public ResponseModel<Map<String, Object>> getDetails(@RequestParam("changeLogId") String changeLogId) {
        return ResponseHelper.buildResponse(jgBizChangeLogService.getDetails(changeLogId));
    }
}
