package com.yeejoin.amos.boot.module.jg.biz.edit;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.module.jg.api.dto.RequestChangeData;
import com.yeejoin.amos.boot.module.jg.biz.context.BizDataHandleStrategyContext;
import com.yeejoin.amos.boot.module.jg.biz.controller.BizDataChangeController;
import com.yeejoin.amos.boot.module.jg.biz.edit.process.biz.strategy.IBizDataChangeHandleStrategy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Map;

@Service
public class BizDataChangeServiceImpl {


    /**
     * 变更保存
     *
     * @param applyNo         单据编号
     * @param bizType         业务类型
     * @param modelType       处理器类型
     * @param changeData      变化后的数据
     * @param selectedOrgInfo  登录人信息
     */
    @Transactional(rollbackFor = Exception.class)
    public void save(String bizId,
                     String applyNo,
                     String bizType,
                     IBizDataChangeHandleStrategy.ModelType modelType, RequestChangeData changeData, ReginParams selectedOrgInfo) {
        IBizDataChangeHandleStrategy handleStrategy = BizDataHandleStrategyContext.getStrategy(bizType);
        handleStrategy.doSave(bizId, applyNo, modelType, changeData, selectedOrgInfo);
    }

    public IPage<?> queryDetail(String applyNo, String bizType, BizDataChangeController.DetailType type, JSONObject searchParams) {
        IBizDataChangeHandleStrategy handleStrategy = BizDataHandleStrategyContext.getStrategy(bizType);
        return handleStrategy.getDetail(applyNo, type, searchParams);
    }

    public Map<String, ?> querySubDetail(String applyNo, String bizId, String bizType, BizDataChangeController.DetailType type) {
        IBizDataChangeHandleStrategy handleStrategy = BizDataHandleStrategyContext.getStrategy(bizType);
        return handleStrategy.getSubDetail(applyNo, bizId, type);
    }

    public IPage<?> getChangeLogPage(String bizId, String bizType, int current, int size) {
        IBizDataChangeHandleStrategy handleStrategy = BizDataHandleStrategyContext.getStrategy(bizType);
        return handleStrategy.getChangeLogs(bizId, current, size);
    }
}
