package com.yeejoin.amos.boot.module.jg.biz.edit.core;

import com.yeejoin.amos.boot.module.jg.biz.edit.event.BaseBizDataChangeEvent;
import lombok.RequiredArgsConstructor;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

@Component
@RequiredArgsConstructor
public class RouterEventPublisher implements IEventPublisher<BaseBizDataChangeEvent> {

    private final ApplicationContext applicationContext;

    private final Map<Class<?>, String> publisherCache = new ConcurrentHashMap<>();

    @Override
    public void publish(BaseBizDataChangeEvent event) {
        String publisherName = resolvePublisherName(event.getClass());
        IEventPublisher<BaseBizDataChangeEvent> publisher = applicationContext.getBean(publisherName, IEventPublisher.class);
        Optional.ofNullable(publisher).orElseGet(this::getDefaultPublisher).publish(event);
    }


    private String resolvePublisherName(Class<?> eventClass) {
        return publisherCache.computeIfAbsent(eventClass, clz -> {
            EventPublisherMapping annotation = clz.getAnnotation(EventPublisherMapping.class);
            return (annotation != null) ? annotation.value() : "defaultEventPublisher";
        });
    }

    private IEventPublisher<BaseBizDataChangeEvent> getDefaultPublisher() {
        return applicationContext.getBean("defaultEventPublisher", IEventPublisher.class);
    }
}
