package com.yeejoin.amos.boot.module.jg.biz.edit.process.biz.installNotice;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import com.yeejoin.amos.boot.module.jg.api.dto.FieldChangeMeta;
import com.yeejoin.amos.boot.module.jg.api.entity.JgInstallationNotice;
import com.yeejoin.amos.boot.module.jg.api.enums.BusinessTypeEnum;
import com.yeejoin.amos.boot.module.jg.biz.edit.core.RouterEventPublisher;
import com.yeejoin.amos.boot.module.jg.biz.edit.event.BaseBizDataChangeEvent;
import com.yeejoin.amos.boot.module.jg.biz.edit.process.biz.DefaultBizDataChangeHandler;
import com.yeejoin.amos.boot.module.ymt.api.enums.FlowStatusEnum;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

import java.util.*;

@Component
public class InstallNoticeDataChangeHandler extends DefaultBizDataChangeHandler<BaseBizDataChangeEvent> {

    private final InstallNoticeEditUpdateService installNoticeEditUpdateService;

    protected InstallNoticeDataChangeHandler(InstallNoticeEditUpdateService installNoticeEditUpdateService, RouterEventPublisher routerEventPublisher, ApplicationContext applicationContext) {
        super(routerEventPublisher, applicationContext);
        this.installNoticeEditUpdateService = installNoticeEditUpdateService;
    }

    @Override
    public String canHandleBizType() {
        return BusinessTypeEnum.JG_INSTALLATION_NOTIFICATION.name();
    }

    @Override
    public List<FieldChangeMeta> updBizData(String bizId, String applyNo, ModelType model, Map<String, Object> changeData) {
        return Collections.emptyList();
    }

    @Override
    public Boolean beforeCheck(String bizId, String applyNo, ModelType model, Map<String, Object> changeData) {
        return true;
    }

    @Override
    public Set<String> getEqs(String applyNo) {
        return installNoticeEditUpdateService.getEqsByApplyNo(applyNo);
    }

    @Override
    public List<FieldChangeMeta> updCertDataIfBizFin(String bizId, String applyNo, ModelType model, Map<String, Object> changeData) {
        return Collections.emptyList();
    }

    @Override
    public Boolean bizIsFinished(String applyNo, ModelType model, Map<String, Object> changeData) {
        JgInstallationNotice installationNotice = installNoticeEditUpdateService.getInstallationNoticeService().getOne(new LambdaQueryWrapper<JgInstallationNotice>().eq(JgInstallationNotice::getApplyNo, applyNo).select(BaseEntity::getSequenceNbr, JgInstallationNotice::getNoticeStatus));
        return installationNotice.getNoticeStatus().equals(String.valueOf(FlowStatusEnum.TO_BE_FINISHED.getCode()));
    }

    @Override
    public Set<String> getProjectContraptionIds(String applyNo) {
        JgInstallationNotice installationNotice = installNoticeEditUpdateService.getOneByApplyNo(applyNo);
        Set<String> projectContraptionIds = new HashSet<>();
        projectContraptionIds.add(installationNotice.getProjectContraptionId());
        projectContraptionIds.remove(null);
        projectContraptionIds.remove("");
        return projectContraptionIds;
    }
}
