package com.yeejoin.amos.boot.module.jg.biz.edit.process.biz.installNotice;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import com.yeejoin.amos.boot.module.jg.api.entity.JgInstallationNotice;
import com.yeejoin.amos.boot.module.jg.api.entity.JgInstallationNoticeEq;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.JgInstallationNoticeEqServiceImpl;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.JgInstallationNoticeServiceImpl;
import lombok.Getter;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

@Service
@RequiredArgsConstructor
@Getter
public class InstallNoticeEditUpdateService {
    private final JgInstallationNoticeServiceImpl installationNoticeService;

    private final JgInstallationNoticeEqServiceImpl installationNoticeEqService;

    public Set<String> getEqsByApplyNo(String applyNo) {
        JgInstallationNotice jgInstallationNotice = installationNoticeService.getOne(new LambdaQueryWrapper<JgInstallationNotice>().eq(JgInstallationNotice::getApplyNo, applyNo).select(BaseEntity::getSequenceNbr));
        List<JgInstallationNoticeEq> eqs = installationNoticeEqService.list(new LambdaQueryWrapper<JgInstallationNoticeEq>().eq(JgInstallationNoticeEq::getEquipTransferId, jgInstallationNotice.getSequenceNbr()).select(JgInstallationNoticeEq::getEquId));
        return eqs.stream().map(JgInstallationNoticeEq::getEquId).collect(Collectors.toSet());
    }

    public JgInstallationNotice getOneByApplyNo(String applyNo) {
        return installationNoticeService.getOne(new LambdaQueryWrapper<JgInstallationNotice>().eq(JgInstallationNotice::getApplyNo, applyNo));
    }
}
