package com.yeejoin.amos.boot.module.jg.biz.edit.process.biz.useRegister;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import com.yeejoin.amos.boot.module.jg.api.dto.FieldChangeMeta;
import com.yeejoin.amos.boot.module.jg.api.entity.JgUseRegistration;
import com.yeejoin.amos.boot.module.jg.api.entity.JgUseRegistrationEq;
import com.yeejoin.amos.boot.module.jg.api.enums.BusinessTypeEnum;
import com.yeejoin.amos.boot.module.jg.biz.controller.BizDataChangeController;
import com.yeejoin.amos.boot.module.jg.biz.edit.core.RouterEventPublisher;
import com.yeejoin.amos.boot.module.jg.biz.edit.event.BaseBizDataChangeEvent;
import com.yeejoin.amos.boot.module.jg.biz.edit.process.biz.DefaultBizDataChangeHandler;
import com.yeejoin.amos.boot.module.ymt.api.enums.FlowStatusEnum;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;

@Service
public class UseRegisterDataChangeHandler extends DefaultBizDataChangeHandler<BaseBizDataChangeEvent> {


    private final UseRegisterUpdateService useRegisterUpdateService;

    protected UseRegisterDataChangeHandler(RouterEventPublisher routerEventPublisher, UseRegisterUpdateService useRegisterUpdateService, ApplicationContext applicationContext) {
        super(routerEventPublisher, applicationContext);
        this.useRegisterUpdateService = useRegisterUpdateService;
    }


    @Override
    public String canHandleBizType() {
        return BusinessTypeEnum.JG_USAGE_REGISTRATION.name();
    }


    /**
     * 保存
     *
     * @param applyNo    单据编号
     * @param model      single, batch
     * @param changeData 前端不支持分组-目前为平铺数据结构
     */
    @Override
    public List<FieldChangeMeta> updBizData(String bizId, String applyNo, ModelType model, Map<String, Object> changeData) {
        List<FieldChangeMeta> bizEditColumns = new ArrayList<>();
        // 1.流程中时-更新单据-业务冗余的字段
        this.updateBizInfo(changeData);
        return bizEditColumns;
    }

    private void updateBizInfo(Map<String, Object> changeData) {
        useRegisterUpdateService.updateBizInfo(changeData);
    }

    @Override
    public Boolean beforeCheck(String bizId, String applyNo, ModelType model, Map<String, Object> changeData) {
        return true;
    }

    @Override
    public Set<String> getEqs(String applyNo) {
        JgUseRegistration useRegistration = useRegisterUpdateService.getJgUseRegistrationService().getOne(new LambdaQueryWrapper<JgUseRegistration>().select(BaseEntity::getSequenceNbr).eq(JgUseRegistration::getApplyNo, applyNo));
        List<JgUseRegistrationEq> eqs = useRegisterUpdateService.getUseRegistrationEqService().list(new LambdaQueryWrapper<JgUseRegistrationEq>().select(JgUseRegistrationEq::getEquId).eq(JgUseRegistrationEq::getEquipTransferId, useRegistration.getSequenceNbr()));
        return eqs.stream().map(JgUseRegistrationEq::getEquId).collect(Collectors.toSet());
    }

    @Override
    public List<FieldChangeMeta> updCertDataIfBizFin(String bizId, String applyNo, ModelType model, Map<String, Object> changeData) {
        // 更新设备/装置的使用信息
        return useRegisterUpdateService.updCertDataIfBizFin(applyNo, new JSONObject(changeData));
    }

    @Override
    public Boolean bizIsFinished(String applyNo, ModelType model, Map<String, Object> changeData) {
        JgUseRegistration useRegistration = useRegisterUpdateService.getJgUseRegistrationService().getOne(new LambdaQueryWrapper<JgUseRegistration>().eq(JgUseRegistration::getApplyNo, applyNo));
        return useRegistration.getStatus().equals(FlowStatusEnum.TO_BE_FINISHED.getName());
    }

    @Override
    public Set<String> getProjectContraptionIds(String applyNo) {
        JgUseRegistration useRegistration = useRegisterUpdateService.getJgUseRegistrationService().getOne(new LambdaQueryWrapper<JgUseRegistration>().select(BaseEntity::getSequenceNbr, JgUseRegistration::getApplyNo, JgUseRegistration::getProjectContraptionId).eq(JgUseRegistration::getApplyNo, applyNo));
        Set<String> projectContraptionIds = new HashSet<>();
        projectContraptionIds.add(useRegistration.getProjectContraptionId());
        projectContraptionIds.remove(null);
        projectContraptionIds.remove("");
        return projectContraptionIds;
    }


}
