package com.yeejoin.amos.boot.module.jg.biz.edit.process.equip;


import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.annotation.FieldDisplayDefine;
import com.yeejoin.amos.boot.biz.common.annotation.Group;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import com.yeejoin.amos.boot.module.common.api.dto.IBaseChangeData;
import com.yeejoin.amos.boot.module.jg.api.dto.*;
import com.yeejoin.amos.boot.module.jg.api.enums.EquipSourceEnum;
import com.yeejoin.amos.boot.module.jg.biz.service.*;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.IdxBizJgProjectContraptionServiceImpl;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.IdxBizJgUseInfoServiceImpl;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.JgUseRegistrationServiceImpl;
import com.yeejoin.amos.boot.module.ymt.api.entity.*;
import com.yeejoin.amos.boot.module.ymt.api.enums.EquimentEnum;
import com.yeejoin.amos.boot.module.ymt.api.enums.EquipmentClassifityEnum;
import com.yeejoin.amos.boot.module.ymt.api.mapper.IdxBizJgDesignInfoMapper;
import com.yeejoin.amos.boot.module.ymt.api.mapper.IdxBizJgFactoryInfoMapper;
import com.yeejoin.amos.boot.module.ymt.api.mapper.IdxBizJgOtherInfoMapper;
import com.yeejoin.amos.boot.module.ymt.api.mapper.IdxBizJgRegisterInfoMapper;
import lombok.Getter;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;

import javax.annotation.PostConstruct;
import java.io.IOException;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import static com.yeejoin.amos.boot.module.jg.biz.edit.core.SubClassFinder.getAllSubClasses;
import static com.yeejoin.amos.boot.module.jg.biz.edit.utils.ReflectiveFieldAccessor.getAllFields;
import static com.yeejoin.amos.boot.module.jg.biz.service.impl.IdxBizJgProjectContraptionServiceImpl.PROJECT_CONTRAPTION;
import static com.yeejoin.amos.boot.module.jg.biz.service.impl.IdxBizJgProjectContraptionServiceImpl.PROJECT_CONTRAPTION_NO;
import static com.yeejoin.amos.boot.module.jg.biz.service.impl.IdxBizJgRegisterInfoServiceImpl.*;
import static com.yeejoin.amos.boot.module.jg.biz.service.impl.JgCertificateReplenishServiceImpl.SEQUENCE_NBR;

@Component
@RequiredArgsConstructor
@Slf4j
@Getter
public class CommonEquipDataProcessService {

    private final IdxBizJgDesignInfoMapper idxBizJgDesignInfoMapper;

    private final IdxBizJgFactoryInfoMapper jgFactoryInfoMapper;

    private final IdxBizJgRegisterInfoMapper idxBizJgRegisterInfoMapper;

    private final IIdxBizJgTechParamsElevatorService iIdxBizJgTechParamsElevatorService;

    private final IIdxBizJgTechParamsVehicleService iIdxBizJgTechParamsVehicleService;

    private final IIdxBizJgTechParamsRopewayService iIdxBizJgTechParamsRopewayService;

    private final IIdxBizJgTechParamsRidesService iIdxBizJgTechParamsRidesService;

    private final IIdxBizJgTechParamsBoilerService iIdxBizJgTechParamsBoilerService;

    private final IIdxBizJgTechParamsVesselService iIdxBizJgTechParamsVesselService;

    private final IIdxBizJgTechParamsPipelineService iIdxBizJgTechParamsPipelineService;

    private final IIdxBizJgTechParamsLiftingService iIdxBizJgTechParamsLiftingService;

    private final EquipChangeDataUpdateServiceImpl equipChangeDataUpdateServiceImpl;

    private final IdxBizJgUseInfoServiceImpl idxBizJgUseInfoService;

    private final List<String> jsonFields = new ArrayList<>();

    private final IdxBizJgOtherInfoMapper idxBizJgOtherInfoMapper;

    private final RestHighLevelClient restHighLevelClient;

    private final IdxBizJgProjectContraptionServiceImpl idxBizJgProjectContraptionServiceImpl;

    private final JgUseRegistrationServiceImpl jgUseRegistrationService;

    public static final String BASE_COLUMN_REC_DATE = "\"REC_DATE\"";
    public static final String BASE_COLUMN_REC_USERID = "\"REC_USER_ID\"";

    @PostConstruct
    public void init() {
        Set<Class<? extends IBaseChangeData>> subClasses = getAllSubClasses();
        for (Class<? extends IBaseChangeData> subClass : subClasses) {
            Field[] fields = subClass.getDeclaredFields();
            for (Field field : fields) {
                field.setAccessible(true);
                FieldDisplayDefine fieldDisplayDefine = field.getAnnotation(FieldDisplayDefine.class);
                if (fieldDisplayDefine != null && fieldDisplayDefine.type() == JSON.class) {
                    jsonFields.add(field.getName());
                }
            }
        }
    }

    public static <T extends BaseChangeDataDto> T castMap2Bean(Map<String, Object> map, Class<T> clazz) {
        try {
            T t = clazz.newInstance();
            BeanUtil.copyProperties(JSON.parse(JSONObject.toJSONString(map)), t, true);
            return t;
        } catch (InstantiationException | IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T extends IBaseChangeData> void castMap2Bean(Map<String, Object> map, T target) {
        BeanUtil.copyProperties(JSON.parse(JSONObject.toJSONString(map)), target, true);
    }


    public void checkValidField(String record, BaseChangeDataDto changeDataDto, String equList, String equCategory, String equDefine) {
        // 注册信息
        if (changeDataDto instanceof EquipRegisterChangeDataDto) {
            EquipRegisterChangeDataDto registerChangeDataDto = (EquipRegisterChangeDataDto) changeDataDto;
            equipChangeDataUpdateServiceImpl.checkRegisterChangeData(record, registerChangeDataDto);
        }
        // 制造信息
        if (changeDataDto instanceof EquipFactoryChangeDataDto) {
            EquipFactoryChangeDataDto equipFactoryChangeDataDto = (EquipFactoryChangeDataDto) changeDataDto;
            equipChangeDataUpdateServiceImpl.checkFactoryChangeData(record, equipFactoryChangeDataDto, equList, equCategory, equDefine);
        }
        // 设计信息
        if (changeDataDto instanceof EquipDesignChangeDataDto) {
            EquipDesignChangeDataDto equipDesignChangeDataDto = (EquipDesignChangeDataDto) changeDataDto;
            equipChangeDataUpdateServiceImpl.checkDesignChangeData(record, equipDesignChangeDataDto);
        }
    }

    public void checkValidField2(String record, IBaseChangeData changeDataDto, String equList, String equCategory, String equDefine) {
        // 注册信息
        if (changeDataDto instanceof IdxBizJgRegisterInfo) {
            IdxBizJgRegisterInfo registerChangeDataDto = (IdxBizJgRegisterInfo) changeDataDto;
            equipChangeDataUpdateServiceImpl.checkRegisterChangeData(record, registerChangeDataDto);
        }
        // 制造信息
        if (changeDataDto instanceof IdxBizJgFactoryInfo) {
            IdxBizJgFactoryInfo equipFactoryChangeDataDto = (IdxBizJgFactoryInfo) changeDataDto;
            equipChangeDataUpdateServiceImpl.checkFactoryChangeData(record, equipFactoryChangeDataDto, equList, equCategory, equDefine);
        }
        // 设计信息
        if (changeDataDto instanceof IdxBizJgDesignInfo) {
            IdxBizJgDesignInfo equipDesignChangeDataDto = (IdxBizJgDesignInfo) changeDataDto;
            equipChangeDataUpdateServiceImpl.checkDesignChangeData(record, equipDesignChangeDataDto);
        }
    }


    public void buildChangeFields(String record, EquipDesignChangeDataDto equipDesignChangeDataDto, EquipFactoryChangeDataDto equipFactoryChangeDataDto, EquipRegisterChangeDataDto registerChangeDataDto, EquipOtherInfoChangeDataDto otherInfoChangeDataDto, EquipUseInfoChangeDataDto useInfoChangeDataDto, List<FieldChangeMeta> allChangeColumns) {
        // 构造新对象行转列
        List<FieldChangeMeta> designInfoNew = this.buildDesignInfoNew(equipDesignChangeDataDto, record);
        List<FieldChangeMeta> factoryInfoNew = this.buildFactoryInfoNew(equipFactoryChangeDataDto, record);
        List<FieldChangeMeta> registerInfoNew = this.buildRegisterInfoNew(registerChangeDataDto, record);
        if (useInfoChangeDataDto != null) {
            List<FieldChangeMeta> useInfoNew = convertBeanField2Column2(useInfoChangeDataDto, record);
            List<FieldChangeMeta> useInfoOld = this.buildUseInfoOld(record);
            allChangeColumns.addAll(mergeChangeFields(useInfoNew, useInfoOld));
        }
        if (otherInfoChangeDataDto != null) {
            List<FieldChangeMeta> otherInfoNew = convertBeanField2Column2(otherInfoChangeDataDto, record);
            List<FieldChangeMeta> otherInfoOld = this.buildOtherInfoOld(record);
            allChangeColumns.addAll(mergeChangeFields(otherInfoNew, otherInfoOld));

        }
        // 老数据查询行转列
        List<FieldChangeMeta> designInfoOld = this.buildDesignInfoOld(record);
        List<FieldChangeMeta> factoryInfoOld = this.buildFactoryInfoOld(record);
        List<FieldChangeMeta> registerInfoOld = this.buildRegisterInfoOld(record);
        allChangeColumns.addAll(mergeChangeFields(designInfoNew, designInfoOld));
        allChangeColumns.addAll(mergeChangeFields(factoryInfoNew, factoryInfoOld));
        allChangeColumns.addAll(mergeChangeFields(registerInfoNew, registerInfoOld));
    }

    public void buildChangeFields(String record, EquipDesignChangeDataDto equipDesignChangeDataDto, EquipFactoryChangeDataDto equipFactoryChangeDataDto, EquipRegisterChangeDataDto registerChangeDataDto, EquipUseInfoChangeDataDto useInfoChangeDataDto, List<FieldChangeMeta> allChangeColumns) {
        // 构造新对象行转列
        List<FieldChangeMeta> designInfoNew = convertBeanField2Column2(equipDesignChangeDataDto, record);
        List<FieldChangeMeta> factoryInfoNew = convertBeanField2Column2(equipFactoryChangeDataDto, record);
        List<FieldChangeMeta> registerInfoNew = convertBeanField2Column2(registerChangeDataDto, record);
        List<FieldChangeMeta> useInfoChangeNew = convertBeanField2Column2(useInfoChangeDataDto, record);
        // 老数据查询行转列
        List<FieldChangeMeta> designInfoOld = this.buildDesignInfoOld(record);
        List<FieldChangeMeta> factoryInfoOld = this.buildFactoryInfoOld(record);
        List<FieldChangeMeta> registerInfoOld = this.buildRegisterInfoOld(record);
        List<FieldChangeMeta> useInfoOld = this.buildUseInfoOld(record);
        allChangeColumns.addAll(mergeChangeFields(designInfoNew, designInfoOld));
        allChangeColumns.addAll(mergeChangeFields(factoryInfoNew, factoryInfoOld));
        allChangeColumns.addAll(mergeChangeFields(registerInfoNew, registerInfoOld));
        allChangeColumns.addAll(mergeChangeFields(useInfoChangeNew, useInfoOld));
    }


    /**
     * 业务处理-业务对象
     *
     * @param record        设备主键
     * @param changeDataDto 变更后数据
     */
    public void dealBizDataForEquip(String record, BaseChangeDataDto changeDataDto) {
        // 注册信息
        if (changeDataDto instanceof EquipRegisterChangeDataDto) {
            EquipRegisterChangeDataDto registerChangeDataDto = (EquipRegisterChangeDataDto) changeDataDto;
            equipChangeDataUpdateServiceImpl.updateRegisterChangeData(record, registerChangeDataDto);
        }
        // 制造信息
        if (changeDataDto instanceof EquipFactoryChangeDataDto) {
            EquipFactoryChangeDataDto equipFactoryChangeDataDto = (EquipFactoryChangeDataDto) changeDataDto;
            equipChangeDataUpdateServiceImpl.updateFactoryChangeData(record, equipFactoryChangeDataDto);
        }
        // 设计信息
        if (changeDataDto instanceof EquipDesignChangeDataDto) {
            EquipDesignChangeDataDto equipDesignChangeDataDto = (EquipDesignChangeDataDto) changeDataDto;
            equipChangeDataUpdateServiceImpl.updateDesignChangeData(record, equipDesignChangeDataDto);
        }
        // 使用信息
        if (changeDataDto instanceof EquipUseInfoChangeDataDto) {
            EquipUseInfoChangeDataDto equipUseInfoChangeDataDto = (EquipUseInfoChangeDataDto) changeDataDto;
            equipChangeDataUpdateServiceImpl.updateUseInfoChangeData(record, equipUseInfoChangeDataDto);
        }
        // 检验信息
        if (changeDataDto instanceof EquipInspectChangeDataDto) {
            EquipInspectChangeDataDto equipUseInfoChangeDataDto = (EquipInspectChangeDataDto) changeDataDto;
            equipChangeDataUpdateServiceImpl.updateOrSaveInspectInfo(record, equipUseInfoChangeDataDto);
        }
        // 气瓶钢印信息
        if (changeDataDto instanceof EquipOtherInfoChangeDataDto) {
            EquipOtherInfoChangeDataDto otherInfoChangeDataDto = (EquipOtherInfoChangeDataDto) changeDataDto;
            equipChangeDataUpdateServiceImpl.updateOtherInfoChangeData(record, otherInfoChangeDataDto);
        }

    }

    private String buildTableName(Class<?> clazz) {
        Group group = clazz.getAnnotation(Group.class);
        return String.format("\"%s_%s\"", "idx_biz_jg", group.value());
    }


    public static List<FieldChangeMeta> mergeChangeFields(List<FieldChangeMeta> changeDataNew, List<FieldChangeMeta> changeDataOld) {
        Map<String, FieldChangeMeta> oldKv = changeDataOld.stream().collect(Collectors.toMap(FieldChangeMeta::getColumnKey, Function.identity()));
        changeDataNew.forEach(o -> {
            // 正常不会出现此情况，old数据 大于等于 new 数据的key
            if (oldKv.get(o.getColumnKey()) != null) {
                o.setColumnOldValue(oldKv.get(o.getColumnKey()).getColumnOldValue());
            }
        });
        return changeDataNew.stream().filter(n -> !StringUtils.equals(n.getColumnNewValue(), n.getColumnOldValue())).collect(Collectors.toList());
    }

    private static TechParamsBoilerChangeFieldDto getTechParamsBoilerChangeField(Map<String, Object> changeData) {
        TechParamsBoilerChangeFieldDto newBoiler = new TechParamsBoilerChangeFieldDto();
        BeanUtil.copyProperties(JSON.parse(JSONObject.toJSONString(changeData)), newBoiler, true);
        return newBoiler;
    }

    private TechParamsBoilerChangeFieldDto getTechParamsBoilerChangeField(String record) {
        IdxBizJgTechParamsBoiler boiler = iIdxBizJgTechParamsBoilerService.getOneData(record);
        TechParamsBoilerChangeFieldDto oldBoiler = new TechParamsBoilerChangeFieldDto();
        BeanUtil.copyProperties(boiler, oldBoiler);
        return oldBoiler;
    }

    BaseTechParamsFieldDto buildTechParamInfo(EquipRegisterChangeDataDto equipRegisterChangeDataDto, String record) {
        return getBaseTechParamsFieldDto(record, equipRegisterChangeDataDto.getEquList());
    }

    BaseTechParamsFieldDto buildTechParamInfo(IdxBizJgRegisterInfo registerInfo, String record) {
        return getBaseTechParamsFieldDto(record, registerInfo.getEquList());
    }

    private BaseTechParamsFieldDto getBaseTechParamsFieldDto(String record, String equList) {
        EquipmentClassifityEnum equipmentClassifityEnum = EquipmentClassifityEnum.getOne(equList);
        switch (Objects.requireNonNull(equipmentClassifityEnum)) {
            case GL:
                // 锅炉
                IdxBizJgTechParamsBoiler boiler = iIdxBizJgTechParamsBoilerService.getOneData(record);
                // 技术参数对象转换为全部技术参数 ，其他无用字段去掉
                return BeanUtil.copyProperties(boiler, TechParamsBoilerChangeFieldDto.class);
            case YLRQ:
                // 压力容器
                IdxBizJgTechParamsVessel techParamsVessel = iIdxBizJgTechParamsVesselService.getOneData(record);
                // 技术参数对象转换为全部技术参数 ，其他无用字段去掉
                return BeanUtil.copyProperties(techParamsVessel, TechParamsVesselChangeFieldDto.class);
            case DT:
                // 电梯
                IdxBizJgTechParamsElevator techParamsElevator = iIdxBizJgTechParamsElevatorService.getOneData(record);
                // 技术参数对象转换为全部技术参数 ，其他无用字段去掉
                return BeanUtil.copyProperties(techParamsElevator, TechParamsElevatorChangeFieldDto.class);
            case QZJX:
                // 起重机械
                IdxBizJgTechParamsLifting techParamsLifting = iIdxBizJgTechParamsLiftingService.getOneData(record);
                // 技术参数对象转换为全部技术参数 ，其他无用字段去掉
                return BeanUtil.copyProperties(techParamsLifting, TechParamsLiftingChangeFieldDto.class);
            case CC:
                // 场（厂）内专用机动车辆
                IdxBizJgTechParamsVehicle techParamsVehicle = iIdxBizJgTechParamsVehicleService.getOneData(record);
                // 技术参数对象转换为全部技术参数 ，其他无用字段去掉
                return BeanUtil.copyProperties(techParamsVehicle, TechParamsVehicleChangeFieldDto.class);
            case YLSS:
                // 大型游乐设施
                IdxBizJgTechParamsRides techParamsRides = iIdxBizJgTechParamsRidesService.getOneData(record);
                // 技术参数对象转换为全部技术参数 ，其他无用字段去掉
                return BeanUtil.copyProperties(techParamsRides, TechParamsRidesChangeFieldDto.class);
            case YLGD:
                // 压力管道
                IdxBizJgTechParamsPipeline techParamsPipeline = iIdxBizJgTechParamsPipelineService.getOneData(record);
                // 技术参数对象转换为全部技术参数 ，其他无用字段去掉
                return BeanUtil.copyProperties(techParamsPipeline, TechParamsPipelineChangeFieldDto.class);
            case KYSD:
                // 客运索道
                IdxBizJgTechParamsRopeway techParamsRopeway = iIdxBizJgTechParamsRopewayService.getOneData(record);
                // 技术参数对象转换为全部技术参数 ，其他无用字段去掉
                return BeanUtil.copyProperties(techParamsRopeway, TechParamsRopewayChangeFieldDto.class);
            default:
                break;
        }
        return null;
    }


    void updateTechParamInfo(String equListCode, String record, Map<String, Object> changeData, List<FieldChangeMeta> allChange) {
        EquipmentClassifityEnum equipmentClassifityEnum = EquipmentClassifityEnum.getOne(equListCode);
        switch (Objects.requireNonNull(equipmentClassifityEnum)) {
            case GL:
                // 锅炉
                TechParamsBoilerChangeFieldDto newBoiler = getTechParamsBoilerChangeField(changeData);
                TechParamsBoilerChangeFieldDto oldBoiler = getTechParamsBoilerChangeField(record);
                // 字段行转列
                List<FieldChangeMeta> boilerChangeDataNew = convertBeanField2Column2(newBoiler, record);
                List<FieldChangeMeta> boilerChangeDataOld = convertBeanField2Column2(oldBoiler, record);
                // 比对
                List<FieldChangeMeta> boilerChangeFields = mergeChangeFields(boilerChangeDataNew, boilerChangeDataOld);
                // 业务处理
                equipChangeDataUpdateServiceImpl.updateTechParamByRecord(this.buildTableName(TechParamsBoilerChangeFieldDto.class), record, boilerChangeFields);
                // 日志数据记录
                allChange.addAll(boilerChangeDataNew);
                break;
            case YLRQ:
                // 压力容器
                TechParamsVesselChangeFieldDto newVessel = new TechParamsVesselChangeFieldDto();
                BeanUtil.copyProperties(JSON.parse(JSONObject.toJSONString(changeData)), newVessel, true);
                IdxBizJgTechParamsVessel techParamsVessel = iIdxBizJgTechParamsVesselService.getOneData(record);
                TechParamsVesselChangeFieldDto oldVessel = BeanUtil.copyProperties(techParamsVessel, TechParamsVesselChangeFieldDto.class);
                // 字段行转列
                List<FieldChangeMeta> newVesselChangeData = convertBeanField2Column2(newVessel, record);
                List<FieldChangeMeta> oldVesselChangeData = convertBeanField2Column2(oldVessel, record);
                // 比对
                List<FieldChangeMeta> vesselChangeFields = mergeChangeFields(newVesselChangeData, oldVesselChangeData);
                // 业务处理
                equipChangeDataUpdateServiceImpl.updateTechParamByRecord(this.buildTableName(TechParamsVesselChangeFieldDto.class), record, vesselChangeFields);
                // 日志数据记录
                allChange.addAll(vesselChangeFields);
                break;
            case DT:
                // 电梯
                TechParamsElevatorChangeFieldDto newElevator = new TechParamsElevatorChangeFieldDto();
                BeanUtil.copyProperties(JSON.parse(JSONObject.toJSONString(changeData)), newElevator, true);

                IdxBizJgTechParamsElevator techParamsElevator = iIdxBizJgTechParamsElevatorService.getOneData(record);
                TechParamsElevatorChangeFieldDto oldElevator = BeanUtil.copyProperties(techParamsElevator, TechParamsElevatorChangeFieldDto.class);
                // 字段行转列
                List<FieldChangeMeta> newElevatorChangeData = convertBeanField2Column2(newElevator, record);
                List<FieldChangeMeta> oldElevatorChangeData = convertBeanField2Column2(oldElevator, record);
                // 比对
                List<FieldChangeMeta> elevatorChangeFields = mergeChangeFields(newElevatorChangeData, oldElevatorChangeData);
                // 业务处理
                equipChangeDataUpdateServiceImpl.updateTechParamByRecord(this.buildTableName(TechParamsElevatorChangeFieldDto.class), record, elevatorChangeFields);
                // 日志数据记录
                allChange.addAll(elevatorChangeFields);
                break;
            case QZJX:
                // 起重机械
                TechParamsLiftingChangeFieldDto newLifting = new TechParamsLiftingChangeFieldDto();
                BeanUtil.copyProperties(JSON.parse(JSONObject.toJSONString(changeData)), newLifting, true);

                IdxBizJgTechParamsLifting techParamsLifting = iIdxBizJgTechParamsLiftingService.getOneData(record);
                // 技术参数对象转换为全部技术参数 ，其他无用字段去掉
                TechParamsLiftingChangeFieldDto oldLifting = BeanUtil.copyProperties(techParamsLifting, TechParamsLiftingChangeFieldDto.class);
                // 字段行转列
                List<FieldChangeMeta> newLiftingChangeData = convertBeanField2Column2(newLifting, record);
                List<FieldChangeMeta> oldLiftingChangeData = convertBeanField2Column2(oldLifting, record);
                // 比对
                List<FieldChangeMeta> liftingChangeFields = mergeChangeFields(newLiftingChangeData, oldLiftingChangeData);
                // 业务处理
                equipChangeDataUpdateServiceImpl.updateTechParamByRecord(this.buildTableName(TechParamsLiftingChangeFieldDto.class), record, liftingChangeFields);
                // 日志数据记录
                allChange.addAll(liftingChangeFields);
                break;
            case CC:
                // 场（厂）内专用机动车辆
                TechParamsVehicleChangeFieldDto newVehicle = new TechParamsVehicleChangeFieldDto();
                BeanUtil.copyProperties(JSON.parse(JSONObject.toJSONString(changeData)), newVehicle, true);

                IdxBizJgTechParamsVehicle techParamsVehicle = iIdxBizJgTechParamsVehicleService.getOneData(record);
                TechParamsVehicleChangeFieldDto oldVehicle = BeanUtil.copyProperties(techParamsVehicle, TechParamsVehicleChangeFieldDto.class);
                // 字段行转列
                List<FieldChangeMeta> newVehicleChangeData = convertBeanField2Column2(newVehicle, record);
                List<FieldChangeMeta> oldVehicleChangeData = convertBeanField2Column2(oldVehicle, record);
                // 比对
                List<FieldChangeMeta> vehicleChangeFields = mergeChangeFields(newVehicleChangeData, oldVehicleChangeData);
                // 业务处理
                equipChangeDataUpdateServiceImpl.updateTechParamByRecord(this.buildTableName(TechParamsVehicleChangeFieldDto.class), record, vehicleChangeFields);
                // 日志数据记录
                allChange.addAll(vehicleChangeFields);
                break;
            case YLSS:
                // 大型游乐设施
                TechParamsRidesChangeFieldDto newRides = new TechParamsRidesChangeFieldDto();
                BeanUtil.copyProperties(JSON.parse(JSONObject.toJSONString(changeData)), newRides, true);

                IdxBizJgTechParamsRides techParamsRides = iIdxBizJgTechParamsRidesService.getOneData(record);
                // 技术参数对象转换为全部技术参数 ，其他无用字段去掉
                TechParamsRidesChangeFieldDto oldRides = BeanUtil.copyProperties(techParamsRides, TechParamsRidesChangeFieldDto.class);
                // 字段行转列
                List<FieldChangeMeta> newRidesChangeData = convertBeanField2Column2(newRides, record);
                List<FieldChangeMeta> oldRidesChangeData = convertBeanField2Column2(oldRides, record);
                // 比对
                List<FieldChangeMeta> ridesChangeFields = mergeChangeFields(newRidesChangeData, oldRidesChangeData);
                // 业务处理
                equipChangeDataUpdateServiceImpl.updateTechParamByRecord(this.buildTableName(TechParamsRidesChangeFieldDto.class), record, ridesChangeFields);
                // 日志数据记录
                allChange.addAll(ridesChangeFields);
                break;
            case YLGD:
                // 压力管道
                TechParamsPipelineChangeFieldDto newPipeline = new TechParamsPipelineChangeFieldDto();
                BeanUtil.copyProperties(JSON.parse(JSONObject.toJSONString(changeData)), newPipeline, true);
                savePieLineTechParam(record, allChange, newPipeline);
                break;
            case KYSD:
                // 客运索道
                TechParamsRopewayChangeFieldDto newRopeway = new TechParamsRopewayChangeFieldDto();
                BeanUtil.copyProperties(JSON.parse(JSONObject.toJSONString(changeData)), newRopeway, true);

                IdxBizJgTechParamsRopeway techParamsRopeway = iIdxBizJgTechParamsRopewayService.getOneData(record);
                // 技术参数对象转换为全部技术参数 ，其他无用字段去掉
                TechParamsRopewayChangeFieldDto oldRopeway = BeanUtil.copyProperties(techParamsRopeway, TechParamsRopewayChangeFieldDto.class);
                // 字段行转列
                List<FieldChangeMeta> newRopewayChangeData = convertBeanField2Column2(newRopeway, record);
                List<FieldChangeMeta> oldRopewayChangeData = convertBeanField2Column2(oldRopeway, record);
                // 比对
                List<FieldChangeMeta> ropewayChangeFields = mergeChangeFields(newRopewayChangeData, oldRopewayChangeData);
                // 业务处理
                equipChangeDataUpdateServiceImpl.updateTechParamByRecord(this.buildTableName(TechParamsRopewayChangeFieldDto.class), record, ropewayChangeFields);
                // 日志数据记录
                allChange.addAll(ropewayChangeFields);
                break;
            default:
                break;
        }
    }

    public void savePieLineTechParam(String record, List<FieldChangeMeta> allChange, TechParamsPipelineChangeFieldDto newPipeline) {
        IdxBizJgTechParamsPipeline techParamsPipeline = iIdxBizJgTechParamsPipelineService.getOneData(record);
        // 技术参数对象转换为全部技术参数 ，其他无用字段去掉
        TechParamsPipelineChangeFieldDto oldPipeline = BeanUtil.copyProperties(techParamsPipeline, TechParamsPipelineChangeFieldDto.class);
        // 字段行转列
        List<FieldChangeMeta> newPipelineChangeData = convertBeanField2Column2(newPipeline, record);
        List<FieldChangeMeta> oldPipelineChangeData = convertBeanField2Column2(oldPipeline, record);
        // 比对
        List<FieldChangeMeta> pipelineChangeFields = mergeChangeFields(newPipelineChangeData, oldPipelineChangeData);
        // 业务处理
        equipChangeDataUpdateServiceImpl.updateTechParamByRecord(this.buildTableName(TechParamsPipelineChangeFieldDto.class), record, pipelineChangeFields);
        // 日志数据记录
        allChange.addAll(pipelineChangeFields);
    }

    public static List<FieldChangeMeta> convertBeanField2Column2(Object beanData, String changeId) {
        List<FieldChangeMeta> changeData = new ArrayList<>();
        Group group = beanData.getClass().getAnnotation(Group.class);
        Field[] fields = beanData.getClass().getDeclaredFields();
        for (Field field : fields) {
            field.setAccessible(true);
            FieldDisplayDefine displayDefine = field.getAnnotation(FieldDisplayDefine.class);
            try {
                if (displayDefine != null && displayDefine.isExist()) {
                    String fieldName = displayDefine.value();
                    FieldChangeMeta fieldChangeMeta = new FieldChangeMeta();
                    fieldChangeMeta.setColumnKey(field.getName());
                    fieldChangeMeta.setColumnFamily(group.value());
                    fieldChangeMeta.setColumnLabel(fieldName);
                    fieldChangeMeta.setChangeId(changeId);
                    Object oV = field.get(beanData);
                    if (oV instanceof String) {
                        String value = (String) field.get(beanData);
                        fieldChangeMeta.setColumnNewValue(value);
                        fieldChangeMeta.setColumnOldValue(value);
                    } else if (oV instanceof Number) {
                        String value = String.valueOf(field.get(beanData));
                        fieldChangeMeta.setColumnNewValue(value);
                        fieldChangeMeta.setColumnOldValue(value);
                    } else if (oV instanceof Date) {
                        String value = DateUtil.format((Date) oV, displayDefine.format());
                        fieldChangeMeta.setColumnNewValue(value);
                        fieldChangeMeta.setColumnOldValue(value);
                    }
                    changeData.add(fieldChangeMeta);
                }
            } catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        return changeData;
    }

    public List<FieldChangeMeta> buildDesignInfoNew(Object changeDataDto, String record) {
        return convertBeanField2Column2(changeDataDto, record);
    }

    private List<FieldChangeMeta> buildFactoryInfoNew(EquipFactoryChangeDataDto changeDataDto, String record) {
        return convertBeanField2Column2(changeDataDto, record);
    }

    private List<FieldChangeMeta> buildRegisterInfoNew(EquipRegisterChangeDataDto changeDataDto, String record) {
        return convertBeanField2Column2(changeDataDto, record);
    }

    public List<FieldChangeMeta> buildDesignInfoOld(String record) {
        EquipDesignChangeDataDto changeDataDto = new EquipDesignChangeDataDto();
        IdxBizJgDesignInfo designInfo = idxBizJgDesignInfoMapper.selectOne(new LambdaQueryWrapper<IdxBizJgDesignInfo>().eq(IdxBizJgDesignInfo::getRecord, record));
        BeanUtil.copyProperties(designInfo, changeDataDto);
        changeDataDto.setDesignDate(designInfo.getDesignDate());
        return convertBeanField2Column2(changeDataDto, record);
    }

    private List<FieldChangeMeta> buildFactoryInfoOld(String record) {
        EquipFactoryChangeDataDto changeDataDto = new EquipFactoryChangeDataDto();
        IdxBizJgFactoryInfo factoryInfo = jgFactoryInfoMapper.selectOne(new LambdaQueryWrapper<IdxBizJgFactoryInfo>().eq(IdxBizJgFactoryInfo::getRecord, record));
        BeanUtil.copyProperties(factoryInfo, changeDataDto);
        changeDataDto.setProduceDate(DateUtil.formatDate(factoryInfo.getProduceDate()));
        return convertBeanField2Column2(changeDataDto, record);
    }

    private List<FieldChangeMeta> buildRegisterInfoOld(String record) {
        EquipRegisterChangeDataDto changeDataDto = new EquipRegisterChangeDataDto();
        IdxBizJgRegisterInfo registerInfo = idxBizJgRegisterInfoMapper.selectOne(new LambdaQueryWrapper<IdxBizJgRegisterInfo>().eq(IdxBizJgRegisterInfo::getRecord, record));
        BeanUtil.copyProperties(registerInfo, changeDataDto);
        return convertBeanField2Column2(changeDataDto, record);
    }

    private List<FieldChangeMeta> buildUseInfoOld(String record) {
        EquipUseInfoChangeDataDto changeDataDto = new EquipUseInfoChangeDataDto();
        IdxBizJgUseInfo useInfo = idxBizJgUseInfoService.getOneData(record);
        BeanUtil.copyProperties(useInfo, changeDataDto);
        return convertBeanField2Column2(changeDataDto, record);
    }


    public Map<String, Object> cast2UnderCase(Map<String, Object> re) {
        // 由于历史遗留问题，和前端保存统一，要转成大写下滑线驼峰
        Map<String, Object> result = new HashMap<>();
        re.forEach((k, v) -> {
            result.put(CharSequenceUtil.toUnderlineCase(k).toUpperCase(), v);
        });
        return result;
    }

    public void castJsonFields(Map<String, Object> re) {
        jsonFields.forEach(field -> {
            if (re.containsKey(field) && re.get(field) instanceof String) {
                re.put(field, JSON.parse((String) re.get(field)));
            }
        });
    }

    public EquipDesignChangeDataDto buildDesignInfo(String record) {
        EquipDesignChangeDataDto changeDataDto = new EquipDesignChangeDataDto();
        IdxBizJgDesignInfo designInfo = idxBizJgDesignInfoMapper.selectOne(new LambdaQueryWrapper<IdxBizJgDesignInfo>().eq(IdxBizJgDesignInfo::getRecord, record));
        BeanUtil.copyProperties(designInfo, changeDataDto);
        changeDataDto.setDesignDate(designInfo.getDesignDate());
        return changeDataDto;
    }

    public EquipFactoryChangeDataDto buildFactoryInfo(String record) {
        EquipFactoryChangeDataDto changeDataDto = new EquipFactoryChangeDataDto();
        IdxBizJgFactoryInfo factoryInfo = jgFactoryInfoMapper.selectOne(new LambdaQueryWrapper<IdxBizJgFactoryInfo>().eq(IdxBizJgFactoryInfo::getRecord, record));
        BeanUtil.copyProperties(factoryInfo, changeDataDto);
        changeDataDto.setProduceDate(DateUtil.formatDate(factoryInfo.getProduceDate()));
        return changeDataDto;
    }

    public EquipRegisterChangeDataDto buildRegisterInfo(String record) {
        EquipRegisterChangeDataDto changeDataDto = new EquipRegisterChangeDataDto();
        IdxBizJgRegisterInfo registerInfo = idxBizJgRegisterInfoMapper.selectOne(new LambdaQueryWrapper<IdxBizJgRegisterInfo>().eq(IdxBizJgRegisterInfo::getRecord, record));
        BeanUtil.copyProperties(registerInfo, changeDataDto);
        return changeDataDto;
    }

    public EquipUseInfoChangeDataDto buildUseInfo(String record) {
        EquipUseInfoChangeDataDto changeDataDto = new EquipUseInfoChangeDataDto();
        IdxBizJgUseInfo useInfo = idxBizJgUseInfoService.getOneData(record);
        BeanUtil.copyProperties(useInfo, changeDataDto);
        return changeDataDto;
    }


    private List<FieldChangeMeta> buildOtherInfoOld(String record) {
        EquipOtherInfoChangeDataDto changeDataDto = new EquipOtherInfoChangeDataDto();
        IdxBizJgOtherInfo otherInfo = idxBizJgOtherInfoMapper.selectOne(new LambdaQueryWrapper<IdxBizJgOtherInfo>().eq(IdxBizJgOtherInfo::getRecord, record));
        BeanUtil.copyProperties(otherInfo, changeDataDto);
        return convertBeanField2Column2(changeDataDto, record);
    }

    /**
     * 简化版字段对比更新工具
     * 要求：对象字段名与数据库列名一致（驼峰转下划线自动处理）
     *
     * @param mapper MyBatis-Plus 的 Mapper 实例（直接传入）
     * @param oldObj 旧对象（必须有id字段）
     * @param newObj 新对象（必须与旧对象同一类型）
     */
    public <T> List<FieldChangeMeta> simpleTrackAndUpdate(BaseMapper<T> mapper, T oldObj, T newObj, String changeId, String whereKey, String whereValue) {
        List<FieldChangeMeta> changeData = new ArrayList<>();
        // 基础校验
        if (oldObj == null || newObj == null) {
            throw new IllegalArgumentException("新旧对象不能为空");
        }
        if (!oldObj.getClass().equals(newObj.getClass())) {
            throw new IllegalArgumentException("对象类型不一致");
        }
        Group group = newObj.getClass().getAnnotation(Group.class);
        Class<?> clazz = oldObj.getClass();
        UpdateWrapper<T> wrapper = new UpdateWrapper<>();
        // 遍历所有字段（包含父类）
        for (Field field : getAllFields(clazz)) {
            try {
                field.setAccessible(true);
                Object oldVal = field.get(oldObj);
                Object newVal = field.get(newObj);
                FieldDisplayDefine displayDefine = field.getAnnotation(FieldDisplayDefine.class);
                TableField tableField = field.getAnnotation(TableField.class);
                // 业务字段对比处理逻辑
                if (!Objects.equals(oldVal, newVal)) {
                    if (displayDefine != null && displayDefine.isExist()) {
                        String columnName = tableField.value();
                        wrapper.set(columnName, newVal);
                        String fieldName = displayDefine.value();
                        FieldChangeMeta fieldChangeMeta = new FieldChangeMeta();
                        fieldChangeMeta.setColumnKey(field.getName());
                        fieldChangeMeta.setColumnFamily(group.value());
                        fieldChangeMeta.setColumnLabel(fieldName);
                        fieldChangeMeta.setChangeId(changeId);
                        // 字段类型前端渲染时使用
                        fieldChangeMeta.setColumnType(displayDefine.type().getSimpleName());
                        if (newVal instanceof String) {
                            fieldChangeMeta.setColumnOldValue((String) oldVal);
                            fieldChangeMeta.setColumnNewValue((String) newVal);
                        } else if (newVal instanceof Number) {
                            fieldChangeMeta.setColumnOldValue(String.valueOf(oldVal));
                            fieldChangeMeta.setColumnNewValue(String.valueOf(newVal));
                        } else if (newVal instanceof Date) {
                            fieldChangeMeta.setColumnOldValue(DateUtil.formatDate((Date) oldVal));
                            fieldChangeMeta.setColumnNewValue(DateUtil.formatDate((Date) newVal));
                        } else if (newVal instanceof Boolean) {
                            fieldChangeMeta.setColumnOldValue(Boolean.toString((Boolean) oldVal));
                            fieldChangeMeta.setColumnNewValue(Boolean.toString((Boolean) newVal));
                        }
                        changeData.add(fieldChangeMeta);
                    }
                }

            } catch (IllegalAccessException e) {
                System.err.println("字段访问失败: " + field.getName());
            }
        }
        // 执行更新
        if (!changeData.isEmpty()) {
            // 公共字段处理
            wrapper.set(BASE_COLUMN_REC_DATE, new Date());
            wrapper.set(BASE_COLUMN_REC_USERID, RequestContext.getExeUserId());
            // 查询where
            wrapper.eq(whereKey, whereValue);
            // 更新
            mapper.update(null, wrapper);
        }
        return changeData;
    }


    public Map<String, ?> getEquipDetailByRecord(String record) {
        Map<String, Object> re = new HashMap<>();
        IdxBizJgRegisterInfo registerInfo = jgUseRegistrationService.getIdxBizJgRegisterInfoService().getOne(new LambdaQueryWrapper<IdxBizJgRegisterInfo>().eq(IdxBizJgRegisterInfo::getRecord, record));
        IdxBizJgFactoryInfo factoryInfo = jgFactoryInfoMapper.selectOne(new LambdaQueryWrapper<IdxBizJgFactoryInfo>().eq(IdxBizJgFactoryInfo::getRecord, record));
        IdxBizJgUseInfo useInfo = jgUseRegistrationService.getUseInfoMapper().selectOne(new LambdaQueryWrapper<IdxBizJgUseInfo>().eq(IdxBizJgUseInfo::getRecord, record));
        IdxBizJgDesignInfo designInfo = idxBizJgDesignInfoMapper.selectOne(new LambdaQueryWrapper<IdxBizJgDesignInfo>().eq(IdxBizJgDesignInfo::getRecord, record));
        IdxBizJgOtherInfo otherInfo = idxBizJgOtherInfoMapper.selectOne(new LambdaQueryWrapper<IdxBizJgOtherInfo>().eq(IdxBizJgOtherInfo::getRecord, record));
        IdxBizJgSupervisionInfo idxBizJgSupervisionInfo = jgUseRegistrationService.getIdxBizJgSupervisionInfoMapper().selectOne(new LambdaQueryWrapper<IdxBizJgSupervisionInfo>().eq(IdxBizJgSupervisionInfo::getRecord, record));
        IdxBizJgInspectionDetectionInfo inspectionDetectionInfo = jgUseRegistrationService.getInspectionDetectionInfoService().queryNewestDetailByRecord(record);
        IdxBizJgMaintenanceRecordInfo idxBizJgMaintenanceRecordInfo = jgUseRegistrationService.getIdxBizJgMaintenanceRecordInfoService().queryNewestDetailByRecord(record);
        IdxBizJgConstructionInfo constructionInfo = jgUseRegistrationService.getIdxBizJgConstructionInfoService().queryNewestDetailByRecord(record);
        BaseTechParamsFieldDto techParamsFieldDto = this.buildTechParamInfo(registerInfo, record);
        re.putAll(BeanUtil.beanToMap(useInfo));
        re.putAll(BeanUtil.beanToMap(registerInfo));
        re.putAll(BeanUtil.beanToMap(factoryInfo));
        re.putAll(BeanUtil.beanToMap(otherInfo));
        re.putAll(BeanUtil.beanToMap(designInfo));
        re.putAll(BeanUtil.beanToMap(idxBizJgSupervisionInfo));
        re.putAll(BeanUtil.beanToMap(inspectionDetectionInfo));
        re.putAll(BeanUtil.beanToMap(idxBizJgMaintenanceRecordInfo));
        re.putAll(BeanUtil.beanToMap(constructionInfo));
        re.putAll(BeanUtil.beanToMap(techParamsFieldDto));
        // 转json
        this.castJsonFields(re);
        // 转下滑线大写下划线
        Map<String, Object> result = this.cast2UnderCase(re);
        // 流水主键赋值 用于后续的更新
        result.put("jySeq", inspectionDetectionInfo != null ? inspectionDetectionInfo.getSequenceNbr() : null);
        result.put("maintenanceSeq", idxBizJgMaintenanceRecordInfo != null ? idxBizJgMaintenanceRecordInfo.getSequenceNbr() : null);
        result.put("constructionInfoSeq", constructionInfo != null ? constructionInfo.getSequenceNbr() : null);
        result.put("record", useInfo.getRecord());
        return result;
    }

    public IPage<?> getEquListByRecords(Set<String> eqs, JSONObject map) {
        if (map.containsKey("flag") && !map.containsKey("USE_UNIT_CREDIT_CODE")) {
            return new Page<>();
        }
        int pageNumber = ObjectUtils.isEmpty(map.getInteger("current")) ? 1 : map.getInteger("current");
        int size = ObjectUtils.isEmpty(map.getInteger("size")) ? 20 : map.getInteger("size");
        Page<JSONObject> result = new Page<>(pageNumber, size);
        SearchRequest request = new SearchRequest();
        request.indices("idx_biz_view_jg_all");
        SearchSourceBuilder builder = new SearchSourceBuilder();
        builder.trackTotalHits(true);
        BoolQueryBuilder boolMust = QueryBuilders.boolQuery();
        BoolQueryBuilder seqBuilder = QueryBuilders.boolQuery();
        seqBuilder.must(QueryBuilders.termsQuery("SEQUENCE_NBR.keyword", eqs));
        boolMust.must(seqBuilder);
        // 设备代码模糊查询
        if (!ObjectUtils.isEmpty(map.getString(EQU_CODE))) {
            BoolQueryBuilder pBuilder = QueryBuilders.boolQuery();
            String test = QueryParser.escape(map.getString(EQU_CODE));
            pBuilder.must(QueryBuilders.wildcardQuery(EQU_CODE, "*" + QueryParser.escape(test.toLowerCase()) + "*"));
            boolMust.must(pBuilder);
        }
        // 单位内部编号模糊查询
        if (!ObjectUtils.isEmpty(map.getString("USE_INNER_CODE"))) {
            BoolQueryBuilder pBuilder = QueryBuilders.boolQuery();
            String test = QueryParser.escape(map.getString("USE_INNER_CODE"));
            pBuilder.must(QueryBuilders.wildcardQuery("USE_INNER_CODE", "*" + QueryParser.escape(test.toLowerCase()) + "*"));
            boolMust.must(pBuilder);
        }
        // 出厂编号/产品编码模糊查询
        if (!ObjectUtils.isEmpty(map.getString(FACTORY_NUM))) {
            BoolQueryBuilder pBuilder = QueryBuilders.boolQuery();
            String test = QueryParser.escape(map.getString(FACTORY_NUM));
            pBuilder.must(QueryBuilders.wildcardQuery(FACTORY_NUM, "*" + QueryParser.escape(test.toLowerCase()) + "*"));
            boolMust.must(pBuilder);
        }
        builder.query(boolMust);
        builder.sort("REC_DATE", SortOrder.DESC);
        builder.from((pageNumber - 1) * size);
        builder.size(size);
        request.source(builder);
        List<JSONObject> list = new LinkedList<>();
        long totle = 0;
        if (log.isDebugEnabled()) {
            log.debug("查询es 的查询条件: {}", request);
        }
        try {
            SearchResponse response = restHighLevelClient.search(request, RequestOptions.DEFAULT);
            for (SearchHit hit : response.getHits().getHits()) {
                System.out.println(hit);
                JSONObject jsonObject = (JSONObject) JSONObject.toJSON(hit);
                JSONObject dto2 = jsonObject.getJSONObject("sourceAsMap");
                if (!ValidationUtil.isEmpty(dto2.get(EQUSTATE))) {
                    Integer integer = Integer.valueOf(dto2.get(EQUSTATE).toString());
                    String status = EquimentEnum.getName.get(integer);
                    dto2.put(EQUSTATE, status);
                }
                if (!ValidationUtil.isEmpty(dto2.get(DATA_SOURCE))) {
                    String s = dto2.get(DATA_SOURCE).toString();
                    dto2.put(DATA_SOURCE, s);
                    dto2.put(DATA_SOURCE_NAME, EquipSourceEnum.getDataSourceName(s));
                }
                dto2.put("record", dto2.get(SEQUENCE_NBR));
                list.add(dto2);
            }
            // 获取所有设备的Id
            List<String> equIds = null;
            if (!ValidationUtil.isEmpty(list)) {
                equIds = list.stream().map(item -> item.get(SEQUENCE_NBR).toString()).collect(Collectors.toList());
            }
            if (!ValidationUtil.isEmpty(equIds)) {
                // 查询设备地址
                List<IdxBizJgUseInfo> useInfoListByEquIds = idxBizJgUseInfoService.getUseInfoListByEquIds(equIds);
                Map<String, String> equAddressMap = new HashMap<>();
                if (!ValidationUtil.isEmpty(useInfoListByEquIds)) {
                    equAddressMap = useInfoListByEquIds.stream().collect(Collectors.toMap(IdxBizJgUseInfo::getRecord,
                                    useInfo -> {
                                        String fulladdress = "";
                                        if (!ValidationUtil.isEmpty(useInfo.getProvinceName())) {
                                            fulladdress += useInfo.getProvinceName();
                                        }
                                        if (!ValidationUtil.isEmpty(useInfo.getCityName())) {
                                            fulladdress += useInfo.getCityName();
                                        }
                                        if (!ValidationUtil.isEmpty(useInfo.getCountyName())) {
                                            fulladdress += useInfo.getCountyName();
                                        }
                                        if (!ValidationUtil.isEmpty(useInfo.getStreetName())) {
                                            fulladdress += useInfo.getStreetName();
                                        }
                                        if (!ValidationUtil.isEmpty(useInfo.getAddress())) {
                                            fulladdress += useInfo.getAddress();
                                        }
                                        return fulladdress;
                                    }
                            )
                    );
                }
                // 更新设备使用情况和设备地址
                for (JSONObject item : list) {
                    String fullAddress = equAddressMap.get(item.getString(SEQUENCE_NBR));
                    item.put("ADDRESS", !ValidationUtil.isEmpty(fullAddress) ? fullAddress : "");
                }
            }
            totle = Objects.requireNonNull(response.getInternalResponse().hits().getTotalHits()).value;
            result.setRecords(list);
            result.setTotal(totle);
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public Map<String, ?> getProjectContraptionBySeq(String projectContraptionId, Set<String> records) {
        IdxBizJgProjectContraption projectContraption = idxBizJgProjectContraptionServiceImpl.getById(projectContraptionId);
        Map<String, Object> re = BeanUtil.beanToMap(projectContraption);
        this.convertStringToJsonObject(re, IdxBizJgProjectContraptionServiceImpl.getJsonFieldsCamel());
        List<Map<String, Object>> equList = jgUseRegistrationService.getBaseMapper().queryForUnitPipelineEquipmentForEdit(new ArrayList<>(records));
        // 检验报告数据格式化 转json
        equList.stream().filter(e -> e.get("inspectReport") != null).forEach(item -> item.put("inspectReport", JSON.parse(item.get("inspectReport").toString())));
        re.put("projectContraptionId", projectContraption.getSequenceNbr());
        re.put("tableData", equList);
        return re;
    }

    public void convertStringToJsonObject(Object obj, String[] jsonFields) {
        if (obj instanceof JSONObject) {
            JSONObject jsonObject = (JSONObject) obj;
            for (String field : jsonFields) {
                if (jsonObject.get(field) != null && jsonObject.get(field) instanceof String) {
                    jsonObject.put(field, JSON.parse(jsonObject.get(field).toString()));
                }
            }
        } else if (obj instanceof Map) {
            Map<String, Object> map = (Map<String, Object>) obj;
            for (String field : jsonFields) {
                if (map.containsKey(field) && map.get(field) instanceof String) {
                    map.put(field, JSON.parse(map.get(field).toString()));
                }
            }
        } else {
            // 处理其他类型
            System.out.println("Unsupported Object Type");
        }
    }

    public IPage<?> getProjectContraptionsBySeqs(Set<String> projectContraptionIds, JSONObject params) {
        Page<IdxBizJgProjectContraption> page = new Page<>();
        page.setCurrent(params.getLong("current"));
        page.setSize(params.getLong("size"));
        // 工程装置名称
        String projectContraption = params.getString(PROJECT_CONTRAPTION);
        // 工程装置编号
        String projectContraptionNo = params.getString(PROJECT_CONTRAPTION_NO);
        IPage<IdxBizJgProjectContraption> pageList = idxBizJgProjectContraptionServiceImpl.lambdaQuery()
                .like(!ValidationUtil.isEmpty(projectContraption), IdxBizJgProjectContraption::getProjectContraption, projectContraption)
                .like(!ValidationUtil.isEmpty(projectContraptionNo), IdxBizJgProjectContraption::getProjectContraptionNo, projectContraptionNo)
                .isNull(IdxBizJgProjectContraption::getProjectContraptionParentId)
                .in(BaseEntity::getSequenceNbr, projectContraptionIds)
                .orderByDesc(IdxBizJgProjectContraption::getRecDate)
                .page(page);
        List<Map<String, Object>> records = new ArrayList<>();
        if (!ValidationUtil.isEmpty(pageList.getRecords())) {
            pageList.getRecords().forEach(record -> {
                Map<String, Object> item = new HashMap<>();
                record.setDataSourceName(EquipSourceEnum.getDataSourceName(record.getDataSource()));
                record.setFullAddress(
                        Stream.of(record.getProvinceName(), record.getCityName(), record.getCountyName(), record.getStreetName(), record.getAddress())
                                .map(value -> value == null ? "" : value)
                                .collect(Collectors.joining())
                );
                BeanUtil.copyProperties(record, item);
                BigDecimal pipelineLength = BigDecimal.valueOf(record.getPipelineLength());
                BigDecimal roundedValue = pipelineLength.setScale(2, RoundingMode.HALF_UP);
                item.put("pipelineLength", roundedValue.toPlainString());
                records.add(item);
            });
        }
        Page<Map<String, Object>> page1 = new Page<>();
        BeanUtil.copyProperties(pageList, page1);
        page1.setRecords(records);
        return page1;
    }

    public void updateEsDataOfEquip(String record, IBaseChangeData changeDataDto) {

        // 注册信息
        if (changeDataDto instanceof IdxBizJgRegisterInfo) {
            IdxBizJgRegisterInfo registerChangeDataDto = (IdxBizJgRegisterInfo) changeDataDto;
            equipChangeDataUpdateServiceImpl.updateRegisterEsData(record, registerChangeDataDto);
        }
        // 制造信息
        if (changeDataDto instanceof IdxBizJgFactoryInfo) {
            IdxBizJgFactoryInfo equipFactoryChangeDataDto = (IdxBizJgFactoryInfo) changeDataDto;
            equipChangeDataUpdateServiceImpl.updateFactoryEsData(record, equipFactoryChangeDataDto);
        }
        // 设计信息
        if (changeDataDto instanceof IdxBizJgDesignInfo) {
            IdxBizJgDesignInfo equipDesignChangeDataDto = (IdxBizJgDesignInfo) changeDataDto;
            equipChangeDataUpdateServiceImpl.checkDesignChangeData(record, equipDesignChangeDataDto);
        }
        // 使用信息
        if (changeDataDto instanceof IdxBizJgUseInfo) {
            IdxBizJgUseInfo equipUseInfoChangeDataDto = (IdxBizJgUseInfo) changeDataDto;
            equipChangeDataUpdateServiceImpl.updateUseInfoEsData(record, equipUseInfoChangeDataDto);
        }
        // 检验信息
        if (changeDataDto instanceof IdxBizJgInspectionDetectionInfo) {
            IdxBizJgInspectionDetectionInfo equipUseInfoChangeDataDto = (IdxBizJgInspectionDetectionInfo) changeDataDto;
            equipChangeDataUpdateServiceImpl.updateInspectInfoEs(record, equipUseInfoChangeDataDto);
        }
    }
}
