package com.yeejoin.amos.boot.module.jg.biz.edit.process.equip;

import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import com.yeejoin.amos.boot.module.jg.api.dto.FieldChangeMeta;
import com.yeejoin.amos.boot.module.jg.api.dto.PieLineDesignChangeDataDto;
import com.yeejoin.amos.boot.module.jg.api.dto.PipelineChangeItemDto;
import com.yeejoin.amos.boot.module.jg.api.dto.ProjectContraptionChangeDataDto;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.IdxBizJgProjectContraptionServiceImpl;
import com.yeejoin.amos.boot.module.ymt.api.entity.IdxBizJgProjectContraption;
import org.springframework.stereotype.Component;

import java.util.List;

@Component
public class PieLineDataChangeServiceImpl {

    private final CommonEquipDataProcessService commonEquipDataProcessService;

    private final IdxBizJgProjectContraptionServiceImpl idxBizJgProjectContraptionServiceImpl;

    private final EquipChangeDataUpdateServiceImpl equipChangeDataUpdateServiceImpl;

    public PieLineDataChangeServiceImpl(CommonEquipDataProcessService commonEquipDataProcessService, IdxBizJgProjectContraptionServiceImpl idxBizJgProjectContraptionServiceImpl, EquipChangeDataUpdateServiceImpl equipChangeDataUpdateServiceImpl) {
        this.commonEquipDataProcessService = commonEquipDataProcessService;
        this.idxBizJgProjectContraptionServiceImpl = idxBizJgProjectContraptionServiceImpl;
        this.equipChangeDataUpdateServiceImpl = equipChangeDataUpdateServiceImpl;
    }

    public void update(ProjectContraptionChangeDataDto projectContraptionChangeDataDtoNew, List<FieldChangeMeta> allChangeColumns) {
        // 原有对象行转列
        ProjectContraptionChangeDataDto projectContraptionChangeDataDtoOld = getOldProjectContraptionData(projectContraptionChangeDataDtoNew);
        List<FieldChangeMeta> newProjectContraptionChangeData = commonEquipDataProcessService.convertBeanField2Column2(projectContraptionChangeDataDtoNew, projectContraptionChangeDataDtoNew.getProjectContraptionId());
        // 新对象构造行转列
        List<FieldChangeMeta> oldProjectContraptionChangeData = commonEquipDataProcessService.convertBeanField2Column2(projectContraptionChangeDataDtoOld, projectContraptionChangeDataDtoNew.getProjectContraptionId());
        // 数据比对记录变化字段列表
        allChangeColumns.addAll(commonEquipDataProcessService.mergeChangeFields(newProjectContraptionChangeData, oldProjectContraptionChangeData));
        // 数据入库
        LambdaUpdateWrapper<IdxBizJgProjectContraption> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(BaseEntity::getSequenceNbr, projectContraptionChangeDataDtoNew.getProjectContraptionId());
        updateWrapper.set(IdxBizJgProjectContraption::getProjectContraption, projectContraptionChangeDataDtoNew.getProjectContraption());
        updateWrapper.set(IdxBizJgProjectContraption::getProjectContraptionNo, projectContraptionChangeDataDtoNew.getProjectContraptionNo());
        updateWrapper.set(IdxBizJgProjectContraption::getPipelineLength, projectContraptionChangeDataDtoNew.getPipelineLength());
        updateWrapper.set(IdxBizJgProjectContraption::getProductPhoto, projectContraptionChangeDataDtoNew.getProductPhoto());
        updateWrapper.set(IdxBizJgProjectContraption::getOtherAccessories, projectContraptionChangeDataDtoNew.getOtherAccessories());
        updateWrapper.set(IdxBizJgProjectContraption::getProductQualificationCertificate, projectContraptionChangeDataDtoNew.getProductQualificationCertificate());
        idxBizJgProjectContraptionServiceImpl.update(null, updateWrapper);
    }

    private ProjectContraptionChangeDataDto getOldProjectContraptionData(ProjectContraptionChangeDataDto projectContraptionChangeDataDtoNew) {
        IdxBizJgProjectContraption projectContraption = idxBizJgProjectContraptionServiceImpl.getById(projectContraptionChangeDataDtoNew.getProjectContraptionId());
        return BeanUtil.copyProperties(projectContraption, ProjectContraptionChangeDataDto.class);
    }

    public void saveDesignForPieLine(String record, List<FieldChangeMeta> allChangeColumns, PipelineChangeItemDto pipelineChangeItemDto) {
        // 1.记录变化的数据对象
        PieLineDesignChangeDataDto pieLineDesignChangeDataDto = BeanUtil.copyProperties(pipelineChangeItemDto, PieLineDesignChangeDataDto.class);
        // 构造新对象行转列
        List<FieldChangeMeta> designInfoNew = commonEquipDataProcessService.convertBeanField2Column2(pieLineDesignChangeDataDto, record);
        // 老数据查询行转列
        List<FieldChangeMeta> designInfoOld = commonEquipDataProcessService.buildDesignInfoOld(record);
        allChangeColumns.addAll(commonEquipDataProcessService.mergeChangeFields(designInfoNew, designInfoOld));
        // 2.更新管道的设计单位名称
        equipChangeDataUpdateServiceImpl.updatePieLineDesignData(record, pieLineDesignChangeDataDto);
    }

    public void updateEs(ProjectContraptionChangeDataDto projectContraptionChangeDataDto) {
        equipChangeDataUpdateServiceImpl.updateRegisterEsDataPieLine(projectContraptionChangeDataDto);
    }

    public void deletePieLineBatch(List<PipelineChangeItemDto> deletedPieLines, List<FieldChangeMeta> allChangeColumns, String applyNo) {
        // todo 构建日志 allChangeColumns afterData = null
        // todo 数据库管道删除
        // todo es管道删除
    }

    void newPieLine(String projectContraptionId, PipelineChangeItemDto it, List<FieldChangeMeta> allChangeColumns, String applyNo) {
        // todo 创建管道的设备几张表
        // todo 创建道的es
        // todo 构建变更流水       beforeData = null
    }

}
