package com.yeejoin.amos.boot.module.jg.biz.edit.process.equip;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yeejoin.amos.boot.module.jg.api.dto.FieldChangeMeta;
import com.yeejoin.amos.boot.module.jg.biz.edit.process.biz.DefaultBizDataChangeHandler;
import com.yeejoin.amos.boot.module.jg.biz.edit.process.biz.strategy.IBizDataChangeHandleStrategy;
import com.yeejoin.amos.boot.module.jg.biz.edit.process.equip.strategy.IEquipChangeDataProcessStrategy;
import com.yeejoin.amos.boot.module.ymt.api.entity.*;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 单个维护设备-策略实现类
 */
@Component
@RequiredArgsConstructor
public class SingleEquipChangeProcess implements IEquipChangeDataProcessStrategy {


    private final CommonEquipDataProcessService commonEquipDataProcessService;

    @Override
    public List<FieldChangeMeta> handle(Map<String, Object> changeData, String record) {
        JSONObject changeJson = new JSONObject(changeData);
        List<FieldChangeMeta> allChangeColumns = new ArrayList<>();

        IdxBizJgUseInfo useInfoOld = commonEquipDataProcessService.getJgUseRegistrationService().getUseInfoMapper().selectOne(new LambdaQueryWrapper<IdxBizJgUseInfo>().eq(IdxBizJgUseInfo::getRecord, record));
        IdxBizJgUseInfo useInfoNew = BeanUtil.copyProperties(useInfoOld, IdxBizJgUseInfo.class);
        CommonEquipDataProcessService.castMap2Bean(changeJson, useInfoNew);
        useInfoNew.setSequenceNbr(useInfoOld.getSequenceNbr());

        IdxBizJgRegisterInfo registerInfoOld = commonEquipDataProcessService.getJgUseRegistrationService().getIdxBizJgRegisterInfoService().getOne(new LambdaQueryWrapper<IdxBizJgRegisterInfo>().eq(IdxBizJgRegisterInfo::getRecord, record));
        IdxBizJgRegisterInfo registerInfoNew = BeanUtil.copyProperties(registerInfoOld, IdxBizJgRegisterInfo.class);
        CommonEquipDataProcessService.castMap2Bean(changeJson, registerInfoNew);
        registerInfoNew.setSequenceNbr(registerInfoOld.getSequenceNbr());

        IdxBizJgFactoryInfo factoryInfoOld = commonEquipDataProcessService.getJgFactoryInfoMapper().selectOne(new LambdaQueryWrapper<IdxBizJgFactoryInfo>().eq(IdxBizJgFactoryInfo::getRecord, record));
        IdxBizJgFactoryInfo factoryInfoNew = BeanUtil.copyProperties(factoryInfoOld, IdxBizJgFactoryInfo.class);
        CommonEquipDataProcessService.castMap2Bean(changeJson, factoryInfoNew);
        factoryInfoNew.setSequenceNbr(factoryInfoOld.getSequenceNbr());

        IdxBizJgDesignInfo designInfoOld = commonEquipDataProcessService.getIdxBizJgDesignInfoMapper().selectOne(new LambdaQueryWrapper<IdxBizJgDesignInfo>().eq(IdxBizJgDesignInfo::getRecord, record));
        IdxBizJgDesignInfo designInfoNew = BeanUtil.copyProperties(designInfoOld, IdxBizJgDesignInfo.class);
        CommonEquipDataProcessService.castMap2Bean(changeJson, designInfoNew);
        designInfoNew.setSequenceNbr(designInfoOld.getSequenceNbr());

        IdxBizJgOtherInfo otherInfoOld = commonEquipDataProcessService.getIdxBizJgOtherInfoMapper().selectOne(new LambdaQueryWrapper<IdxBizJgOtherInfo>().eq(IdxBizJgOtherInfo::getRecord, record));
        IdxBizJgOtherInfo otherInfoNew = BeanUtil.copyProperties(otherInfoOld, IdxBizJgOtherInfo.class);
        CommonEquipDataProcessService.castMap2Bean(changeJson, otherInfoNew);
        otherInfoNew.setSequenceNbr(otherInfoOld.getSequenceNbr());

        IdxBizJgSupervisionInfo idxBizJgSupervisionInfoOld = commonEquipDataProcessService.getJgUseRegistrationService().getIdxBizJgSupervisionInfoMapper().selectOne(new LambdaQueryWrapper<IdxBizJgSupervisionInfo>().eq(IdxBizJgSupervisionInfo::getRecord, record));
        IdxBizJgSupervisionInfo idxBizJgSupervisionInfoNew = BeanUtil.copyProperties(idxBizJgSupervisionInfoOld, IdxBizJgSupervisionInfo.class);
        CommonEquipDataProcessService.castMap2Bean(changeJson, idxBizJgSupervisionInfoNew);
        idxBizJgSupervisionInfoNew.setSequenceNbr(idxBizJgSupervisionInfoOld.getSequenceNbr());

        String jySeq = changeJson.getString("jySeq");
        String maintenanceSeq = changeJson.getString("maintenanceSeq");
        String constructionInfoSeq = changeJson.getString("constructionInfoSeq");
        if (jySeq != null) {
            IdxBizJgInspectionDetectionInfo inspectionDetectionInfoOld = commonEquipDataProcessService.getJgUseRegistrationService().getInspectionDetectionInfoService().getById(jySeq);
            IdxBizJgInspectionDetectionInfo inspectionDetectionInfoNew = BeanUtil.copyProperties(inspectionDetectionInfoOld, IdxBizJgInspectionDetectionInfo.class);
            CommonEquipDataProcessService.castMap2Bean(changeJson, inspectionDetectionInfoNew);
            inspectionDetectionInfoNew.setSequenceNbr(inspectionDetectionInfoOld.getSequenceNbr());
            List<FieldChangeMeta> inspectionFieldChangeMetas = commonEquipDataProcessService.simpleTrackAndUpdate(commonEquipDataProcessService.getJgUseRegistrationService().getInspectionDetectionInfoService().getBaseMapper(), inspectionDetectionInfoOld, inspectionDetectionInfoNew, useInfoNew.getRecord(), "SEQUENCE_NBR", inspectionDetectionInfoOld.getSequenceNbr());
            allChangeColumns.addAll(inspectionFieldChangeMetas);
            commonEquipDataProcessService.updateEsDataOfEquip(record, inspectionDetectionInfoNew);
        }
        if (maintenanceSeq != null) {
            IdxBizJgMaintenanceRecordInfo idxBizJgMaintenanceRecordInfoOld = commonEquipDataProcessService.getJgUseRegistrationService().getIdxBizJgMaintenanceRecordInfoService().getById(maintenanceSeq);
            IdxBizJgMaintenanceRecordInfo idxBizJgMaintenanceRecordInfoNew = BeanUtil.copyProperties(idxBizJgMaintenanceRecordInfoOld, IdxBizJgMaintenanceRecordInfo.class);
            CommonEquipDataProcessService.castMap2Bean(changeJson, idxBizJgMaintenanceRecordInfoNew);
            idxBizJgMaintenanceRecordInfoNew.setSequenceNbr(idxBizJgMaintenanceRecordInfoOld.getSequenceNbr());
            List<FieldChangeMeta> idxBizJgMaintenanceFieldChangeMetas = commonEquipDataProcessService.simpleTrackAndUpdate(commonEquipDataProcessService.getJgUseRegistrationService().getIdxBizJgMaintenanceRecordInfoService().getBaseMapper(), idxBizJgMaintenanceRecordInfoOld, idxBizJgMaintenanceRecordInfoNew, useInfoNew.getRecord(), "SEQUENCE_NBR", idxBizJgMaintenanceRecordInfoOld.getSequenceNbr());
            allChangeColumns.addAll(idxBizJgMaintenanceFieldChangeMetas);
        }
        if (constructionInfoSeq != null) {
            IdxBizJgConstructionInfo constructionInfoOld = commonEquipDataProcessService.getJgUseRegistrationService().getIdxBizJgConstructionInfoService().getById(constructionInfoSeq);
            IdxBizJgConstructionInfo constructionInfoNew = BeanUtil.copyProperties(constructionInfoOld, IdxBizJgConstructionInfo.class);
            CommonEquipDataProcessService.castMap2Bean(changeJson, constructionInfoNew);
            constructionInfoNew.setSequenceNbr(constructionInfoOld.getSequenceNbr());
            List<FieldChangeMeta> constructionInfoFieldChangeMetas = commonEquipDataProcessService.simpleTrackAndUpdate(commonEquipDataProcessService.getJgUseRegistrationService().getIdxBizJgConstructionInfoService().getBaseMapper(), constructionInfoOld, constructionInfoNew, useInfoNew.getRecord(), "SEQUENCE_NBR", constructionInfoOld.getSequenceNbr());
            allChangeColumns.addAll(constructionInfoFieldChangeMetas);
        }
        // 前置校验、新数据解析
        commonEquipDataProcessService.checkValidField2(record, registerInfoNew, null, null, null);
        commonEquipDataProcessService.checkValidField2(record, factoryInfoNew, registerInfoNew.getEquList(), registerInfoNew.getEquCategory(), registerInfoNew.getEquDefine());
        commonEquipDataProcessService.checkValidField2(record, designInfoNew, registerInfoNew.getEquList(), registerInfoNew.getEquCategory(), registerInfoNew.getEquDefine());

        // 设备制造、设计、注册信息业务处理落库
        List<FieldChangeMeta> useInfoFieldChangeMetas = commonEquipDataProcessService.simpleTrackAndUpdate(commonEquipDataProcessService.getJgUseRegistrationService().getUseInfoMapper(), useInfoOld, useInfoNew, useInfoNew.getRecord(), "record", useInfoNew.getRecord());
        allChangeColumns.addAll(useInfoFieldChangeMetas);

        List<FieldChangeMeta> registerInfoFieldChangeMetas = commonEquipDataProcessService.simpleTrackAndUpdate(commonEquipDataProcessService.getJgUseRegistrationService().getIdxBizJgRegisterInfoService().getBaseMapper(), registerInfoOld, registerInfoNew, useInfoNew.getRecord(), "record", useInfoNew.getRecord());
        allChangeColumns.addAll(registerInfoFieldChangeMetas);

        List<FieldChangeMeta> factoryInfoFieldChangeMetas = commonEquipDataProcessService.simpleTrackAndUpdate(commonEquipDataProcessService.getJgFactoryInfoMapper(), factoryInfoOld, factoryInfoNew, useInfoNew.getRecord(), "record", useInfoNew.getRecord());
        allChangeColumns.addAll(factoryInfoFieldChangeMetas);

        List<FieldChangeMeta> designInfoFieldChangeMetas = commonEquipDataProcessService.simpleTrackAndUpdate(commonEquipDataProcessService.getIdxBizJgDesignInfoMapper(), designInfoOld, designInfoNew, useInfoNew.getRecord(), "record", useInfoNew.getRecord());
        allChangeColumns.addAll(designInfoFieldChangeMetas);

        List<FieldChangeMeta> otherInfoFieldChangeMetas = commonEquipDataProcessService.simpleTrackAndUpdate(commonEquipDataProcessService.getIdxBizJgOtherInfoMapper(), otherInfoOld, otherInfoNew, useInfoNew.getRecord(), "record", useInfoNew.getRecord());
        allChangeColumns.addAll(otherInfoFieldChangeMetas);

        List<FieldChangeMeta> idxBizJgSupervisionInfoFieldChangeMetas = commonEquipDataProcessService.simpleTrackAndUpdate(commonEquipDataProcessService.getJgUseRegistrationService().getIdxBizJgSupervisionInfoMapper(), idxBizJgSupervisionInfoOld, idxBizJgSupervisionInfoNew, useInfoNew.getRecord(), "record", useInfoNew.getRecord());
        allChangeColumns.addAll(idxBizJgSupervisionInfoFieldChangeMetas);

        commonEquipDataProcessService.updateEsDataOfEquip(record, useInfoNew);
        commonEquipDataProcessService.updateEsDataOfEquip(record, designInfoNew);
        commonEquipDataProcessService.updateEsDataOfEquip(record, otherInfoNew);
        commonEquipDataProcessService.updateEsDataOfEquip(record, factoryInfoNew);
        // 设备技术参数入库处理
        commonEquipDataProcessService.updateTechParamInfo(registerInfoOld.getEquList(), record, changeData, allChangeColumns);
        return allChangeColumns;
    }

    @Override
    public IBizDataChangeHandleStrategy.ModelType canHandleMode() {
        return DefaultBizDataChangeHandler.ModelType.singleEquip;
    }

}
