package com.yeejoin.amos.boot.module.jg.biz.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.yeejoin.amos.boot.module.jg.api.dto.*;
import com.yeejoin.amos.boot.module.jg.biz.edit.event.BaseBizDataChangeEvent;
import com.yeejoin.amos.boot.module.jg.biz.edit.process.equip.CommonEquipDataProcessService;
import com.yeejoin.amos.boot.module.jg.biz.event.publisher.EventPublisher;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.typroject.tyboot.core.foundation.context.RequestContext;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component
@RequiredArgsConstructor
public class SingleManageEquipEditHandleImpl {
    private final CommonEquipDataProcessService commonEquipDataProcessService;

    private final EventPublisher publisher;

    public static final String BIZ_TYPE = "singleManageEquipEdit";

    public Map<String, ?> getDetail(String applyNo, String bizId) {
        return this.getDetailByBizId(bizId);
    }

    public Map<String, Object> getDetailByBizId(String record) {
        Map<String, Object> re = new HashMap<>();
        // 注册信息(基本信息)构建
        EquipRegisterChangeDataDto equipRegisterChangeDataDto = commonEquipDataProcessService.buildRegisterInfo(record);
        // 制造信息构建
        EquipFactoryChangeDataDto factoryChangeDataDto = commonEquipDataProcessService.buildFactoryInfo(record);
        // 设计信息构建
        EquipDesignChangeDataDto designChangeDataDto = commonEquipDataProcessService.buildDesignInfo(record);
        // 使用信息
        EquipUseInfoChangeDataDto equipUseInfoChangeDataDto = commonEquipDataProcessService.buildUseInfo(record);
        re.putAll(BeanUtil.beanToMap(equipRegisterChangeDataDto));
        re.putAll(BeanUtil.beanToMap(factoryChangeDataDto));
        re.putAll(BeanUtil.beanToMap(designChangeDataDto));
        re.putAll(BeanUtil.beanToMap(equipUseInfoChangeDataDto));
        commonEquipDataProcessService.castJsonFields(re);
        return commonEquipDataProcessService.cast2UnderCase(re);
    }


    @Transactional(rollbackFor = Exception.class)
    public void doSave(String record, Map<String, Object> changeData) {
        List<FieldChangeMeta> allChangeColumns = this.update(record, changeData);
        // 记录流水
        if (!allChangeColumns.isEmpty()) {
            // 更新历史的JSON的数据
            this.buildLogData(allChangeColumns);
            // 异步记录变更流水
            publishEvent2Logger(record, allChangeColumns);
        }
    }

    private void publishEvent2Logger(String record, List<FieldChangeMeta> allChangeColumns) {
        BizRelationDataDto relationDataDto = new BizRelationDataDto();
        relationDataDto.setBizId(record);
        relationDataDto.setBizType(BIZ_TYPE);
        // 异步记录日志
        publisher.publish(new BaseBizDataChangeEvent(this, relationDataDto, allChangeColumns, RequestContext.cloneRequestContext()));
    }


    private List<FieldChangeMeta> update(String record, Map<String, Object> changeData) {
        List<FieldChangeMeta> allChangeColumns = new ArrayList<>();
        // 新数据解析
        EquipRegisterChangeDataDto registerChangeDataDto = commonEquipDataProcessService.castMap2Bean(changeData, EquipRegisterChangeDataDto.class);
        EquipFactoryChangeDataDto factoryChangeDataDto = commonEquipDataProcessService.castMap2Bean(changeData, EquipFactoryChangeDataDto.class);
        EquipDesignChangeDataDto designChangeDataDto = commonEquipDataProcessService.castMap2Bean(changeData, EquipDesignChangeDataDto.class);
        EquipUseInfoChangeDataDto useInfoChangeDataDto = commonEquipDataProcessService.castMap2Bean(changeData, EquipUseInfoChangeDataDto.class);
        commonEquipDataProcessService.buildChangeFields(record, designChangeDataDto, factoryChangeDataDto, registerChangeDataDto, null, useInfoChangeDataDto, allChangeColumns);
        // 前置校验
        commonEquipDataProcessService.checkValidField(record, registerChangeDataDto, registerChangeDataDto.getEquList(), registerChangeDataDto.getEquCategory(), registerChangeDataDto.getEquDefine());
        commonEquipDataProcessService.checkValidField(record, factoryChangeDataDto, registerChangeDataDto.getEquList(), registerChangeDataDto.getEquCategory(), registerChangeDataDto.getEquDefine());
        commonEquipDataProcessService.checkValidField(record, designChangeDataDto, registerChangeDataDto.getEquList(), registerChangeDataDto.getEquCategory(), registerChangeDataDto.getEquDefine());
        // 设备制造、设计、注册、使用信息业务处理落库
        commonEquipDataProcessService.dealBizDataForEquip(record, registerChangeDataDto);
        commonEquipDataProcessService.dealBizDataForEquip(record, factoryChangeDataDto);
        commonEquipDataProcessService.dealBizDataForEquip(record, designChangeDataDto);
        commonEquipDataProcessService.dealBizDataForEquip(record, useInfoChangeDataDto);
        return allChangeColumns;
    }


    private void buildLogData(List<FieldChangeMeta> allChangeColumns) {
        allChangeColumns.forEach(column -> {
            column.setBizType("监管端编辑设备信息");
        });
    }

}
