package com.yeejoin.amos.boot.module.statistics.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

@AllArgsConstructor
@Getter
public enum RegulatoryUnitLevelEnum {

    /**
     * *监管单位类型
     */

    省局("省局", "headquarter"),
    市局("市局", "prefecture-level"),
    区县局("区县局", "county");

    private final String name;
    private final String code;

    public static Map<String, String> getName = new HashMap<>();
    public static Map<String, String> getCode = new HashMap<>();


    static {
        for (RegulatoryUnitLevelEnum e : RegulatoryUnitLevelEnum.values()) {
            getName.put(e.code, e.name);
            getCode.put(e.name, e.code);
        }
    }

    public static RegulatoryUnitLevelEnum getEnumByCode(String code) {
        return Arrays.stream(RegulatoryUnitLevelEnum.values()).filter(r -> r.code.equals(code)).findFirst().orElse(null);
    }
}
