package com.yeejoin.amos.boot.module.ymt.api.entity;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.annotation.FieldDisplayDefine;
import com.yeejoin.amos.boot.biz.common.annotation.Group;
import com.yeejoin.amos.boot.biz.common.entity.TzsBaseEntity;
import com.yeejoin.amos.boot.module.common.api.dto.IBaseChangeData;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * 施工信息表
 *
 * @author system_generator
 * @date 2023-08-17
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("idx_biz_jg_construction_info")
@Group("idx_biz_jg_construction_info")
public class IdxBizJgConstructionInfo extends TzsBaseEntity implements IBaseChangeData {


    /**
     *
     */
    @TableField("\"RECORD\"")
    private String record;

    /**
     *
     */
    @TableField("\"INSTANCE_ID\"")
    private String instanceId;

    /**
     *
     */
    @TableField("\"STATUS\"")
    private String status;

    /**
     *
     */
    @TableField("\"CONSTRUCTION_TYPE\"")
    private String constructionType;

    /**
     *
     */
    @TableField("\"USC_UNIT_CREDIT_CODE\"")
    private String uscUnitCreditCode;

    /**
     * 施工单位名称
     */
    @TableField("\"USC_UNIT_NAME\"")
    @FieldDisplayDefine(value = "施工单位名称")
    private String uscUnitName;

    /**
     * 施工日期
     */
    @TableField("\"USC_DATE\"")
    @FieldDisplayDefine(value = "施工日期")
    private Date uscDate;

    /**
     *
     */
    @TableField("\"SEQUENCE_CODE\"")
    private String sequenceCode;

    @TableField(exist = false)
    private String supervisoryCode;


    /**
     * 告知业务id-告知作废时使用
     */
    @TableField(value = "\"NOTICE_ID\"")
    private String noticeId;


    /**
     * 告知书编号
     */
    @TableField(value = "\"INFORM_CODE\"")
    private String informCode;

    /**
     * 告知书路径
     */
    @TableField(value = "\"INFORM_FILE_PATH\"")
    private String informFilePath;

    /**
     * 施工负责人
     */
    @TableField(value = "\"CONSTRUCTION_LEADER_NAME\"")
    @FieldDisplayDefine(value = "施工负责人")
    private String constructionLeaderName;

    /**
     * 施工负责人手机
     */
    @TableField(value = "\"CONSTRUCTION_LEADER_PHONE\"")
    @FieldDisplayDefine(value = "施工负责人手机")
    private String constructionLeaderPhone;

    /**
     * 施工委托书附件
     */
    @TableField(value = "\"PROXY_STATEMENT_ATTACHMENT\"")
    @FieldDisplayDefine(value = "施工委托书附件", type = JSON.class)
    private String proxyStatementAttachment;

    /**
     * 施工合同照片
     */
    @TableField(value = "\"CONSTRUCTION_CONTRACT_ATTACHMENT\"")
    @FieldDisplayDefine(value = "施工合同附件", type = JSON.class)
    private String constructionContractAttachment;

    /**
     * 其他附件
     */
    @FieldDisplayDefine(value = "其他附件", type = JSON.class)
    @TableField(value = "\"CONSTRUCTION_OTHER_ACCESSORIES\"")
    private String constructionOtherAccessories;

    @FieldDisplayDefine(value = "施工区域-省")
    @TableField(value = "\"CONSTRUCTION_PROVINCE\"")
    private String constructionProvince;

    @FieldDisplayDefine(value = "施工区域-市")
    @TableField(value = "\"CONSTRUCTION_CITY\"")
    private String constructionCity;

    @FieldDisplayDefine(value = "施工区域-区/县")
    @TableField(value = "\"CONSTRUCTION_COUNTY\"")
    private String constructionCounty;

    @FieldDisplayDefine(value = "施工区域-街道")
    @TableField(value = "\"CONSTRUCTION_STREET\"")
    private String constructionStreet;


    @FieldDisplayDefine(value = "施工区域-详细地址")
    @TableField(value = "\"CONSTRUCTION_ADDRESS\"")
    private String constructionAddress;
}
