package com.yeejoin.amos.boot.module.ymt.api.entity;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.annotation.FieldDisplayDefine;
import com.yeejoin.amos.boot.biz.common.annotation.Group;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import com.yeejoin.amos.boot.biz.common.entity.TzsBaseEntity;
import com.yeejoin.amos.boot.module.common.api.dto.IBaseChangeData;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import java.util.Date;

/**
 * 安全追溯-检验检测信息表
 *
 * @author system_generator
 * @date 2023-08-17
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("idx_biz_jg_inspection_detection_info")
@Group("idx_biz_jg_inspection_detection_info")
public class IdxBizJgInspectionDetectionInfo extends TzsBaseEntity implements IBaseChangeData {



    /**
     *
     */
    @TableField("\"RECORD\"")
    private String record;

    /**
     *
     */
    @TableField("\"INSTANCE_ID\"")
    private String instanceId;

    /**
     *
     */
    @TableField("\"STATUS\"")
    private String status;

    /**
     *
     */
    @TableField("\"INSPECT_TYPE\"")
    @FieldDisplayDefine(value ="检验类型")
    private String inspectType;

    /**
     *
     */
    @TableField("\"INSPECT_ORG_CODE\"")
    @FieldDisplayDefine(value ="检验机构统一信用代码")
    private String inspectOrgCode;

    /**
     *
     */
    @TableField("\"INSPECT_ORG_NAME\"")
    @FieldDisplayDefine(value ="检验机构名称")
    private String inspectOrgName;

    /**
     *
     */
    @TableField("\"INSPECT_REPORT\"")
    @FieldDisplayDefine(value ="检验报告", type = JSON.class)
    private String inspectReport;

    /**
     *
     */
    @TableField("\"INSPECT_STAFF\"")
    private String inspectStaff;

    /**
     *
     */
    @TableField("\"INSPECT_DATE\"")
    @FieldDisplayDefine(value ="检验日期")
    private Date inspectDate;

    /**
     *
     */
    @TableField("\"INSPECT_CONCLUSION\"")
    @FieldDisplayDefine(value ="检验结论")
    private String inspectConclusion;

    /**
     *
     */
    @TableField("\"SAFETY_LEVEL\"")
    private String safetyLevel;

    /**
     *
     */
    @TableField("\"PROBLEM_REMARK\"")
    private String problemRemark;

    /**
     *
     */
    @TableField("\"NEXT_INSPECT_DATE\"")
    @FieldDisplayDefine(value = "下次检验日期")
    private Date nextInspectDate;

    /**
     *
     */
    @TableField("\"SEQUENCE_CODE\"")
    private String sequenceCode;

    /**
     *
     */
    @TableField("\"INSPECT_REPORT_NO\"")
    @FieldDisplayDefine(value ="检验报告编号")
    private String inspectReportNo;

    @TableField(exist = false)
    private String supervisoryCode;

    /**
     * 检验人员ids（检验检测业务使用）
     */
    @TableField(value ="\"INSPECT_STAFF_CODE\"")
    private String inspectStaffCode;
}
