package com.yeejoin.amos.boot.module.common.api.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import java.time.LocalDateTime;
import org.typroject.tyboot.core.rdbms.orm.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 反馈回复表
 * </p>
 *
 * @author system_generator
 * @since 2025-05-15
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("tzs_feedback_replies")
@ApiModel(value="FeedbackReplies对象", description="反馈回复表")
public class FeedbackReplies extends BaseEntity {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "创建人id")
    private String createUserId;

    @ApiModelProperty(value = "创建人")
    private String createUserName;

    @ApiModelProperty(value = "创建时间（回复时间）")
    private LocalDateTime createDate;

    @ApiModelProperty(value = "回复描述")
    private String replyDescription;

    @ApiModelProperty(value = "回复用户id")
    private Integer replyUserId;

    @ApiModelProperty(value = "回复用户姓名")
    private String replyUserName;

    @ApiModelProperty(value = "反馈建议表seq")
    private String suggestionsSeq;

    @ApiModelProperty(value = "已读状态（1：已读，0：未读）")
    private String readStatus;

    @ApiModelProperty(value = "回复单位code")
    private String replyCompanyCode;

    @ApiModelProperty(value = "回复单位名称")
    private String replyCompanyName;


}
