package com.yeejoin.amos.boot.module.hygf.api.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.extension.handlers.FastjsonTypeHandler;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * 户用光伏监盘逆变器报警表
 *
 * @author system_generator
 * @date 2023-09-19
 */
@Data
@ApiModel(value="TdHygfJpInverterWarnDto", description="户用光伏监盘逆变器报警表")
public class TdHygfJpInverterWarnDto {

	private static final long serialVersionUID = 1L;

	@ApiModelProperty(value = "sn编码")
	private String snCode;

	@ApiModelProperty(value = "内容")
	private String content;

	@ApiModelProperty(value = "等级")
	private String level;

	@ApiModelProperty(value = "时长")
	private Long timeLong;

	@ApiModelProperty(value = "起始时间")
	private Long startTime;

	@ApiModelProperty(value = "报警时间")
	private Date startTimeDate;

	@ApiModelProperty(value = "恢复时间")
	private Long recoverTime;


	@ApiModelProperty(value = "恢复时间")
	private Date recoverTimeString;

	@ApiModelProperty(value = "处理方法")
	private String treatment;

	@ApiModelProperty(value = "第三方电站id")
	private String thirdStationId;

	@ApiModelProperty(value = "第三方厂商标识")
	private String thirdCode;

	@ApiModelProperty(value = "状态")
	private String state;

	@ApiModelProperty(value = "时间")
	private Long time;
	
	private String stationName;
	
	private String stationContact;
	
	private String userName;
	
	private String userPhone;
	
	private String email;
	
	private String address;
	
	private String area;
	
	private Long createdTime;
	
	private String timeLongFormat;

	private String startTimeFormat;

	private String recoverTimeFormat;
	
	private List<String> stationIds;
	
	private List<String> states;
    private String name;
    private String handlerStatus;
    private List<String>  listHandlerStatus;


	/**
	 * 场站id
	 */
	@TableField("station_id")
	private String stationId;

	/**
	 * 业主名称
	 */
	@TableField("owner_name")
	private String ownerName;

	/**
	 * 逆变器sn编码
	 */
	@TableField("inverter_sn")
	private String inverterSn;
	/**
	 * 告警等级
	 */
	@TableField("warning_level")
	private String warningLevel;
	/**
	 * 告警状态
	 */
	@TableField("warning_status")
	private String warningStatus;
	/**
	 * 告警内容
	 */
	@TableField("warning_content")
	private String warningContent;
	/**
	 * 告警开始时间
	 */
	@TableField("warning_start_time")
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	private Date warningStartTime;
	/**
	 * 告警开始时间
	 */
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	@TableField("warning_end_time")
	private Date warningEndTime;
	/**
	 * 告警时长
	 */
	@TableField("warning_duration")
	private String warningDuration;

	/**
	 * 场站联系人电话
	 */
	@TableField("station_contact_phone")
	private String stationContactPhone;
	/**
	 * 场站地址
	 */
	@TableField("station_address")
	private String stationAddress;
	/**
	 * 处理附件
	 */
	@TableField(value = "handler_content_attachment",typeHandler = FastjsonTypeHandler.class)
	private List<Object> hanlerContentAttachment;
	/**
	 * 处理方式
	 */
	@TableField("handler_method")
	private String handlerMethod;
	/**
	 * 是否替换备件
	 */
	@TableField("is_repleace_spare_parts")
	private Boolean isReplaceSpareParts =false;
	/**
	 * 运维人员附件
	 */
	@TableField(value = "spare_parts_attchment",typeHandler = FastjsonTypeHandler.class)
	private List<Object> sparePartsAttchment;
	/**
	 * 场站运维人员id
	 */
	@TableField("maintenance_person_id")
	private String maintenancePersonId;
	/**
	 * 场站经度
	 */
	@TableField("station_longitude")
	private String stationLongitude;
	/**
	 * 场站纬度
	 */
	@TableField("station_latitude")
	private String stationLatitude;
	/**
	 * 运维人员名称
	 */
	@TableField("maintenance_person_name")
	private String maintenancePersonName;
	/**
	 * 运维人员手机号
	 */
	@TableField("maintenance_person_phone")
	private String maintenancePersonPhone;
	/**
	 * tdengine告警id
	 */
	@TableField("warning_id")
	private Long warningId;
	/**
	 * 区域公司orgCode
	 */
	@TableField("regional_companies_code")
	private String regionalCompaniesCode;

	/**
	 * 经销商orgcode
	 */
	@TableField("amos_company_code")
	private String amosCompanyCode;
	@TableField("ticket_type")
	private String ticketType;

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	@TableField("task_start_time")
	private Date taskStartTime;
	/**
	 * 告警开始时间
	 */
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	@TableField("task_end_time")
	private Date taskEndTime;

}
