package com.yeejoin.amos.boot.module.hygf.biz.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.hygf.api.dto.PowerStationDto;
import com.yeejoin.amos.boot.module.hygf.biz.service.impl.PowerStationServiceImpl;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Map;

/**
 *
 *
 * @author system_generator
 * @date 2023-07-15
 */
@RestController
@Api(tags = "Api")
@RequestMapping(value = "/power-station")
public class PowerStationController extends BaseController {

    @Autowired
    PowerStationServiceImpl powerStationServiceImpl;

    /**
     * 新增
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增", notes = "新增")
	public ResponseModel<PowerStationDto> save(@RequestBody PowerStationDto model) {
	    model = powerStationServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新", notes = "根据sequenceNbr更新")
	public ResponseModel<PowerStationDto> updateBySequenceNbrPowerStation(@RequestBody PowerStationDto model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(powerStationServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除", notes = "根据sequenceNbr删除")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(powerStationServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个",  notes = "根据sequenceNbr查询单个")
	public ResponseModel<PowerStationDto> selectOne(@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(powerStationServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "分页查询",  notes = "分页查询")
	public ResponseModel<Page<PowerStationDto>> queryForPage(@RequestParam(value = "current") int current,
															 														@RequestParam(value = "size") int size,
															 														@RequestParam(value = "powerStationCode",required = false)String powerStationCode,
															 														@RequestParam(value = "ownersName",required = false)String ownersName) {
	    Page<PowerStationDto> page = new Page<PowerStationDto>();
	    page.setCurrent(current);
	    page.setSize(size);
		AgencyUserModel userInfo = getUserInfo();
		return ResponseHelper.buildResponse(powerStationServiceImpl.queryForPowerStationUserRoles(page,powerStationCode,ownersName,userInfo));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "列表全部数据查询",   notes = "列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<PowerStationDto>> selectForList() {
	    return ResponseHelper.buildResponse(powerStationServiceImpl.queryForPowerStationList());
	}

	/**
	 * 列表全部数据查询
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "POST",value = "电站审核",   notes = "电站审核")
	@PostMapping(value = "/powerStationExamine")
	public ResponseModel<String> powerStationExamine(@RequestParam(value = "pageId") long pageId,
														 			@RequestParam(value = "nodeCode") String nodeCode,
													 				@RequestParam(value = "stationId") String stationId,
																	@RequestParam(value = "taskId") String taskId,
																	@RequestParam(value = "planInstanceId") String planInstanceId,
																	@RequestBody Map<String, Object> kv) {
		return ResponseHelper.buildResponse(powerStationServiceImpl.powerStationExamine(pageId, nodeCode, stationId, taskId, planInstanceId, kv));
	}
}
