package com.yeejoin.amos.boot.module.jcs.biz.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import com.yeejoin.amos.boot.module.jcs.api.entity.OrganizationUser;
import com.yeejoin.amos.boot.module.jcs.api.mapper.OrganizationUserMapper;
import com.yeejoin.amos.boot.module.jcs.api.service.IOrganizationUserService;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import org.typroject.tyboot.core.rdbms.service.BaseService;

@Service
public class OrganizationUserImpl extends BaseService<OrganizationUser,OrganizationUser, OrganizationUserMapper> implements IOrganizationUserService {
    @Override
    public OrganizationUser saveOrganization(OrganizationUser organizationUser) {
        return this.createWithModel(organizationUser);
    }

    @Override
    public OrganizationUser updateModelById(OrganizationUser organizationUser) {
        return this.updateWithModel(organizationUser);
    }

    @Override
    public OrganizationUser getDetailsById(Long id) {
        return this.baseMapper.selectById(id);
    }

    @Override
    public IPage<OrganizationUser> getListPage(int pageNumber, int pageSize, Long id) {
        Page<OrganizationUser> page = new Page<>();
        page.setSize(pageSize);
        page.setCurrent(pageNumber);

        LambdaQueryWrapper<OrganizationUser> wrapper = new LambdaQueryWrapper<>();
        if (!ObjectUtils.isEmpty(id) && id != 0) {
            wrapper.eq(OrganizationUser::getEmergencyTeamId, id);
        }
       // wrapper.orderByDesc(BaseEntity::getRecDate);
        wrapper.eq(OrganizationUser::getIsDelete, false);
        wrapper.orderByDesc(OrganizationUser::getSort);
        return this.baseMapper.selectPage(page, wrapper);
    }

    @Override
    public int deleteById(Long id) {
        return this.baseMapper.deleteById(id);
    }
}
