package com.yeejoin.amos.boot.module.tdc.biz.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.tdc.api.dto.CheckModelDto;
import com.yeejoin.amos.boot.module.tdc.api.entity.CheckModel;
import com.yeejoin.amos.boot.module.tdc.api.service.CheckModelService;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.List;
import java.util.Map;

/**
 * @author xxz
 */
@RestController
@Api(tags = "校验模型api")
@RequestMapping(value = "/model")
public class CheckModelController extends BaseController {

    @Autowired
    CheckModelService checkModelService;

    /**
     * 根据amosOrgCode查询
     * return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @GetMapping(value = "selectByOrgCode")
    @ApiOperation(httpMethod = "GET",value = "根据amosOrgCode查询模型列表",  notes = "根据amosOrgCode查询模型列表")
    public ResponseModel<IPage<CheckModelDto>> selectByOrgCode(int current, int size, String amosOrgCode) {
        return ResponseHelper.buildResponse(checkModelService.selectByOrgCode(current,size,amosOrgCode));
    }

    /**
     * 根据amosOrgCode查询
     * return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @GetMapping(value = "selectBySequenceNbr")
    @ApiOperation(httpMethod = "GET",value = "根据amosOrgCode查询模型列表",  notes = "根据amosOrgCode查询模型列表")
    public ResponseModel<CheckModel> selectBySequenceNbr(String sequenceNbr) {
        return ResponseHelper.buildResponse(checkModelService.getById(sequenceNbr));
    }

    /**
     * 根据amosOrgCode查询
     * return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @GetMapping(value = "selectOneByDate")
    @ApiOperation(httpMethod = "GET",value = "根据code查询最后一次校验模型",  notes = "查询code最后一次校验模型")
    public ResponseModel<CheckModel> selectOneByDate(String amosOrgCode) {
        return ResponseHelper.buildResponse(checkModelService.selectOneByDate(amosOrgCode));
    }

    /**
     * 点击全站校验
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @GetMapping(value = "/CheckAllModel/{amosOrgCode}")
    @ApiOperation(httpMethod = "GET",value = "点击全站校验",  notes = "根据机构code校验模型")
    public void CheckAllModel(@PathVariable(value = "amosOrgCode") String amosOrgCode) {
        AgencyUserModel userInfo = getUserInfo();
        checkModelService.checkAllMode(amosOrgCode, userInfo);
    }

    /**
     * 点击单独模型校验
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @GetMapping(value = "/checkSingleMode/{modelId}")
    @ApiOperation(httpMethod = "GET",value = "点击单独模型校验",  notes = "根据modelId校验模型")
    public void checkSingleMode(@PathVariable(value = "modelId") String modelId) {
        AgencyUserModel userInfo = getUserInfo();
        checkModelService.checkSingleMode(modelId, userInfo);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @GetMapping(value = "/companyTree")
    @ApiOperation(httpMethod = "GET",value = "下拉框选项",  notes = "下拉框选项")
    public ResponseModel<String> getOrgCode(String companyName){
        return ResponseHelper.buildResponse(checkModelService.getOrgCode(companyName));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @GetMapping(value = "/getDataTree")
    @ApiOperation(httpMethod = "GET", value = "关联表单", notes = "关联表单")
    public ResponseModel<JSONArray> getDataTree() {
        return ResponseHelper.buildResponse(checkModelService.getDataTree());
    }



    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @GetMapping(value = "/getRule")
    @ApiOperation(httpMethod = "GET", value = "关联规则", notes = "关联规则")
    public ResponseModel<List<JSONObject>> getRule(String project) {
        return ResponseHelper.buildResponse(checkModelService.getRule(project));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @GetMapping(value = "/getCompanyName")
    @ApiOperation(httpMethod = "GET", value = "所属机构", notes = "所属机构")
    public ResponseModel<List<Object>> getCompanyName() {
        return ResponseHelper.buildResponse(checkModelService.getCompanyName());
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @PostMapping(value = "/saveModel")
    @ApiOperation(httpMethod = "POST", value = "存模型表", notes = "存模型表")
    public ResponseModel<String> saveModel(@RequestBody JSONObject jsonObject ){
        return ResponseHelper.buildResponse(checkModelService.saveModel(jsonObject));

    }

    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @PostMapping(value = "/modifyModel")
    @ApiOperation(httpMethod = "POST", value = "根据sequenceNbr修改模型校验表单", notes = "根据sequenceNbr修改模型校验表单")
    public ResponseModel<Boolean> modifyModel(@RequestBody JSONObject jsonObject) {
//        checkModelService.updateById(checkModel);
        return ResponseHelper.buildResponse(checkModelService.modifyModel(jsonObject));
    }

}
