package com.yeejoin.amos.boot.module.common.biz.service.impl;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.common.api.dto.FailureAuditDto;
import com.yeejoin.amos.boot.module.common.api.dto.FailureDetailsDto;
import com.yeejoin.amos.boot.module.common.api.entity.FailureAudit;
import com.yeejoin.amos.boot.module.common.api.enums.AuditResultEnum;
import com.yeejoin.amos.boot.module.common.api.enums.FailureStatuEnum;
import com.yeejoin.amos.boot.module.common.api.mapper.FailureAuditMapper;
import com.yeejoin.amos.boot.module.common.api.service.IFailureAuditService;

/**
 * 服务实现类
 *
 * @author system_generator
 * @date 2021-08-04
 */
@Service
public class FailureAuditServiceImpl extends BaseService<FailureAuditDto, FailureAudit, FailureAuditMapper>
		implements IFailureAuditService {
	@Autowired
	FailureDetailsServiceImpl failureDetailsService;
	
//	@Autowired
//	RemoteWorkFlowService remoteWorkFlowService;

	/**
	 * 分页查询
	 */
	public Page<FailureAuditDto> queryForFailureAuditPage(Page<FailureAuditDto> page) {
		return this.queryForPage(page, null, false);
	}

	/**
	 * 列表查询 示例
	 */
	public List<FailureAuditDto> queryForFailureAuditList() {
		return this.queryForList("", false);
	}

	/**
	 * 发起审核
	 */
	public FailureAuditDto savemodel(FailureAuditDto model) {

		// remoteWorkFlowService.currentTask();

		this.createWithModel(model);
		Integer auditResult = model.getAuditResult();
		if (auditResult.equals(AuditResultEnum.AGREE.getCode())) {
			updateStatus(model, FailureStatuEnum.WAITING_MAINTAIN.getCode());
		} else if (auditResult.equals(AuditResultEnum.REFUSE.getCode())) {
			updateStatus(model, FailureStatuEnum.REFUSE.getCode());
		} else if (auditResult.equals(AuditResultEnum.SEND_BACK.getCode())) {
			updateStatus(model, FailureStatuEnum.WAITING_SUBMIT.getCode());
		}
		return model;
	}

	/**
	 * 修改故障保修单任务状态
	 */
	FailureDetailsDto updateStatus(FailureAuditDto model, Integer status) {
		FailureDetailsDto failureDetailsDto = failureDetailsService.queryBySeq(model.getFaultId());
		failureDetailsDto.setCurrentStatus(status);
		failureDetailsDto.setSequenceNbr(model.getFaultId());
		return failureDetailsService.updateWithModel(failureDetailsDto);

	}
	 public FailureAudit findByFaultId(Long faultId) {
		 LambdaQueryWrapper<FailureAudit> wrapper = new LambdaQueryWrapper<FailureAudit>();
		 wrapper.eq(FailureAudit::getIsDelete, false);
		 wrapper.eq(FailureAudit::getFaultId, faultId);
		 wrapper.orderByAsc(FailureAudit::getAuditTime);
		 wrapper.last("LIMIT 1");
		 return this.baseMapper.selectOne(wrapper);
		}
	
}