package com.yeejoin.amos.boot.module.tzs.biz.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.SystemClock;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.Maps;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.biz.common.utils.DateUtils;
import com.yeejoin.amos.boot.biz.common.utils.NameUtils;
import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import com.yeejoin.amos.boot.module.tzs.api.dto.AlertCallInfoDto;
import com.yeejoin.amos.boot.module.tzs.api.dto.AlertCalledDto;
import com.yeejoin.amos.boot.module.tzs.api.dto.AlertCalledObjsDto;
import com.yeejoin.amos.boot.module.tzs.api.dto.ESAlertCalledDto;
import com.yeejoin.amos.boot.module.tzs.api.dto.ESAlertCalledRequestDto;
import com.yeejoin.amos.boot.module.tzs.api.entity.AlertCalled;
import com.yeejoin.amos.boot.module.tzs.api.entity.AlertFormValue;
import com.yeejoin.amos.boot.module.tzs.api.entity.DispatchPaper;
import com.yeejoin.amos.boot.module.tzs.api.vo.AlarmStatisticsVo;
import com.yeejoin.amos.boot.module.tzs.api.vo.AlertCalledVo;
import com.yeejoin.amos.boot.module.tzs.biz.service.impl.AlertCalledServiceImpl;
import com.yeejoin.amos.boot.module.tzs.biz.service.impl.AlertFormValueServiceImpl;
import com.yeejoin.amos.boot.module.tzs.biz.service.impl.DispatchPaperServiceImpl;
import com.yeejoin.amos.boot.module.tzs.biz.service.impl.ESAlertCalledService;
import com.yeejoin.amos.boot.module.tzs.biz.utils.AlertBeanDtoVoUtils;
import com.yeejoin.amos.boot.module.tzs.biz.utils.BeanDtoVoUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.lang.reflect.Field;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;

/**
 * 警情接警填报记录
 *
 * @author litw
 * @date 2021-08-03
 */
@RestController
@Api(tags = "警情接警填报记录Api")
@RequestMapping(value = "/tzs/alert-called")
public class AlertCalledController extends BaseController {

	@Autowired
	RedisUtils redisUtils;
	@Autowired
	AlertCalledServiceImpl iAlertCalledService;
	@Autowired
	private ESAlertCalledService eSAlertCalledService;
	@Autowired
	DispatchPaperServiceImpl dispatchPaperServiceImpl;
	@Autowired
	AlertFormValueServiceImpl iAlertFormValueService;
    /**
     * 新增警情接警填报记录
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增警情接警填报记录", notes = "新增警情接警填报记录")
	public ResponseModel<AlertCalledDto> save(@RequestBody AlertCalledObjsDto alertCalledObjsDto) {
		if (ValidationUtil.isEmpty(alertCalledObjsDto)
				|| ValidationUtil.isEmpty(alertCalledObjsDto.getAlertCalledDto())){
			throw new BadRequest("参数校验失败.");
		}
		ReginParams reginParams =
				JSONObject.parseObject(null != redisUtils.get(buildKey(getToken())) ?
						redisUtils.get(buildKey(getToken())).toString() : null, ReginParams.class);
		//获取当前登录人公司
//		Integer code= reginParams.getCompany().getCompanyOrgCode();
//		AlertCalled alertCalled =  alertCalledObjsDto.getAlertCalled();
//		alertCalled.setOrgCode(String.valueOf(code));
//		alertCalledObjsDto.setAlertCalled(alertCalled);

		alertCalledObjsDto =iAlertCalledService.createAlertCalled(alertCalledObjsDto);
		return ResponseHelper.buildResponse(alertCalledObjsDto.getAlertCalledDto());
	}


	/**
	 *
	 * <pre>
	 * 相似警情分页查询
	 * </pre>
	 *
	 * @param
	 * @param current
	 * @param size
	 * @return
	 * @throws Exception
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@ApiOperation(value = "相似警情分页查询")
	@PostMapping(value = "/page/similar")
	public ResponseModel<Page<ESAlertCalledDto>> pageBySimilar(
			@RequestBody ESAlertCalledRequestDto alertCalledVo,
			@RequestParam(value = "current") int current,
			@RequestParam(value = "size") int size) throws Exception {

		Page<ESAlertCalledDto> esAlertCalledDtoPage = eSAlertCalledService.queryByKeys(alertCalledVo, current, size);
		esAlertCalledDtoPage.getRecords().stream().forEach(e->{
			getResponseLevel(alertCalledVo.getSequenceNbr(),null,e);
		});
		return ResponseHelper.buildResponse(esAlertCalledDtoPage);
	}



    /**
     * 根据id查询
     *
	 * @param id  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{id}")
	@ApiOperation(httpMethod = "GET",value = "根据id查询单个警情接警填报记录",  notes = "根据id查询单个警情接警填报记录")
	public ResponseModel<Object> selectOne(@PathVariable Long id) {
		return ResponseHelper.buildResponse(iAlertCalledService.selectAlertCalledById(id));
	}

	/**
	 * 生成工单编号报警人及报警时间
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/getWorkOderNumber")
	@ApiOperation(httpMethod = "GET",value = "生成工单编号报警人及报警时间",  notes = "生成工单编号报警人及报警时间")
	public ResponseModel<AlertCallInfoDto> selectOne() throws ParseException {
		String workOrderNumber = nextId();
        AlertCallInfoDto alertCallInfoDto = new AlertCallInfoDto();
        alertCallInfoDto.setCallTime(DateUtils.stampToDate(System.currentTimeMillis(),"yyyy-MM-dd HH:mm:ss "));
        alertCallInfoDto.setWorkOrderNumber(workOrderNumber);
        alertCallInfoDto.setRecUserId(getUserInfo().getUserId());
        alertCallInfoDto.setRecUserName(getUserInfo().getUserName());
		return ResponseHelper.buildResponse(alertCallInfoDto);
	}


	/**
	 * 获取下一个 工单编号
	 *
	 * @return 下一个 工单编号
	 */
	public synchronized String nextId() throws ParseException {

		String number =  DateUtils.stampToDate(SystemClock.now(),"yyyy-MM-dd HH:mm:ss SSS");
		String newNumber =   number.replace("-","").replace(" ","").replace(":","");
		ReginParams reginParams =
				JSONObject.parseObject(null != redisUtils.get(buildKey(getToken())) ?
						redisUtils.get(buildKey(getToken())).toString() : null, ReginParams.class);
//		Map<String, Object> map =    iAlertCalledService.getAlertInfoList(DateUtils.dateFormat(new Date(),"")+" 00:00:00",
//				DateUtils.dateFormat(new Date(),"")+" 23:59:59",reginParams.getCompany().getOrgCode(),
//				reginParams.getUserModel().getUserId());
				Map<String, Object> map =    iAlertCalledService.getAlertInfoList(DateUtils.dateFormat(new Date(),"")+" 00:00:00",
				DateUtils.dateFormat(new Date(),"")+" 23:59:59",null,
				null);
		StringBuilder stringBuilder = new StringBuilder();
		stringBuilder.append(newNumber);
		String workOrderNumber = stringBuilder.append(map.get("calledCount") == null  ? "1" : String.valueOf(Integer.parseInt(map.get("calledCount").toString()) + 1)).toString() ;
		return workOrderNumber;
	}

	/**
	 * 警情统计
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/alertStatistics")
	@ApiOperation(httpMethod = "GET",value = "警情统计",  notes = "警情统计")
	public ResponseModel<AlarmStatisticsVo> alertStatistics() throws ParseException {
		ReginParams reginParams =
				JSONObject.parseObject(null != redisUtils.get(buildKey(getToken())) ?
						redisUtils.get(buildKey(getToken())).toString() : null, ReginParams.class);
		//我的待办数量
		QueryWrapper<AlertCalled> todoNumQueryWrapper = new QueryWrapper<>();
		//全部待办数量
		QueryWrapper<AlertCalled> allNumQueryWrapper = new QueryWrapper<>();

		AlarmStatisticsVo alarmStatisticsVo = new AlarmStatisticsVo();
		todoNumQueryWrapper.eq("alert_status",false);
        allNumQueryWrapper.eq("alert_status",false);
		if(null != reginParams) {
			todoNumQueryWrapper.eq("rec_user_id",reginParams.getUserModel().getUserId());
			todoNumQueryWrapper.or(true);
			todoNumQueryWrapper.eq("org_code",reginParams.getCompany().getOrgCode());

            alarmStatisticsVo.setTodoNum(iAlertCalledService.list(todoNumQueryWrapper).size());
            alarmStatisticsVo.setAllNum(iAlertCalledService.list(allNumQueryWrapper).size());

            Map<String, Object> map =    iAlertCalledService.getAlertInfoList(DateUtils.dateFormat(new Date(),"")+" 00:00:00",
                    DateUtils.dateFormat(new Date(),"")+" 23:59:59",reginParams.getCompany().getOrgCode(),
                    reginParams.getUserModel().getUserId());
            // 当天接警
            alarmStatisticsVo.setTodayAlarmNum(map.get("calledCount") == null  ? 0 : Integer.valueOf(map.get("calledCount").toString()))   ;
            //当天提交
            alarmStatisticsVo.setTodayAlarmNum(map.get("majorAlertCount") == null  ? 0 : Integer.valueOf(map.get("majorAlertCount").toString()))   ;
            //投诉咨询数量
            alarmStatisticsVo.setSuggestions(map.get("suggestionsCount") == null  ? 0 : Integer.valueOf(map.get("suggestionsCount").toString()))   ;
            //故障维修数量
            alarmStatisticsVo.setSuggestions(map.get("faultRescueCount") == null  ? 0 : Integer.valueOf(map.get("faultRescueCount").toString()))   ;
            //困人救援数量
            alarmStatisticsVo.setSuggestions(map.get("sleepyIncidentCount") == null  ? 0 : Integer.valueOf(map.get("sleepyIncidentCount").toString()))   ;

            Map<String,Integer> recordMap = Maps.newHashMap();
            // 近七天办理数量
            for(int i = 1 ; i < 8; i++) {
                Map<String, Object> nearlySevenDaysMap   =    iAlertCalledService.getAlertInfoList(
                        DateUtils.dateFormat(DateUtils.dateAddDays(new Date(), -i),"")+" 00:00:00",
                        DateUtils.dateFormat(DateUtils.dateAddDays(new Date(), -i),"")+" 23:59:59",reginParams.getCompany().getOrgCode(),
                        reginParams.getUserModel().getUserId());
                recordMap.put(DateUtils.dateFormat(DateUtils.dateAddDays(new Date(), -i),""),nearlySevenDaysMap.get("calledCount") == null  ? 0 : Integer.valueOf(nearlySevenDaysMap.get("calledCount").toString()));
            }
            alarmStatisticsVo.setNearlySevenDaysNum(recordMap);
		}
		return ResponseHelper.buildResponse(alarmStatisticsVo);
	}

	/**
     * 列表分页查询
     *
     * @param pageNum 当前页
     * @param pageSize 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/list")
	@ApiOperation(httpMethod = "GET",value = "警情接警填报记录分页查询",  notes = "警情接警填报记录分页查询")
	public ResponseModel<IPage<AlertCalledVo>> queryForPage(String pageNum, String pageSize,String sort, AlertCalledDto alertCalledDto)  {
		AlertCalled alertCalled = BeanDtoVoUtils.convert(alertCalledDto,AlertCalled.class);
		Page<AlertCalled> pageBean;
		IPage<AlertCalled> page;
		QueryWrapper<AlertCalled> alertCalledQueryWrapper = new QueryWrapper<>();

		setQueryWrapper(alertCalledQueryWrapper, alertCalled,sort);

		if (StringUtils.isBlank(pageNum) || StringUtils.isBlank(pageSize)) {
			pageBean = new Page<>(0, Long.MAX_VALUE);
		} else {
			pageBean = new Page<>(Integer.parseInt(pageNum), Integer.parseInt(pageSize));
		}
		page = iAlertCalledService.page(pageBean, alertCalledQueryWrapper);
	    IPage<AlertCalledVo>  calledVoIPage =	AlertBeanDtoVoUtils.alertCalledIPageVo(page);
	    calledVoIPage.getRecords().stream().forEach(e->e.setAlertAddress(e.getCity()+e.getDistrict()));
		calledVoIPage.getRecords().stream().forEach(e->{
			getResponseLevel(alertCalled.getSequenceNbr(),e,null);
		});
		return ResponseHelper.buildResponse(calledVoIPage);
	}

	private QueryWrapper<AlertCalled> setQueryWrapper(QueryWrapper<AlertCalled> queryWrapper, AlertCalled alertCalled,String sort){
		Class<? extends AlertCalled> aClass = alertCalled.getClass();
		queryWrapper.eq("is_delete", 0);

		if(sort!=null) {
//			String[] date=  sort.split(",");
//			if(date[1].equals("ascend")) {
//				queryWrapper.orderByAsc(RedisKey.humpToLine(date[0]));
//			}else {
//				queryWrapper.orderByDesc(RedisKey.humpToLine(date[0]));
//			}
		}else {
			queryWrapper.orderByDesc("call_time");
		}

		if (alertCalled.getCallTimeStart() != null && alertCalled.getCallTimeEnd() != null) {
			queryWrapper.between("call_time", alertCalled.getCallTimeStart(), alertCalled.getCallTimeEnd());
		}
		if (alertCalled.getIsFatherAlert()) { // 0：接警；1：处警
			queryWrapper.isNull("father_alert");
		}

		Stream<Field> fieldStream = Arrays.stream(aClass.getDeclaredFields()).filter(field -> {
			String name = NameUtils.camel2Underline(field.getName());
			return !("IS_FATHER_ALERT".equals(name));
		});
		fieldStream.forEach(field -> {
			try {
				field.setAccessible(true);
				Object o = field.get(alertCalled);
				if (o != null && !"serialVersionUID".equals(field.getName())) {
					Class<?> type = field.getType();
					String name = NameUtils.camel2Underline(field.getName());
					if (type.equals(Integer.class)) {
						Integer fileValue = (Integer) field.get(alertCalled);
						queryWrapper.eq(name, fileValue);
					} else if (type.equals(String.class)) {
						String fileValue = (String) field.get(alertCalled);
						queryWrapper.eq(name, fileValue);
					} else if (type.equals(Boolean.class)) {
						Boolean fileValue = (Boolean) field.get(alertCalled);
						queryWrapper.eq(name, fileValue);
					}else if (type.equals(Long.class) || "long".equals(type.toString())) {
						Long fileValue = (Long) field.get(alertCalled);
						queryWrapper.eq(name, fileValue);
					}
				}
			} catch (Exception e) {
				e.printStackTrace();
				throw new RuntimeException("系统异常");
			}
		});
		return queryWrapper;
	}

	void getResponseLevel(Long alertId,AlertCalledVo alertCalledVo,ESAlertCalledDto esAlertCalledDto) {
		QueryWrapper<DispatchPaper> dispatchPaperQueryWrapper = new QueryWrapper<>();
		dispatchPaperQueryWrapper.eq("alert_id",alertId);
		DispatchPaper dispatchPaper = dispatchPaperServiceImpl.getOne(dispatchPaperQueryWrapper);
		if(null != dispatchPaper) {
			QueryWrapper<AlertFormValue> queryWrapper = new QueryWrapper<>();
			queryWrapper.eq("alert_called_id", dispatchPaper.getSendUserId()).eq("alert_type_code",dispatchPaper.getAlertType());
			// 派遣单动态表单数据
			List<AlertFormValue> list = iAlertFormValueService.list(queryWrapper);
			// map 存取数据
			Map<String,String> dynamicParms = new HashMap<String,String>();
			list.stream().forEach(paperFormValue -> {
				dynamicParms.put("field_code","field_value");
			});
			String responseLevel = dynamicParms.get("response_level");
			if(null != alertCalledVo) {
				alertCalledVo.setResponseLevel(responseLevel);
			} else {
				esAlertCalledDto.setResponseLevel(responseLevel);
			}
		}
	}
}
