package com.yeejoin.amos.boot.module.tzs.biz.controller;

import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import com.yeejoin.amos.boot.module.tzs.api.entity.RescueStation;
import com.yeejoin.amos.boot.module.tzs.biz.utils.BeanDtoVoUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;

import java.util.Date;
import java.util.List;
import com.yeejoin.amos.boot.module.tzs.biz.service.impl.RescueProcessServiceImpl;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.tzs.api.dto.RescueProcessDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 救援过程表
 *
 * @author system_generator
 * @date 2021-08-03
 */
@RestController
@Api(tags = "救援过程表Api")
@RequestMapping(value = "/tzs/rescue-process")
public class RescueProcessController extends BaseController {

    @Autowired
    RescueProcessServiceImpl rescueProcessServiceImpl;


	@Autowired
	RedisUtils redisUtils;

	/**
	 * 根据警情id 更新救援信息表
	 * @param model
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/updateByAlertId")
	@ApiOperation(httpMethod = "PUT", value = "根据警情id 更新救援信息表", notes = "根据警情id 更新救援信息表")
	public ResponseModel<Boolean> save(@RequestBody RescueProcessDto model) {
		ReginParams reginParams =
				JSONObject.parseObject(null != redisUtils.get(buildKey(getToken())) ?
						redisUtils.get(buildKey(getToken())).toString() : null, ReginParams.class);
		boolean update = rescueProcessServiceImpl.updateByAlertId(model,reginParams.getUserModel());
		return ResponseHelper.buildResponse(update);
	}


	/**
	 * 根据警情id 获取救援过程表
	 * @param alertId
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/alert/{alertId}")
	@ApiOperation(httpMethod = "GET",value = "根据警情id 获取救援过程表",  notes = "根据警情id 获取救援过程表")
	public ResponseModel<RescueProcessDto> selectOne(@PathVariable Long alertId) {
	    return ResponseHelper.buildResponse(rescueProcessServiceImpl.getProcessByAlertId(alertId));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "救援过程表分页查询",  notes = "救援过程表分页查询")
	public ResponseModel<Page<RescueProcessDto>> queryForPage(@RequestParam(value = "current") int current,@RequestParam
                    (value = "size") int size) {
	    Page<RescueProcessDto> page = new Page<RescueProcessDto>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(rescueProcessServiceImpl.queryForRescueProcessPage(page));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "救援过程表列表全部数据查询",   notes = "救援过程表列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<RescueProcessDto>> selectForList() {
	    return ResponseHelper.buildResponse(rescueProcessServiceImpl.queryForRescueProcessList());
	}
}
