package com.yeejoin.amos.boot.module.jyjc.biz.message.open;

import com.yeejoin.amos.boot.module.jg.api.enums.WorkFlowStatusEnum;
import com.yeejoin.amos.boot.module.jyjc.biz.feign.MessageFeignClient;
import com.yeejoin.amos.feign.systemctl.model.MessageModel;
import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import java.util.Collections;

/**
 * 系统对接通过-消息处理器
 */
@Component
@RequiredArgsConstructor
public class OpenAppDockPassMsgHandler implements IOpenApplicationMsgHandler {

    @Value("${open.app.msg.detail.path:/hyspm.html?appId=1742358052905971713&id=1954801593064910850&lfrom=studio}")
    private String msgDetailPath;

    private final MessageFeignClient messageFeignClient;

    @Override
    public String supportState() {
        return WorkFlowStatusEnum.OPENING_APPLICATION_REEXAMINE.getPass();
    }

    @Override
    public void handle(String userId, String relationId, String companyType) {
        this.send(userId, relationId + "2", companyType);
    }

    private void send(String userId, String relationId, String companyType) {
        MessageModel messageModel = new MessageModel();
        messageModel.setRecivers(Collections.singletonList(userId));
        messageModel.setMsgTypeLabel("检验检验业务开通");
        messageModel.setMsgType("openApp");
        messageModel.setTitle("签署承诺书");
        messageModel.setBody("系统对接已完成，请尽快按照消息详情提示进行签署承诺书！");
        messageModel.setRelationId(relationId);
        messageModel.setTerminal("WEB");
        messageModel.setRoutePath(msgDetailPath + "&relationId=" + relationId);
        messageModel.setCompanyType(companyType);
        messageModel.setIsRead(false);
        messageModel.setIsSendWeb(true);
        messageFeignClient.create(messageModel);
    }
}
