package com.yeejoin.amos.boot.module.ymt.api.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.entity.DataDictionary;
import com.yeejoin.amos.boot.module.ymt.api.dto.EquipExportDto;
import com.yeejoin.amos.boot.module.ymt.api.dto.EquipmentCategoryDto;
import com.yeejoin.amos.boot.module.ymt.api.dto.UseUnitCreditCodeCategoryDto;
import com.yeejoin.amos.boot.module.ymt.api.entity.EquipmentCategory;
import com.yeejoin.amos.boot.module.ymt.api.entity.SupervisoryCodeInfo;
import com.yeejoin.amos.boot.module.ymt.api.vo.EquipExportVo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;
import java.util.Map;

/**
 * 装备分类 Mapper 接口
 *
 * @author system_generator
 * @date 2021-10-20
 */
@Mapper
public interface EquipmentCategoryMapper extends BaseMapper<EquipmentCategory> {

    @Select("SELECT * FROM tz_equipment_category WHERE code NOT LIKE '7%' ORDER BY parent_id")
    List<EquipmentCategoryDto> selectClassifyNoStart7();

    List<EquipmentCategoryDto> equipmentPipeType3ByParentCode(@Param("parentCode") String parentCode);
    List<EquipmentCategoryDto> selectClassifyNoStart7ByParentCode(@Param("parentCode") String parentCode);

    @Select("SELECT * FROM tz_equipment_category WHERE code NOT LIKE '7%' AND code NOT LIKE '8%' ORDER BY parent_id")
    List<EquipmentCategoryDto> selectClassifyNoStart7And8();


    List<EquipmentCategoryDto> selectClassifyNoStart7And8ByParentCode(@Param("parentCode") String parentCode);

    @Select("select * from tz_equipment_category where code in('1000','2000','3000','4000','5000','6000','8000','9000')")
    List<EquipmentCategoryDto> selectClassify();

    List<Map<String, Object>> getCategoryCount(@Param("companyCode") String companyCode);


    Map<String, Object> getAdministrativeDivision(@Param("division") String division, @Param("county") String county);

    DataDictionary getOneDictByTypeAndExtend(@Param("type") String type, @Param("regionCode") String regionCode);

    List<Map<String, Object>> getSrcee(@Param("tableName") String tableName,
                                       @Param("orgBranchName") String orgBranchName,
                                       @Param("equList") String equList,
                                       @Param("equCategory") String equCategory,
                                       @Param("usePlace") String usePlace,
                                       @Param("equState") String equState);


    Map<String, Object> getCategoryAndDefineByRecord(@Param("record") String record);

    List<Map<String, Object>> getAllUnit(@Param("unitCodes") List<String> unitCodes, @Param("orgBranchCodes") List<String> orgBranchCodes);

    List<Map<String, Object>> getCategoryData(String level, String orgCode, String companyCode);

    String getUnitCodeByRecord(String record);


    List<UseUnitCreditCodeCategoryDto> useUnitCreditCodeCategoryCount(@Param("unitCodes") List<String> unitCodes, @Param("orgBranchCodes") List<String> orgBranchCodes);


    List<EquipExportVo> getEquipExportData(@Param("dto") EquipExportDto dto);
    Page<EquipExportVo> exportImageZip (@Param("page")Page<EquipExportVo> page, @Param("dto") EquipExportDto dto);

    void updateIsNotEs(String supervisoryCode);

    Map<String, Object> selectTzsUseInfo(@Param("record")String record);

    Map<String, Object> selectTzsDesInfo(@Param("record")String record);

    Map<String, Object> selectTzsqzjJriInfo(@Param("record")String record, @Param("tableName")String tableName);

    List<Map<String, Object>> selectTzslbjJriInfo(@Param("record")String record);

    List<Map<String, Object>> selectTzsaqfjJriInfo(@Param("record")String record);

    Map<String, Object> selectTzsSupInfo(@Param("record")String record);

    List<Map<String, Object>> selectTzsMainInfo(@Param("record")String record);

    List<Map<String, Object>> selectTzsConInfo(@Param("record")String record);

    List<Map<String, Object>> selectTzsInsInfo(@Param("record")String record);

    List<String> selectWriteXiXian();

    void clearSupervisoryCodeAndXiXian();

    void updateSupervisoryCode(@Param("writeRecordList") List<String> writeRecordList);

    List<String> selectXiXian();

    void clearSupervisoryCode();

    void clearCode(@Param("recordList") List<String> recordList);

    List<Map<String, Object>> getEquCategory(@Param("recordList") List<String> recordList);


    List<String> selectXiXianNew();

    @Select("SELECT * FROM tz_equipment_category WHERE parent_id = #{parentId}")
    List<EquipmentCategoryDto> getEquDefineByParentId(String parentId);

    @Select("SELECT\n" +
            "\tri.record,\n" +
            "\tri.EQU_LIST equList,\n" +
            "\tui.\"CITY\" city,\n" +
            "\tui.\"COUNTY\" county,\n" +
            "\tui.\"IS_NOT_XIXIAN\" isNotXixian,\n" +
            "\toi.code96333,\n" +
            "\toi.SUPERVISORY_CODE supervisoryCode \n" +
            "FROM\n" +
            "\tidx_biz_jg_register_info ri\n" +
            "\tLEFT JOIN idx_biz_jg_use_info ui ON ui.record = ri.record\n" +
            "\tLEFT JOIN idx_biz_jg_other_info oi ON oi.record = ri.record \n" +
            "WHERE\n" +
            "\tri.equ_list = '3000' \n" +
            "\tAND ui.IS_INTO_MANAGEMENT = 1 \n" +
            "\tAND oi.SUPERVISORY_CODE IS NOT NULL \n" +
            "\tAND ( oi.code96333 IS NULL OR oi.code96333 = '' ) \n" +
            "\tAND ( ui.city != '610100' OR ui.\"IS_NOT_XIXIAN\" = 1 )\n")
    List<Map<String, String>> selectExceptionCode96333();

    @Select("select *  from biz_jg_supervisory_code  where supervisory_code = #{supervisoryCode}  ORDER BY supervisory_code")
    SupervisoryCodeInfo searchSupervisoryBySupervisoryCode(@Param("supervisoryCode") String supervisoryCode);

}

