package com.yeejoin.amos.boot.module.jcs.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * 警情报送记录
 *
 * @author tb
 * @date 2021-06-17
 */
@Data
@Accessors(chain = true)
@ApiModel(value = "AlertSubmittedSMSDto", description = "融合调度记录短信详情")
public class AlertSubmittedSMSDto {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "短信记录id")
    private Long sequenceNbr;

    @ApiModelProperty(value = "电话时间")
    private Date submissionTime;

    @ApiModelProperty(value = "联系电话")
    private String userPhone;

    @ApiModelProperty(value = "协调单位")
    private String companyName;

    @ApiModelProperty(value = "联系人")
    private String userName;

    @ApiModelProperty(value = "值班员")
    private String sender;

    @ApiModelProperty(value = "报送内容")
    private String submissionContent;

    @ApiModelProperty(value = "报送内容-自定义")
    private String submissionContentValue;

    @ApiModelProperty(value = "报送模板")
    private String submissionTemplate;
}
