package com.yeejoin.amos.boot.module.jg.api.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;
import java.util.List;

/**
 * @author system_generator
 * @date 2023-12-12
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "JgMaintenanceContractDto", description = "")
public class JgMaintenanceContractDto extends BaseDto {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "维保备案编号")
    private String applyNo;


    @ApiModelProperty(value = "办理状态")
    private String applyStatus;

    @ApiModelProperty(value = "流程实例id")
    private String instanceId;

    @ApiModelProperty(value = "维保备案日期")
    private Date applyDate;

    @ApiModelProperty(value = "设备类型")
    private String equType;

    @ApiModelProperty(value = "使用单位统一信用代码")
    private String useUnitCode;

    @ApiModelProperty(value = "使用单位")
    private String useUnitName;

    @ApiModelProperty(value = "接收机构统一信用代码")
    private String receiveOrgCode;

    @ApiModelProperty(value = "接收机构")
    private String receiveOrgName;

    @ApiModelProperty(value = "维保单位统一信用代码")
    private String maintenanceUnitCode;

    @ApiModelProperty(value = "维保单位名称")
    private String maintenanceUnitName;

    @ApiModelProperty(value = "维保合同开始日期")
    private Date informStart;

    @ApiModelProperty(value = "维保合同结束日期")
    private Date informEnd;

    @ApiModelProperty(value = "安全管理员id")
    private String maintenanceManagerId;

    @ApiModelProperty(value = "安全管理员姓名")
    private String maintenanceManagerName;

    @ApiModelProperty(value = "安全管理员姓名联系方式")
    private String maintenanceManagerPhone;


    @ApiModelProperty(value = "维保负责人一id")
    private String maintenanceManagerOneId;

    @ApiModelProperty(value = "维保负责人一姓名")
    private String maintenanceManagerOneName;

    @ApiModelProperty(value = "维保负责人一联系方式")
    private String maintenanceManagerOnePhone;


    @ApiModelProperty(value = "维保负责人二id")
    private String maintenanceManagerTwoId;

    @ApiModelProperty(value = "维保负责人二姓名")
    private String maintenanceManagerTwoName;

    @ApiModelProperty(value = "维保负责人二联系方式")
    private String maintenanceManagerTwoPhone;


    @ApiModelProperty(value = "紧急救援电话")
    private String emergencyCall;

    @ApiModelProperty(value = "24小时维保电话")
    private String maintenance24Tel;

    @ApiModelProperty(value = "备注")
    private String remark;

    @ApiModelProperty(value = "录入单位ID")
    private String inputUnitNo;

    @ApiModelProperty(value = "维保合同照片")
    private String maintenanceContract;

    @ApiModelProperty(value = "维保周期")
    private Integer maintenanceCycle;

    @ApiModelProperty(value = "大修周期")
    private Integer overhaulCycle;

    @ApiModelProperty(value = "设备数量")
    private Integer equNum;


    @ApiModelProperty(value = "创建人ID")
    private String createUserId;

    @ApiModelProperty(value = "创建时间")
    private Date createDate;

    @TableField("instance_status")
    private String instanceStatus;

    @TableField("next_execute_ids")
    private String nextExecuteIds;

    @TableField("promoter")
    private String promoter;

    @TableField("status")
    private String status;

    private List<String> roleIds;

    /**
     *工作流下一节点任务id
     */
    @TableField(value = "next_task_id")
    private String nextTaskId;

    /**
     * 下一节点可执行人
     */
    private String nextExecuteUserIds;
}
