package com.yeejoin.amos.boot.module.jg.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import com.yeejoin.amos.boot.module.jg.api.common.BizCustomDateSerializer;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import java.util.Date;

/**
 * 单位变更登记
 *
 * @author system_generator
 * @date 2023-12-22
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("tzs_jg_change_registration_unit")
public class JgChangeRegistrationUnit extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 变更类型（0转出，1转入）
     */
	@TableField("change_type")
    private String changeType;

    /**
     * 申请编号
     */
	@TableField("apply_no")
    private String applyNo;

    /**
     * 申请日期
     */
	@TableField("apply_date")
    @JsonFormat(pattern = "yyyy-MM-dd")
    @JsonSerialize(using = BizCustomDateSerializer.class)
    private Date applyDate;

    /**
     * 办理状态
     */
	@TableField("audit_status")
    private String auditStatus;

    /**
     * 登记机构
     */
	@TableField("receive_org_name")
    private String receiveOrgName;

    /**
     * 登记机构代码
     */
	@TableField("receive_org_code")
    private String receiveOrgCode;

    /**
     * 登记机构公司代码
     */
	@TableField("receive_company_code")
    private String receiveCompanyCode;

    /**
     * 终审通过时间
     */
	@TableField("audit_pass_date")
    @JsonFormat(pattern = "yyyy-MM-dd")
    @JsonSerialize(using = BizCustomDateSerializer.class)
    private Date auditPassDate;

    /**
     * 备注
     */
	@TableField("remark")
    private String remark;

    /**
     * 创建人ID
     */
	@TableField("create_user_id")
    private String createUserId;

    /**
     * 创建时间
     */
	@TableField("create_date")
    private Date createDate;

    /**
     * 创建人
     */
	@TableField("create_user_name")
    private String createUserName;

    /**
     * 原使用单位统一信用代码
     */
	@TableField("use_unit_credit_code")
    private String useUnitCreditCode;

    /**
     * 原使用单位名称
     */
	@TableField("use_unit_name")
    private String useUnitName;

    /**
     * 新使用单位统一信用代码
     */
	@TableField("new_use_unit_credit_code")
    private String newUseUnitCreditCode;

    /**
     * 新使用单位名称
     */
	@TableField("new_use_unit_name")
    private String newUseUnitName;

    /**
     * 变更证明（买卖合同或其他变更使用单位证明）
     */
	@TableField("change_certificate")
    private String changeCertificate;

    /**
     * 流程实例id
     */
	@TableField("instance_id")
    private String instanceId;

    /**
     * 流程执行顺序标识
     */
	@TableField("execute_sequence")
    private String executeSequence;

    /**
     * 下一执行节点ids
     */
	@TableField("next_executor_ids")
    private String nextExecutorIds;

    /**
     * 任务发起人id
     */
	@TableField("promoter")
    private String promoter;

    /**
     * 使用登记证书附件（转入审核通过后生成）
     */
	@TableField("use_registration_certificate")
    private String useRegistrationCertificate;

    /**
     * 流程已执行记录角色id
     */
	@TableField("instance_status")
    private String instanceStatus;

    /**
     * 当前节点流程名称
     */
	@TableField("status")
    private String status;

    /**
     * 流程建议
     */
    @TableField(exist = false)
    private String processAdvice;

    /**
     * 设备类别
     */
    @TableField("equ_type")
    private String equType;

    /**
     * 设备名称
     */
    @TableField("product_name_b")
    private String productNameB;

    /**
     * 设备注册代码
     */
    @TableField("equ_code_b")
    private String equCodeB;

    /**
     * 设备内部编号
     */
    @TableField("use_inner_code")
    private String useInnerCode;

    /**
     * 设备使用登记注册编号
     */
    @TableField("use_regist_code")
    private String useRegistCode;

    /**
     * 设备地址
     */
    @TableField("equ_address")
    private String equAddress;

    @TableField(exist = false)
    private String supervisoryCode;
    /**
     *工作流下一节点任务id
     */
    @TableField(value = "next_task_id")
    private String nextTaskId;
}
