package com.yeejoin.amos.boot.module.jg.biz.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.bo.CompanyBo;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.utils.RedisKey;
import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import com.yeejoin.amos.boot.module.jg.api.dto.JgMaintenanceContractDto;
import com.yeejoin.amos.boot.module.jg.api.dto.TaskModelDto;
import com.yeejoin.amos.boot.module.jg.api.dto.WorkflowResultDto;
import com.yeejoin.amos.boot.module.jg.api.entity.JgMaintenanceContract;
import com.yeejoin.amos.boot.module.jg.api.entity.JgMaintenanceContractEq;
import com.yeejoin.amos.boot.module.jg.api.enums.BusinessTypeEnum;
import com.yeejoin.amos.boot.module.jg.api.enums.MaintenanceEnum;
import com.yeejoin.amos.boot.module.jg.api.enums.WorkFlowStatusEnum;
import com.yeejoin.amos.boot.module.jg.api.mapper.JgMaintenanceContractEqMapper;
import com.yeejoin.amos.boot.module.jg.api.mapper.JgMaintenanceContractMapper;
import com.yeejoin.amos.boot.module.jg.api.service.IJgMaintenanceContractService;
import com.yeejoin.amos.boot.module.jg.api.vo.JgMaintenanceContractVo;
import com.yeejoin.amos.boot.module.jg.biz.feign.TzsServiceFeignClient;
import com.yeejoin.amos.boot.module.jg.biz.service.ICmWorkflowService;
import com.yeejoin.amos.boot.module.ymt.api.enums.ApplicationFormTypeEnum;
import com.yeejoin.amos.boot.module.ymt.api.enums.FlowStatusEnum;
import com.yeejoin.amos.feign.systemctl.model.TaskV2Model;
import com.yeejoin.amos.feign.workflow.model.ActWorkflowBatchDTO;
import com.yeejoin.amos.feign.workflow.model.ActWorkflowStartDTO;
import com.yeejoin.amos.feign.workflow.model.ProcessTaskDTO;
import com.yeejoin.amos.feign.workflow.model.TaskResultDTO;
import org.elasticsearch.client.RestHighLevelClient;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 服务实现类
 *
 * @author system_generator
 * @date 2023-12-12
 */
@Service
public class JgMaintenanceContractServiceImpl extends BaseService<JgMaintenanceContractDto, JgMaintenanceContract, JgMaintenanceContractMapper> implements IJgMaintenanceContractService {

    public static final String SUBMIT_DATA = "0";
    public static final String SUBMIT_TYPE_FLOW = "1";
    public static final String WB_PROCESS_DEFINITION_KEY = "maintenanceFiling";

    @Autowired
    TzsServiceFeignClient tzsServiceFeignClient;
    @Autowired
    RestHighLevelClient restHighLevelClient;
    @Autowired
    private JgMaintenanceContractMapper maintenanceContractMapper;
    @Autowired
    private JgMaintenanceContractEqMapper maintenanceContractEqMapper;
    @Autowired
    private JgMaintenanceContractEqServiceImpl jgMaintenanceContractEqService;
    @Autowired
    RedisUtils redisUtils;
    @Autowired
    ICmWorkflowService workflowService;
    @Autowired
    CommonServiceImpl commonService;

    /**
     * 分页查询
     */
    public Page<JgMaintenanceContractVo> queryForPage(Page<JgMaintenanceContract> page, int phase,
                                                      Map<String, Object> map, ReginParams reginParams) {
        JgMaintenanceContractDto dto = new JgMaintenanceContractDto();
        if (map.containsKey("jgMaintenanceContractDto")) {
            dto = JSON.parseObject(JSON.toJSONString(map.get("jgMaintenanceContractDto")), JgMaintenanceContractDto.class);
        }
        Page<JgMaintenanceContractDto> contractList = new Page<>();
        Page<JgMaintenanceContractVo> result = new Page<>();
        CompanyBo company = reginParams.getCompany();
        if (MaintenanceEnum.SHIYONG.getCode().equals(phase)) {
            //使用单位用"使用单位统一信用代码"匹配数据
            dto.setUseUnitCode(company.getCompanyCode());
            dto.setRoleIds(null);
            contractList = maintenanceContractMapper.getContractList(page, dto);
        } else if (MaintenanceEnum.WEIBAO.getCode().equals(phase)) {
            //维保单位用"维保单位统一信用代码"匹配数据
            dto.setMaintenanceUnitCode(company.getCompanyCode());
            contractList = maintenanceContractMapper.getContractList(page, dto);
        } else if (MaintenanceEnum.JIANGUAN.getCode().equals(phase)) {
            //监管单位用"接收机构统一使用代码"匹配
            dto.setReceiveOrgCode(company.getCompanyCode());
            contractList = maintenanceContractMapper.getContractList(page, dto);
        }
        BeanUtils.copyProperties(contractList, result);
        return result;
    }

    /**
     * 根据sequenceNbr查询数据
     */
    public JgMaintenanceContractVo queryBySequenceNbr(Long sequenceNbr) {
        JgMaintenanceContractDto dto = maintenanceContractMapper.queryBySequenceNbr(sequenceNbr);
        JgMaintenanceContractVo vo = new JgMaintenanceContractVo();
        BeanUtils.copyProperties(dto, vo);
        vo.setMaintenanceContract(ObjectUtils.isEmpty(dto.getMaintenanceContract()) ? null : JSON.parseArray(dto.getMaintenanceContract()));
        List<Map<String, Object>> list = maintenanceContractMapper.selectEquipList(sequenceNbr);
        if (!ObjectUtils.isEmpty(list)) {
            vo.setEquipmentLists(list);
        }
        return vo;
    }

    /**
     * 根据sequenceNbr更新数据
     *
     * @param dto
     * @return
     */
    public Boolean updateBySequenceNbr(JgMaintenanceContractDto dto) {
        return maintenanceContractMapper.updateBySequenceNbr(dto);
    }

    public void flowExecute(Long id, String instanceId, String operate, String comment, Boolean update) {
        try {
            JgMaintenanceContract jgMaintenanceContract = this.getBaseMapper().selectById(id);
            String taskId = jgMaintenanceContract.getNextTaskId();
            //组装信息
            TaskResultDTO dto = new TaskResultDTO();
            dto.setResultCode("approvalStatus");
            dto.setTaskId(taskId);
            dto.setComment(comment);
            HashMap<String, Object> map = new HashMap<>();
            map.put("approvalStatus", operate);
            if (WorkFlowStatusEnum.MAIN_SUBMIT.getReject().equals(jgMaintenanceContract.getStatus()) || WorkFlowStatusEnum.MAIN_SUBMIT.getRollBack().equals(jgMaintenanceContract.getStatus())) {
                map.put("approvalStatus", "提交");
            }
            dto.setVariable(map);
            ProcessTaskDTO complete = workflowService.complete(taskId, dto);
            // 更新下一步执行人、创建待办
            updateExecuteIds(instanceId, id, operate, complete);
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    /**
     * 批量删除
     */
    @Transactional
    public Boolean deleteForBatch(Long[] ids) {
        List<Long> list = Arrays.asList(ids);
        list.forEach(x -> {
            QueryWrapper<JgMaintenanceContract> wrapper = new QueryWrapper<>();
            wrapper.eq("sequence_nbr", x);
            JgMaintenanceContract jgMaintenanceContract = maintenanceContractMapper.selectOne(wrapper);
            LambdaQueryWrapper<JgMaintenanceContractEq> queryWrapper = new LambdaQueryWrapper<JgMaintenanceContractEq>()
                    .eq(JgMaintenanceContractEq::getEquipTransferId, jgMaintenanceContract.getApplyNo())
                    .eq(JgMaintenanceContractEq::getIsDelete, false);
            List<Long> listSeq = jgMaintenanceContractEqService.list(queryWrapper).stream()
                    .map(JgMaintenanceContractEq::getSequenceNbr).collect(Collectors.toList());
            maintenanceContractEqMapper.deleteForBatch(listSeq);
        });
        maintenanceContractMapper.deleteForBatch(list);
        return true;
    }

    private void executeOneStep(JgMaintenanceContract contract, String taskName, String nextUserIds, String operate) {
        // 先更新之前的待办
        TaskV2Model taskV2Model = updateTaskModel(contract, operate);
        taskV2Model.setTaskDesc("");
        taskV2Model.setTaskContent(this.buildTaskContent(contract));
        taskV2Model.setTaskName(taskName);
        taskV2Model.setTaskCode(contract.getApplyNo());
        taskV2Model.setExecuteUserIds(nextUserIds);
        taskV2Model.setRelationId(contract.getInstanceId());
        FlowStatusEnum flowStatusEnum = this.getTaskStatus(operate);
        taskV2Model.setTaskStatus(flowStatusEnum.getCode());
        taskV2Model.setTaskStatusLabel(flowStatusEnum.getName());
        taskV2Model.setFlowStatus(this.getTaskStatusByName(contract.getStatus()));
        taskV2Model.setFlowStatusLabel(contract.getStatus());
        taskV2Model.setTaskType(BusinessTypeEnum.JG_MAINTENANCE_RECORD.getCode());
        taskV2Model.setStartUser(contract.getCreateUserName());
        taskV2Model.setTaskTypeLabel(BusinessTypeEnum.JG_MAINTENANCE_RECORD.getName());
        taskV2Model.setStartDate(contract.getCreateDate());
        taskV2Model.setStartUserId(contract.getCreateUserId());
        taskV2Model.setStartUserCompanyName(contract.getUseUnitName());
        taskV2Model.setExecuteUserIds(nextUserIds);
        TaskModelDto modelDto = new TaskModelDto();
        BeanUtil.copyProperties(taskV2Model, modelDto);
        modelDto.setNextExecuteUser(contract.getNextExecuteIds());
        modelDto.setModel(contract);
        // 再插入新代办、数据待定
        commonService.buildTaskModel(Collections.singletonList(modelDto));
    }


    /**
     * 维保合同撤回
     */
    @Transactional
    public void revocation(String instanceId) {
        // 执行流程
        JgMaintenanceContract contract = new JgMaintenanceContract();
        LambdaQueryWrapper<JgMaintenanceContract> lambda = new QueryWrapper<JgMaintenanceContract>().lambda();
        lambda.eq(JgMaintenanceContract::getInstanceId, instanceId);
        List<String> roleListNext = new ArrayList<>();
        List<String> roleListAll = new ArrayList<>();
        ProcessTaskDTO processTaskDTO = workflowService.rollBack(instanceId);
        String nextTaskId = processTaskDTO.getNextTask().get(0).getId();
        this.buildRoleList(Collections.singletonList(processTaskDTO), roleListNext, roleListAll);
        // 待调整
        String taskCode = processTaskDTO.getNextTask().get(0).getKey();
        if (!FlowStatusEnum.TO_BE_FINISHED.getName().equals(taskCode)) {
            contract.setStatus(WorkFlowStatusEnum.getMessage(taskCode).getRollBack());
        }
        contract.setPromoter(RequestContext.getExeUserId());
        contract.setNextExecuteIds(String.join(",", roleListNext));
        contract.setNextTaskId(nextTaskId);
        List<WorkflowResultDto> workflowResultDtos = commonService.buildWorkFlowInfo(Collections.singletonList(processTaskDTO));
        // 更新下一步可执行人
        String nextUserIds = workflowResultDtos.get(0).getNextExecutorUserIds();
        contract.setNextExecuteUserIds(nextUserIds);
        this.update(contract, lambda);
        // 删除待办
        JSONObject jsonObject = JSONObject.parseObject(JSONObject.toJSONString(contract));
        jsonObject.put("nextTaskId", contract.getNextTaskId());
        jsonObject.put("nextExecuteUser", contract.getNextExecuteIds());
        jsonObject.put("taskType", BusinessTypeEnum.JG_MAINTENANCE_RECORD.getCode());
        commonService.rollbackTask(instanceId, jsonObject);
    }

    /**
     * 新增维保合同
     */
    @Transactional(rollbackFor = Exception.class)
    public Boolean saveOrSubmit(String submit, Map<String, Object> map, ReginParams reginParams) {
        JgMaintenanceContractDto contractDto = JSON.parseObject(JSON.toJSONString(map), JgMaintenanceContractDto.class);
        List<Map<String, Object>> equipmentLists = (List<Map<String, Object>>) map.get("equipmentLists");
        CompanyBo company = reginParams.getCompany();
        contractDto.setCreateDate(new Date());
        contractDto.setPromoter(reginParams.getUserModel().getUserId());
        //获取维保备案编号
        ResponseModel<List<String>> listResponseModel = tzsServiceFeignClient.applicationFormCode(ApplicationFormTypeEnum.WBBA.getCode(), 1);
        if (!ObjectUtils.isEmpty(listResponseModel) && listResponseModel.getStatus() != HttpStatus.OK.value()) {
            log.error("告知单获取失败");
            return false;
        }
        String wbApplyNo = listResponseModel.getResult().get(0);
        contractDto.setApplyNo(wbApplyNo);
        contractDto.setUseUnitCode(company.getCompanyCode());
        contractDto.setUseUnitName(company.getCompanyName());
        //管理员信息
        if (!StringUtils.isEmpty(contractDto.getMaintenanceManagerId())) {
            String[] MaintenanceManager = contractDto.getMaintenanceManagerId().split("_");
            contractDto.setMaintenanceManagerId(MaintenanceManager[0]);
            contractDto.setMaintenanceManagerName(MaintenanceManager[1]);
        }
        //接收机构信息
        if (!StringUtils.isEmpty(contractDto.getReceiveOrgCode())) {
            String[] splitReceiveOrgCode = contractDto.getReceiveOrgCode().split("_");
            contractDto.setReceiveOrgCode(splitReceiveOrgCode[0]);
            contractDto.setReceiveOrgName(splitReceiveOrgCode[1]);
        }
        //维保单位信息
        if (!StringUtils.isEmpty(contractDto.getMaintenanceUnitCode())) {
            String[] splitMaintenanceUnitCode = contractDto.getMaintenanceUnitCode().split("_");
            contractDto.setMaintenanceUnitCode(splitMaintenanceUnitCode[0]);
            contractDto.setMaintenanceUnitName(splitMaintenanceUnitCode[1]);
        }
        contractDto.setStatus(FlowStatusEnum.TO_BE_SUBMITTED.getName());
        JgMaintenanceContract contract = new JgMaintenanceContract();
        boolean hasId = StringUtils.isEmpty(contractDto.getSequenceNbr());//没有id说明是新增
        BeanUtils.copyProperties(contractDto, contract);
        if (hasId) {
            contract.setCreateUserId(reginParams.getUserModel().getUserId());
            contract.setCreateUserName(reginParams.getUserModel().getRealName());
            contract.setStatus(SUBMIT_DATA.equals(submit) ? WorkFlowStatusEnum.MAIN_SUBMIT.getPass() : WorkFlowStatusEnum.MAIN_RECEIVE.getPass());
            this.save(contract);
        } else {
            //删除以前设备关联关系
            this.getBaseMapper().updateById(contract);
            LambdaQueryWrapper<JgMaintenanceContractEq> lambda = new QueryWrapper<JgMaintenanceContractEq>().lambda();
            lambda.eq(JgMaintenanceContractEq::getEquipTransferId, contract.getSequenceNbr());
            jgMaintenanceContractEqService.getBaseMapper().delete(lambda);
        }
        // 更新关联设备信息
        if (!CollectionUtils.isEmpty(equipmentLists)) {
            contract.setEquNum(equipmentLists.size());
            List<JgMaintenanceContractEq> equipList = new ArrayList<>();
            equipmentLists.forEach(x -> {
                JgMaintenanceContractEq equip = new JgMaintenanceContractEq();
                equip.setEquId(String.valueOf(x.get("SEQUENCE_NBR")));
                equip.setEquipTransferId(contract.getSequenceNbr().toString());
                equipList.add(equip);
            });
            // 保存关联设备信息
            jgMaintenanceContractEqService.saveBatch(equipList);
        }

        // 判断当前是否为提交
        if (SUBMIT_TYPE_FLOW.equals(submit)) {
            List<String> roleListNext = new ArrayList<>();
            List<String> roleListAll = new ArrayList<>();
            //新增提交
            if (StringUtils.isEmpty(contract.getInstanceId())) {
                //没有InstanceId需要发起流程
                try {
                    ActWorkflowBatchDTO actWorkflowBatchDTO = new ActWorkflowBatchDTO();
                    List<ActWorkflowStartDTO> list = new ArrayList<>();
                    ActWorkflowStartDTO dto = new ActWorkflowStartDTO();
                    dto.setProcessDefinitionKey(WB_PROCESS_DEFINITION_KEY);
                    dto.setBusinessKey(contract.getApplyNo());
                    dto.setCompleteFirstTask(true);
                    list.add(dto);
                    actWorkflowBatchDTO.setProcess(list);
                    List<ProcessTaskDTO> processTasks = workflowService.startBatch(actWorkflowBatchDTO);
                    String instanceId = processTasks.get(0).getProcessInstance().getId();
                    String nextTaskId = processTasks.get(0).getNextTask().get(0).getId();
                    String taskName = processTasks.get(0).getNextTask().get(0).getName();
                    this.buildRoleList(processTasks, roleListNext, roleListAll);
                    List<WorkflowResultDto> workflowResultDtos = commonService.buildWorkFlowInfo(processTasks);
                    String nextUserIds = workflowResultDtos.get(0).getNextExecutorUserIds();
                    contract.setInstanceStatus(String.join(",", roleListAll));
                    contract.setInstanceId(instanceId);
                    contract.setNextExecuteIds(String.join(",", roleListNext));
                    contract.setNextTaskId(nextTaskId);
                    contract.setNextExecuteUserIds(nextUserIds);
                    // 创建待办
                    JgMaintenanceContract bean = new JgMaintenanceContract();
                    BeanUtil.copyProperties(contract, bean);
                    createTaskModel(bean, taskName, "1", nextUserIds);
                } catch (Exception e) {
                    log.error("提交失败：{}", e);
                    throw new BadRequest("提交失败" + e.getMessage());
                }
            } else {
                // 有InstanceId，执行一步
                ProcessTaskDTO processTaskDTO = this.submit("0", contract.getNextTaskId());
                String nextTaskId = processTaskDTO.getNextTask().get(0).getId();
                String taskName = processTaskDTO.getNextTask().get(0).getName();
                this.buildRoleList(Collections.singletonList(processTaskDTO), roleListNext, roleListAll);
                List<WorkflowResultDto> workflowResultDtos = commonService.buildWorkFlowInfo(Collections.singletonList(processTaskDTO));
                String nextUserIds = workflowResultDtos.get(0).getNextExecutorUserIds();
                // 查询下节点任务
                if (!ObjectUtils.isEmpty(contract.getInstanceStatus())) {
                    contract.setInstanceStatus(contract.getInstanceStatus() + "," + String.join("", roleListNext));
                } else {
                    contract.setInstanceStatus(String.join(",", roleListAll));
                }
                contract.setPromoter(RequestContext.getExeUserId());
                contract.setNextExecuteIds(String.join(",", roleListNext));
                contract.setStatus(String.valueOf(WorkFlowStatusEnum.MAIN_RECEIVE.getPass()));
                contract.setNextTaskId(nextTaskId);
                contract.setNextExecuteUserIds(nextUserIds);
                executeOneStep(contract, taskName, nextUserIds, "0");
            }
        }
        updateById(contract);
        return true;
    }

    public ProcessTaskDTO submit(String op, String taskId) {
        //组装信息
        TaskResultDTO dto = new TaskResultDTO();
        dto.setResultCode("approvalStatus");
        dto.setTaskId(taskId);
        dto.setComment("提交流程");
        HashMap<String, Object> map = new HashMap<>();
        map.put("approvalStatus", op);
        dto.setVariable(map);
        return workflowService.complete(taskId, dto);
    }

    private void buildRoleList(List<ProcessTaskDTO> processTasks, List<String> roleListNext, List<String> roleListAll) {
        processTasks.forEach(p -> {
            p.getNextCandidateGroups().values().forEach(e -> {
                roleListNext.addAll(e);
                roleListAll.addAll(e);
            });
            roleListAll.addAll(p.getCandidateGroups());
        });
    }

    @Transactional
    public void updateExecuteIds(String instanceId, Long sequenceNbr, String operate, ProcessTaskDTO processTaskDTO) {
        List<String> roleListNext = new ArrayList<>();
        List<String> roleListAll = new ArrayList<>();
        String taskCode = FlowStatusEnum.TO_BE_FINISHED.getName();
        String taskName = "";
        String nextTaskId = "";
        JgMaintenanceContract contract = this.getBaseMapper().selectById(sequenceNbr);
        if (processTaskDTO != null && processTaskDTO.getNextTask() != null && processTaskDTO.getNextTask().size() > 0) {
            taskCode = processTaskDTO.getNextTask().get(0).getKey();
            taskName = processTaskDTO.getNextTask().get(0).getName();
            nextTaskId = processTaskDTO.getNextTask().get(0).getId();
        }
        if (!FlowStatusEnum.TO_BE_FINISHED.getName().equals(taskCode)) {
            this.buildRoleList(Collections.singletonList(processTaskDTO), roleListNext, roleListAll);
            List<WorkflowResultDto> workflowResultDtos = commonService.buildWorkFlowInfo(Collections.singletonList(processTaskDTO));
            String nextUserIds = workflowResultDtos.get(0).getNextExecutorUserIds();
            contract.setNextExecuteIds(String.join(",", roleListNext));
            contract.setPromoter(RequestContext.getExeUserId());
            contract.setInstanceId(instanceId);
            contract.setNextTaskId(nextTaskId);
            // 更新下一步可执行人
            contract.setNextExecuteUserIds(nextUserIds);
            if (!ObjectUtils.isEmpty(contract.getInstanceStatus())) {
                contract.setInstanceStatus(contract.getInstanceStatus() + "," + String.join(",", roleListNext));
            } else {
                contract.setInstanceStatus(String.join(",", roleListNext));
            }
            if ("0".equals(operate)) {
                // 通过操作
                contract.setStatus(WorkFlowStatusEnum.getMessage(taskCode).getPass());
            } else {
                // 驳回操作
                contract.setStatus(WorkFlowStatusEnum.getMessage(taskCode).getReject());
                contract.setPromoter(null);
            }
            executeOneStep(contract, taskName, nextUserIds, operate);
        } else {
            // 完成时 下一步骤可执行人清空
            contract.setNextExecuteUserIds("");
            contract.setApplyDate(new Date());
            contract.setStatus(taskCode);
            updateTaskModel(contract, operate);
        }
        this.getBaseMapper().updateById(contract);
    }

    private TaskV2Model updateTaskModel(JgMaintenanceContract contract, String operate) {
        Map<String, Object> params = new HashMap<>();
        FlowStatusEnum flowStatusEnum = this.getTaskStatus(operate);
        params.put("relationId", contract.getInstanceId());
        params.put("taskStatus", flowStatusEnum.getCode());
        params.put("taskStatusLabel", flowStatusEnum.getName());
        params.put("flowStatus", this.getTaskStatusByName(contract.getStatus()));
        params.put("flowStatusLabel", contract.getStatus());
        return commonService.updateTaskModelNew(params);
    }

    private FlowStatusEnum getTaskStatus(String operate) {
        if ("0".equals(operate)) {
            return FlowStatusEnum.TO_BE_FINISHED;
        } else {
            return FlowStatusEnum.REJECTED;
        }
    }

    private Integer getTaskStatusByName(String auditStatus) {
        return commonService.getDictionaryCodeByName(auditStatus);
    }

    private void createTaskModel(JgMaintenanceContract dto, String taskName, String submitType, String nextUserIds) {
        if ("1".equals(submitType)) {
            TaskModelDto taskModelDto = new TaskModelDto();
            taskModelDto.setFlowCreateDate(dto.getApplyDate());
            taskModelDto.setTaskName(taskName);
            taskModelDto.setTaskCode(dto.getApplyNo());
            taskModelDto.setTaskContent(this.buildTaskContent(dto));
            taskModelDto.setTaskDesc("");
            taskModelDto.setTaskType(BusinessTypeEnum.JG_MAINTENANCE_RECORD.getCode());
            taskModelDto.setTaskTypeLabel(BusinessTypeEnum.JG_MAINTENANCE_RECORD.getName());
            taskModelDto.setRelationId(dto.getInstanceId());
            taskModelDto.setExecuteUserIds(nextUserIds);
            FlowStatusEnum flowStatusEnum = this.getTaskStatus(submitType);
            taskModelDto.setTaskStatus(flowStatusEnum.getCode());
            taskModelDto.setTaskStatusLabel(flowStatusEnum.getName());
            taskModelDto.setFlowStatus(this.getTaskStatusByName(dto.getStatus()));
            taskModelDto.setFlowStatusLabel(dto.getStatus());
            taskModelDto.setStartUserId(dto.getCreateUserId());
            taskModelDto.setStartUser(dto.getCreateUserName());
            taskModelDto.setStartUserCompanyName(dto.getUseUnitName());
            taskModelDto.setNextExecuteUser(dto.getNextExecuteIds());
            taskModelDto.setStartDate(dto.getCreateDate());
            taskModelDto.setModel(dto);
            commonService.buildTaskModel(Collections.singletonList(taskModelDto));
        }
    }

    private Integer getTaskCodeByName(String auditStatus) {
        return commonService.getDictionaryCodeByName(auditStatus);
    }

    /**
     * 摘要构建
     *
     * @param dto 业务
     * @return 摘要
     */
    private String buildTaskContent(JgMaintenanceContract dto) {
        List<Map<String, Object>> list = maintenanceContractMapper.selectEquipList(dto.getSequenceNbr());
        String supervisoryCode = "";
        String equList = "";
        if (!CollectionUtils.isEmpty(list)) {
            Map<String, Object> map = list.get(0);
            if (map.containsKey("EQU_LIST")) {
                equList = map.get("EQU_LIST").toString();
            }
            if (map.containsKey("SUPERVISORY_CODE")) {
                supervisoryCode = map.get("SUPERVISORY_CODE").toString();
            }
        }
        String format = String.format("来自%s【%s】等的业务办理，【申请单号：%s】等", equList, supervisoryCode, dto.getApplyNo());
        return format;
    }
}