package com.yeejoin.amos.boot.module.jyjc.api.model;

import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;
import org.typroject.tyboot.core.rdbms.model.BaseModel;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @author system_generator
 * @date 2023-12-14
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "JyjcInspectionApplicationModel", description = "")
public class JyjcInspectionApplicationModel extends BaseModel {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "检验检测单位编码")
    private String inspectionUnitCode;
    @ApiModelProperty(value = "检验检测单位名称")
    private String inspectionUnitName;

    @ApiModelProperty(value = "检验检测类型")
    private String inspectionType;

    @ApiModelProperty(value = "设备种类")
    private String equipClassify;

    @ApiModelProperty(value = "报检单号")
    private String applicationNo;

    @ApiModelProperty(value = "申请日期")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date applicationDate;

    @ApiModelProperty(value = "检验检测类别")
    private String inspectionClassify;

    @ApiModelProperty(value = "申请联系人")
    private String applicationContactName;

    @ApiModelProperty(value = "申请联系人电话")
    private String applicationContactPhone;

    @ApiModelProperty(value = "申请说明")
    private String applicationRemark;

    @ApiModelProperty(value = "项目负责人(检验员)")
    private String inspectionChargePerson;

    @ApiModelProperty(value = "项目负责人联系电话（检验员联系电话）")
    private String inspectionChargePhone;

    @ApiModelProperty(value = "说明（受理说明、退回原因、转办说明）")
    private String processDescription;

    @ApiModelProperty(value = "原始报检单号")
    private String originalApplicationNo;

    @ApiModelProperty(value = "受理日期")
    private Date acceptDate;

    @ApiModelProperty(value = "报检单位编号")
    private String applicationUnitCode;
    @ApiModelProperty(value = "报检单位名称")
    private String applicationUnitName;
    @ApiModelProperty(value = "报检单位地址")
    private String address;
    @ApiModelProperty(value = "监管单位名称")
    private String superviseOrgName;

    @ApiModelProperty(value = "包含设备数量（冗余）")
    private Integer numberOfEquip;

    @ApiModelProperty(value = "工作流执行角色")
    private String workflowRole;

    @ApiModelProperty(value = "工作流实例ID")
    private String processInstanceId;

    @ApiModelProperty(value = "工作流key")
    private String processKey;

    @ApiModelProperty(value = "申请单二维码")
    private String applicationQrcode;

    @ApiModelProperty(value = "状态")
    private String status;
    @ApiModelProperty(value = "状态名称")
    private String statusName;

    @ApiModelProperty(value = "备注(无用预留)")
    private String remark;

    @ApiModelProperty(value = "业务类型（与菜单对应拆表使用）")
    private String bizType;

    @ApiModelProperty(value = "操作类型 0 新增 2 编辑 1 暂存")
    private String operationType;

    @ApiModelProperty(value = "操作类型 0 新增 2 编辑 1 暂存")
    private String workflowNode;

    @ApiModelProperty(value = "内部人员代码")
    private String innerPersonCode;

    @ApiModelProperty(value = "告知书")
    private List<Map<String, Object>> gzs;
    @ApiModelProperty(value = "产品质量证明书")
    private List<Map<String, Object>> cpzl;
    @ApiModelProperty(value = "施工自行检查报告")
    private List<Map<String, Object>> sgzxbg;
    @ApiModelProperty(value = "施工合同或证明")
    private List<Map<String, Object>> sght;
    @ApiModelProperty(value = "施工方案/施工设计文件")
    private List<Map<String, Object>> sgfa;
    @ApiModelProperty(value = "施工单位许可证书")
    private List<Map<String, Object>> sgdwxk;
    @ApiModelProperty(value = "型式试验证书")
    private List<Map<String, Object>> xssy;
    @ApiModelProperty(value = "限速器和渐进式安全钳的调试证书")
    private List<Map<String, Object>> xsqts;
    @ApiModelProperty(value = "土建声明")
    private List<Map<String, Object>> tjsm;
    @ApiModelProperty(value = "质量保证手册和程序文件")
    private List<Map<String, Object>> zlbz;
    @ApiModelProperty(value = "施工作业文件")
    private List<Map<String, Object>> sgzy;
    @ApiModelProperty(value = "施工人员、质量保证体系责任人、专业技术人员身份证、技术工人的身份证及资质证书")
    private List<Map<String, Object>> sgry;
    @ApiModelProperty(value = "产品技术文件")
    private List<Map<String, Object>> cpjs;
    @ApiModelProperty(value = "施工设计文件")
    private List<Map<String, Object>> sgsj;
    @ApiModelProperty(value = "施工分包方目录")
    private List<Map<String, Object>> sgfb;
    @ApiModelProperty(value = "分包方评价资料")
    private List<Map<String, Object>> fbspj;
    @ApiModelProperty(value = "操作类型 0 新增 2 编辑 1 暂存")
    private List<Map<String, Object>> equip;

    @ApiModelProperty("检验结果方式")
    private String resultType;

    @ApiModelProperty(value = "下一执行节点ids")
    private String nextExecuteIds;

    @ApiModelProperty(value = "发起人id用于撤回操作")
    private String promoter;

    @ApiModelProperty(value = "创建人ID")
    private String createUserId;


    private String instanceId;

    public String getInstanceId() {
        return this.processInstanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = this.processInstanceId;
    }
}
