package com.yeejoin.amos.boot.module.jyjc.biz.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONPObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Sequence;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.utils.DateUtils;
import com.yeejoin.amos.boot.biz.common.utils.RedisKey;
import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import com.yeejoin.amos.boot.module.jyjc.api.common.StringUtil;
import com.yeejoin.amos.boot.module.jyjc.api.entity.JyjcInspectionResult;
import com.yeejoin.amos.boot.module.jyjc.api.entity.JyjcInspectionResultAttachment;
import com.yeejoin.amos.boot.module.jyjc.api.entity.JyjcInspectionResultParam;
import com.yeejoin.amos.boot.module.jyjc.api.enums.ResultStatusEnum;
import com.yeejoin.amos.boot.module.jyjc.api.mapper.JyjcInspectionResultMapper;
import com.yeejoin.amos.boot.module.jyjc.api.model.JyjcInspectionResultModel;
import com.yeejoin.amos.boot.module.jyjc.api.service.IJyjcInspectionResultAttachmentService;
import com.yeejoin.amos.boot.module.jyjc.api.service.IJyjcInspectionResultParamService;
import com.yeejoin.amos.boot.module.jyjc.api.service.IJyjcInspectionResultService;
import com.yeejoin.amos.boot.module.jyjc.biz.utils.JsonUtils;
import com.yeejoin.amos.boot.module.ymt.api.entity.CategoryOtherInfo;
import com.yeejoin.amos.boot.module.ymt.api.entity.InspectionDetectionInfo;
import com.yeejoin.amos.boot.module.ymt.api.entity.TzBaseEnterpriseInfo;
import com.yeejoin.amos.boot.module.ymt.api.enums.EquipmentClassifityEnum;
import com.yeejoin.amos.boot.module.ymt.api.mapper.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 业务开通申请表服务实现类
 *
 * @author system_generator
 * @date 2023-12-14
 */
@Service
public class JyjcInspectionResultServiceImpl extends BaseService<JyjcInspectionResultModel, JyjcInspectionResult, JyjcInspectionResultMapper> implements IJyjcInspectionResultService {

    private static final String JYJC_SUBMIT_FILE_PREFIX = "JYJC_";
    private static final String JYJC_SUBMIT_FILE_JYBG = "JYBG";
    private static final String JYJC_SUBMIT_KEY = "inspectResult";
    private static final String JYJC_RESULT_STATUS = "2";

    @Autowired
    private IJyjcInspectionResultAttachmentService iJyjcInspectionResultAttachmentService;

    @Autowired
    private IJyjcInspectionResultParamService iJyjcInspectionResultParamService;

    @Autowired
    EquipmentCategoryMapper equipmentCategoryMapper;

    @Value("classpath:/json/equipCategory.json")
    private Resource equipCategory;

    @Autowired
    JyjcInspectionResultMapper resultMapper;

    @Autowired
    JyjcInspectionResultParamServiceImpl resultParamService;
    @Autowired
    JyjcInspectionResultAttachmentServiceImpl attachmentService;
    @Autowired
    private RedisUtils redisUtils;
    @Autowired
    UseInfoMapper useInfoMapper;
    @Autowired
    CategoryOtherInfoMapper categoryOtherInfoMapper;

    @Autowired
    InspectionDetectionInfoMapper inspectionDetectionInfoMapper;

    @Autowired
    private Sequence sequence;

    @Autowired
    TzBaseEnterpriseInfoMapper tzBaseEnterpriseInfoMapper;

    /**
     * 检验检测单位分页查询
     */
    public Page<JyjcInspectionResultModel> queryForJyjcInspectionResultPage(Page<JyjcInspectionResultModel> page, JyjcInspectionResultModel model, boolean type) {
        ReginParams reginParams = JSON.parseObject(redisUtils.get(RedisKey.buildReginKey(RequestContext.getExeUserId(),
                RequestContext.getToken())).toString(), ReginParams.class);
        if (ObjectUtils.isEmpty(model)) {
            model = new JyjcInspectionResultModel();
        }
        if (type) {
            //检验检测单位分页查询
            model.setInspectionUnitCode(reginParams.getCompany().getCompanyCode());
        } else {
            //报检单位分页查询
            model.setApplicationUnitCode(reginParams.getCompany().getCompanyCode());
        }
        Page<JyjcInspectionResultModel> resultPage = resultMapper.selectJyjcInspectionResultpPage(page, model);
        resultPage.getRecords().stream().forEach(v -> {
            if (ResultStatusEnum.NO_RESULT.getCode().equals(v.getResultStatus()))
                v.setResultStatusName(ResultStatusEnum.NO_RESULT.getName());
            if (ResultStatusEnum.YES_RESULT.getCode().equals(v.getResultStatus()))
                v.setResultStatusName(ResultStatusEnum.YES_RESULT.getName());
        });
        return resultPage;
    }


    @Transactional(rollbackFor = Exception.class)
    public JyjcInspectionResultModel updateJyjcInspectionResult(Map<String, Map<String, Object>> tableModel) {

        Map<String, Object> map = tableModel.get(JYJC_SUBMIT_KEY);

        JyjcInspectionResultModel model = BeanUtil.mapToBean(map, JyjcInspectionResultModel.class, true);
        String inspector = model.getInspector();
        if (StringUtil.isNotEmpty(inspector)) {
            List jsonArray = JSONArray.parseArray(inspector);
            Object inspectors = jsonArray.stream().map(String::valueOf).collect(Collectors.joining(","));
            model.setInspector(String.valueOf(inspectors));
        }
        model.setResultStatus(JYJC_RESULT_STATUS);

        // 更新结果主表
        updateWithModel(model);

        // 更新附件表
        List<JyjcInspectionResultAttachment> attachmentList = new ArrayList<>();
        LambdaQueryWrapper<JyjcInspectionResultAttachment> fileWrapper = new LambdaQueryWrapper<>();
        fileWrapper.eq(JyjcInspectionResultAttachment::getResultSeq, model.getSequenceNbr());
        List<JyjcInspectionResultAttachment> fileList = attachmentService.list(fileWrapper);
        JyjcInspectionResultAttachment jybgFile = new JyjcInspectionResultAttachment();

        map.forEach((k, v) -> {
            if (k.contains(JYJC_SUBMIT_FILE_PREFIX)) {
                JyjcInspectionResultAttachment attachment = new JyjcInspectionResultAttachment();
                attachment.setResultSeq(model.getSequenceNbr());
                attachment.setAttachmentUrl(JSON.toJSONString(map.get(k)));
                attachment.setAttachmentType(k);
                // 新增时需要判断之前有就更新
                if (!CollectionUtils.isEmpty(fileList)) {
                    List<JyjcInspectionResultAttachment> collect = fileList.stream().filter(obj -> k.equals(obj.getAttachmentType())).collect(Collectors.toList());
                    if (!CollectionUtils.isEmpty(collect)) {
                        JyjcInspectionResultAttachment jyjcInspectionResultAttachment = collect.get(0);
                        attachment.setSequenceNbr(jyjcInspectionResultAttachment.getSequenceNbr());
                    }
                }
                attachmentList.add(attachment);
                if (k.contains(JYJC_SUBMIT_FILE_JYBG)) {
                    jybgFile.setAttachmentUrl(JSON.toJSONString(map.get(k)));
                    attachment.setAttachmentType(k);
                }
            }
        });
        if (!CollectionUtils.isEmpty(attachmentList)) {
            attachmentService.saveOrUpdateBatch(attachmentList);
        }

        // 更新参数表
        LambdaQueryWrapper<JyjcInspectionResultParam> paramWrapper = new LambdaQueryWrapper<>();
        paramWrapper.eq(JyjcInspectionResultParam::getResultSeq, model.getSequenceNbr());
        List<JyjcInspectionResultParam> params = resultParamService.list(paramWrapper);
        List<JyjcInspectionResultParam> paramList = new ArrayList<>();
        tableModel.forEach((k, v) -> {
            if (!JYJC_SUBMIT_KEY.equals(k) && !ObjectUtils.isEmpty(tableModel.get(k))) {
                List<JyjcInspectionResultParam> collect = params.stream().filter(p -> k.equals(p.getParamType())).collect(Collectors.toList());
                JyjcInspectionResultParam resultParam = new JyjcInspectionResultParam();
                if (!CollectionUtils.isEmpty(collect)) {
                    resultParam.setSequenceNbr(collect.get(0).getSequenceNbr());
                }
                resultParam.setParamType(k);
                resultParam.setResultSeq(model.getSequenceNbr());
                resultParam.setParamJson(JSON.toJSONString(tableModel.get(k)));
                paramList.add(resultParam);
            }
        });
        if (!CollectionUtils.isEmpty(paramList)){
            resultParamService.saveOrUpdateBatch(paramList);
        }

        //插入操作历史记录
        InspectionDetectionInfo info = new InspectionDetectionInfo();
        QueryWrapper<InspectionDetectionInfo> wrapper = new QueryWrapper<>();
        wrapper.lambda().eq(InspectionDetectionInfo::getInspectReportNo, model.getResultNo());
        List<InspectionDetectionInfo> list = inspectionDetectionInfoMapper.selectList(wrapper);
        if (CollectionUtils.isEmpty(list)) {
            extracted(model, info, jybgFile);
            info.setSequenceNbr(sequence.nextId() + "");
            inspectionDetectionInfoMapper.insert(info);
        } else {
            info = list.get(0);
            extracted(model, info, jybgFile);
            inspectionDetectionInfoMapper.updateById(info);
        }
        //更新使用信息表
    useInfoMapper.updateByRecord(model.getEquipUnicode(),model.getNextInspectionDate(),model.getInspectionType(),model.getApplicationNo());
        return model;
    }

    private void extracted(JyjcInspectionResultModel model, InspectionDetectionInfo info, JyjcInspectionResultAttachment jybgFile ) {
        // 回填检验机构名称
        LambdaQueryWrapper<TzBaseEnterpriseInfo> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(TzBaseEnterpriseInfo::getUseCode, model.getInspectionUnitCode());
        List<TzBaseEnterpriseInfo> tzBaseEnterpriseInfos = tzBaseEnterpriseInfoMapper.selectList(wrapper);
        if (!CollectionUtils.isEmpty(tzBaseEnterpriseInfos)) {
            info.setInspectOrgName(tzBaseEnterpriseInfos.get(0).getUseUnit());
        }

        info.setInspectType(model.getInspectionType());
        info.setRecord(model.getEquipUnicode());
        info.setInspectDate(model.getInspectionDate());
        info.setInspectStaff(model.getInspector());
        info.setInspectReport(jybgFile.getAttachmentUrl());
        info.setInspectConclusion(model.getInspectionConclusion());
        info.setProblemRemark(model.getNonConformance());
        info.setNextInspectDate(model.getNextInspectionDate());
        info.setSequenceCode(model.getEquipUnicode());
        info.setInspectOrgCode(model.getInspectionUnitCode());
        info.setInspectReportNo(model.getResultNo());
        info.setRecDate(new Date());
    }

    /**
     * 列表查询 示例
     */
    public List<JyjcInspectionResultModel> queryForJyjcInspectionResultList() {
        return this.queryForList("", false);
    }

    @Override
    public Map<String, Object> queryDetailBySeq(Long sequenceNbr) {
        Map<String, Object> map = new HashMap<>();
        Map<String, Object> resultMap = new HashMap<>(9);

        JyjcInspectionResultModel jyjcInspectionResultModel = this.queryBySeq(sequenceNbr);
        if (!ObjectUtils.isEmpty(jyjcInspectionResultModel)) {
            // 对象转map
            map = BeanUtil.beanToMap(jyjcInspectionResultModel);

            // 获取附件
            List<JyjcInspectionResultAttachment> attachmentList = iJyjcInspectionResultAttachmentService.getObjByResultSeq(sequenceNbr);
            if (!CollectionUtils.isEmpty(attachmentList)) {
                Map<String, Object> attachmentMap = attachmentList.stream().map(obj -> {
                    if (StringUtil.isNotEmpty(obj.getAttachmentUrl())) {
                        obj.setAttachmentUrlList(JSONArray.parseArray(obj.getAttachmentUrl()));
                    }
                    return obj;
                }).collect(Collectors.toMap(JyjcInspectionResultAttachment::getAttachmentType, JyjcInspectionResultAttachment::getAttachmentUrlList));
                map.putAll(attachmentMap);
            }

            // 获取技术参数
            List<JyjcInspectionResultParam> paramList = iJyjcInspectionResultParamService.getParamByResultSeq(sequenceNbr);
            if (!CollectionUtils.isEmpty(paramList)) {
                Map<String, Object> finalMap = map;
                paramList.forEach(param -> {
                    if (!ObjectUtils.isEmpty(param.getParamJson())) {
                        JSONObject paramObj = JSON.parseObject(String.valueOf(param.getParamJson()));
                        paramObj.put("equList", finalMap.get("equList"));
                        paramObj.put("equCategory", finalMap.get("equCategory"));
                        resultMap.put(param.getParamType(), paramObj);
                    }
                });
            }
        }
        resultMap.put(JYJC_SUBMIT_KEY, map);
        return resultMap;
    }

    @Override
    public List<Map<String, Object>> equipList(String type, String notNode) {
        List<Map<String, Object>> menus = new ArrayList<>();
        Map<String, List<Map<String, Object>>> resourceJson = JsonUtils.getResourceJson(equipCategory);
        List<Map<String, Object>> mapList;
        if (ValidationUtil.isEmpty(type)) {
            mapList = resourceJson.get(EquipmentClassifityEnum.BDLS.getCode());
        } else {
            mapList = resourceJson.get(type);
        }

        mapList.stream().filter(map -> {
            if (!ObjectUtils.isEmpty(notNode)) {
                String[] code = notNode.split(",");
                List<String> codeList = Arrays.asList(code);
                return !codeList.contains(map.get("code"));
            }
            return true;
        }).forEach(obj -> {
            Map<String, Object> resultMap = new HashMap<>(2);
            resultMap.put("instanceName", obj.get("name"));
            resultMap.put("instanceId", obj.get("code"));
            menus.add(resultMap);
        });

        return menus;
    }
}