package com.yeejoin.amos.boot.biz.common.utils;

import org.springframework.http.HttpStatus;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import com.yeejoin.amos.boot.biz.common.constants.CommonConstant;

/**
 * @author DELL
 */
public class CommonResponseUtil {
    public static ResponseModel<?> success() {
        ResponseModel<?> res = new ResponseModel();
        res.setDevMessage(CommonConstant.RESULT_SUCCESS);
        res.setStatus(HttpStatus.OK.value());
        return res;
    }

    public static ResponseModel<Object> success(Object obj) {
        ResponseModel<Object> res = new ResponseModel<Object>();
        res.setResult(obj);
        res.setDevMessage(CommonConstant.RESULT_SUCCESS);
        res.setStatus(HttpStatus.OK.value());
        return res;
    }

    public static ResponseModel<Object> success(Object obj, String message) {
        ResponseModel<Object> res = new ResponseModel<Object>();
        res.setResult(obj);
        res.setDevMessage(message);
        res.setStatus(HttpStatus.OK.value());
        return res;
    }

    public static ResponseModel<?> failure() {
        ResponseModel<?> res = new ResponseModel();
        res.setDevMessage(CommonConstant.RESULT_FAILURE);
        res.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
        return res;
    }

    public static ResponseModel<?> failure(String message) {
        ResponseModel<?> res = new ResponseModel();
        res.setDevMessage(CommonConstant.RESULT_FAILURE);
        res.setMessage(message);
        res.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
        return res;
    }

    public static ResponseModel<Object> failure(Object obj, String message) {
        ResponseModel<Object> res = new ResponseModel<Object>();
        res.setResult(obj);
        res.setDevMessage(CommonConstant.RESULT_FAILURE);
        res.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
        return res;
    }
}
