package com.yeejoin.amos.server.gateway.config;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.factory.StripPrefixGatewayFilterFactory;
import org.springframework.cloud.gateway.route.RouteLocator;
import org.springframework.cloud.gateway.route.builder.RouteLocatorBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class GatewayInfo {

    static StripPrefixGatewayFilterFactory stripPrefixGatewayFilterFactory = new StripPrefixGatewayFilterFactory();

    static GatewayFilter gatewayFilter;

    static {
        StripPrefixGatewayFilterFactory.Config config = new StripPrefixGatewayFilterFactory.Config();
        config.setParts(1);
        gatewayFilter = stripPrefixGatewayFilterFactory.apply(config);
    }

//    @Value("${elecfire_converter_statton_service}")
//    private String elecfire_converter_statton_service;
//
//    @Value("${elecfire_converter_statton_patrol}")
//    private String elecfire_converter_statton_patrol;
//
//    @Value("${elecfire_converter_statton_3dservice}")
//    private String elecfire_converter_statton_3dservice;
//
//    @Value("${elecfire_converter_statton_duty}")
//    private String DUTY_ERUKA_NAME;
//
//
//    @Value("${elecfire_converter_statton_aixah}")
//    private String AI_XAH_JD;
//
//    @Value("${elecfire_converter_statton_equipmanage}")
//    private String AMOS_EQUIPMANAGE;
//
//    @Value("${visual_morphic}")
//    private String visual_morphic;
//
//    @Value("${elecfire_converter_statton_intelligentbox}")
//    private String AMOS_API_INTELLIGENTBOX;


    /**
     *
     * @param builder
     * @return
     */
    @Bean
    public RouteLocator myRoutes(RouteLocatorBuilder builder) {
        return builder.routes().route(p -> p.path("/privilege/**").uri("lb://AMOS-API-PRIVILEGE"))
                .route(p -> p.path("/systemctl/**").uri("lb://AMOS-API-SYSTEMCTL"))
                .route(p -> p.path("/urule/**").uri("lb://AMOS-API-RULE"))


//                .route(p -> p.path("/fireAutoSys/**").uri("lb://" + elecfire_converter_statton_service))
//
//                .route(p -> p.path("/patrol/**").uri("lb://" + elecfire_converter_statton_patrol))
//
//                // 值班
//                .route(p -> p.path("/duty/**").uri("lb://" + DUTY_ERUKA_NAME))
//                .route(p -> p.path("/api/common/user/list/**").uri("lb://" + DUTY_ERUKA_NAME))
//                // AI消安盒
//                .route(p -> p.path("/intelligentbox/**").uri("lb://" + AMOS_API_INTELLIGENTBOX))
//                .route(p -> p.path("/tsioservice/**").uri(AI_XAH_JD))
//                //队站-装备信息系统
//                .route(p -> p.path("/equip/**").uri("lb://" + AMOS_EQUIPMANAGE))
////                .route(p -> p.path("/equip-1225/**").uri("lb://" + AMOS_EQUIPMANAGE))
//		        //组态
//		        .route(p -> p.path("/morphic/**").uri("lb://" + visual_morphic))
		        .build();

    }

}
