package com.yeejoin.amos.boot.module.jcs.biz.controller;

import io.swagger.annotations.Api;
import lombok.extern.slf4j.Slf4j;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.biz.common.utils.CommonResponseUtil;
import com.yeejoin.amos.boot.module.jcs.api.entity.CbDemo;
import com.yeejoin.amos.boot.module.jcs.api.service.IDemoService;

import java.util.List;

/**
 * 示例控制类
 * @Author lichenglong
 * @since 2021-05-27
 */
@RestController
@RequestMapping("/demo")
@Api(tags="示例")
@Slf4j
public class DemoController extends BaseController {
	
	@Autowired
	private IDemoService demoService;

    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/user")
    public ResponseModel<Object> findUserList() {
        List<CbDemo> lists = demoService.list();
        return CommonResponseUtil.success(lists);
    }

    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/demo/{seqNbr}")
    public ResponseModel findOneBySeqNbr(@PathVariable("seqNbr") Long seqNbr) {
        CbDemo demo = demoService.selectOneBySeqNbr(seqNbr);
        return CommonResponseUtil.success(demo);
    }
}
