package com.yeejoin.amos;


import org.mybatis.spring.annotation.MapperScan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.ServletComponentScan;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.netflix.eureka.EnableEurekaClient;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.core.env.Environment;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.transaction.annotation.EnableTransactionManagement;

/**
 * <pre>
   *   特种设备服务启动类
 * </pre>
 *
 * @author DELL
 */
@SpringBootApplication
@EnableTransactionManagement
@EnableConfigurationProperties
@ServletComponentScan
@EnableDiscoveryClient
@EnableFeignClients
@EnableAsync
@EnableEurekaClient
@MapperScan({"org.typroject.tyboot.demo.face.orm.dao*",
        "org.typroject.tyboot.face.*.orm.dao*",
        "org.typroject.tyboot.core.auth.face.orm.dao*",
        "org.typroject.tyboot.component.*.face.orm.dao*",
        "com.yeejoin.amos.boot.module.tzs.biz.dao.mapper"})
@ComponentScan(basePackages = { "org.typroject", "com.yeejoin.amos" })
public class AmosTzsApplication {
    private static final Logger logger = LoggerFactory.getLogger(AmosTzsApplication.class);

    public static void main(String[] args) {
  	  ConfigurableApplicationContext context = SpringApplication.run(AmosTzsApplication.class, args);
      Environment environment = context.getEnvironment();
      
      
      logger.info("The requested service of " + environment.getProperty("spring.application.name")
              + " has already been started in "
              + environment.getProperty("spring.profiles.active") + ""
              + " environment,and service's url is 'http://localhost:"
              + environment.getProperty("server.port")
              + environment.getProperty("server.servlet.context-path") + "/swagger-ui.html'");
    }
}
