package com.yeejoin.amos.boot.module.command.biz.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.Lists;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.biz.common.dto.PermissionModelDto;
import com.yeejoin.amos.boot.biz.common.enums.HomePageEnum;
import com.yeejoin.amos.boot.biz.common.service.IDataDictionaryService;
import com.yeejoin.amos.boot.biz.common.utils.WordConverterUtils;
import com.yeejoin.amos.boot.module.command.api.dao.SeismometeorologyDtoDao;
import com.yeejoin.amos.boot.module.command.api.dto.CarTaskDto;
import com.yeejoin.amos.boot.module.command.api.dto.SeismometeorologyDto;
import com.yeejoin.amos.boot.module.command.biz.service.impl.RemoteSecurityService;
import com.yeejoin.amos.boot.module.common.api.dto.*;
import com.yeejoin.amos.boot.module.common.api.dto.FireBrigadeResourceDto;
import com.yeejoin.amos.boot.module.common.api.entity.FireTeam;
import com.yeejoin.amos.boot.module.common.api.feign.EquipFeignClient;
import com.yeejoin.amos.boot.module.common.api.feign.IotFeignClient;
import com.yeejoin.amos.boot.module.common.api.feign.VideoFeignClient;
import com.yeejoin.amos.boot.module.common.api.service.IDutyCarService;
import com.yeejoin.amos.boot.module.common.api.service.IDutyPersonService;
import com.yeejoin.amos.boot.module.common.api.service.IFireChemicalService;
import com.yeejoin.amos.boot.module.common.api.service.IFireExpertsService;
import com.yeejoin.amos.boot.module.common.api.service.IFireStationService;
import com.yeejoin.amos.boot.module.common.api.service.IFireTeamService;
import com.yeejoin.amos.boot.module.common.api.service.IFirefightersService;
import com.yeejoin.amos.boot.module.common.api.service.IKeySiteService;
import com.yeejoin.amos.boot.module.common.api.service.ILinkageUnitService;
import com.yeejoin.amos.boot.module.common.api.service.IOrgUsrService;
import com.yeejoin.amos.boot.module.common.api.service.ISourceFileService;
import com.yeejoin.amos.boot.module.common.api.service.IWaterResourceService;
import com.yeejoin.amos.boot.module.jcs.api.dto.*;
import com.yeejoin.amos.boot.module.jcs.api.entity.AlertCalled;
import com.yeejoin.amos.boot.module.jcs.api.entity.AlertFormValue;
import com.yeejoin.amos.boot.module.jcs.api.entity.PowerTransferCompanyResources;
import com.yeejoin.amos.boot.module.jcs.api.entity.UserCar;
import com.yeejoin.amos.boot.module.jcs.api.enums.AlertStageEnums;
import com.yeejoin.amos.boot.module.jcs.api.enums.FireCarStatusEnum;
import com.yeejoin.amos.boot.module.jcs.api.mapper.PowerTransferCompanyResourcesMapper;
import com.yeejoin.amos.boot.module.jcs.api.mapper.PowerTransferMapper;
import com.yeejoin.amos.boot.module.jcs.api.service.*;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.poi.ss.formula.functions.T;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.foundation.exception.BaseException;
import org.typroject.tyboot.core.foundation.utils.Bean;
import org.typroject.tyboot.core.foundation.utils.DateUtil;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * *指挥资源Api
 *
 * <PRE>
 * author tw
 * date 2021/7/15
 * </PRE>
 */
@RestController
@Api(tags = "指挥资源Api")
@RequestMapping(value = "/command")
public class CommandController extends BaseController {

    @Autowired
    IAlertCalledService iAlertCalledService;
    @Autowired
    IFireStationService iFireStationService;
    @Autowired
    IFireTeamService iFireTeamService;
    @Autowired
    IWaterResourceService iWaterResourceService;
    @Autowired
    SeismometeorologyDtoDao seismometeorologyDtoDao;
    @Autowired
    IOrgUsrService  iOrgUsrService;
    @Autowired
    ILinkageUnitService  iLinkageUnitService;
    @Autowired
    IAlertSubmittedService alertSubmittedService;
    @Autowired
    IDataDictionaryService  dataDictionaryService;
    @Autowired
    IFireChemicalService fireChemicalService;

    @Autowired
    IFireExpertsService fireExpertsService;
    
    @Autowired
    IFirefightersService firefightersService;
    @Autowired
    private IAlertFormValueService iAlertFormValueService;
    @Autowired
    private IAircraftService aircraftService;
    @Autowired
    IPowerTransferService powerTransferService;
    @Autowired
    RemoteSecurityService remoteSecurityService;
    @Autowired
    IAlertFormValueService alertFormValueService;
 // 文件读取参数
 	@Value("${file.url}")
 	private String readUrl;
 	 @Autowired
     EquipFeignClient equipFeignClient;
    @Autowired
    PowerTransferMapper powerTransferMapper;
    @Autowired
    VideoFeignClient videoFeignClient;
    @Autowired
    IKeySiteService keySiteService;
    @Autowired
    EquipFeignClient equipFeignService;
    @Autowired
    IPowerTransferCompanyService powerTransferCompanyService;

    @Autowired
    IPowerTransferCompanyResourcesService powerTransferCompanyResourcesService;

    @Autowired
    PowerTransferCompanyResourcesMapper powerTransferCompanyResourcesMapper;

    @Autowired
    ISourceFileService sourceFileService;

    @Value("${video.url}")
 	private String videoUrl;

    @Autowired
    IDutyPersonService iDutyPersonService;

    @Autowired
    IDutyCarService iDutyCarService;
    @Autowired
    IotFeignClient iotFeignClient;

    @Autowired
    IUserCarService userCarService;


    /**
     * 警情列表
     *
     * @return
     */
    @TycloudOperation( needAuth = true, ApiLevel = UserType.AGENCY)
    @GetMapping(value = "JQ/list")
    @ApiOperation(httpMethod = "GET", value = "警情列表查询", notes = "警情列表查询")
    public ResponseModel<Object> listPage(RequestData par) {
        par.setStatus(0);
        List<AlertCalledZhDto> list= iAlertCalledService.alertCalledListByAlertStatus(null,null,par);
        return ResponseHelper.buildResponse(list);
    }

    /**
     * 分页警情列表
     *
     * @return
     */
    @TycloudOperation( needAuth = true, ApiLevel = UserType.AGENCY)
    @GetMapping(value = "history/list")
    @ApiOperation(httpMethod = "GET", value = "警情列表查询", notes = "警情列表查询")
    public ResponseModel<Page<AlertCalledZhDto>> listhistoryPage(Integer pageNum, Integer pageSize,RequestData par) {

        if(par.getStatus()==null){
            par.setStatus(1);
        }
        if (null == pageNum || null == pageSize) {
            pageNum = 1;
            pageSize = Integer.MAX_VALUE;
        } else {
            pageNum = (pageNum - 1) * pageSize;
        }
        List<AlertCalledZhDto> list= iAlertCalledService.alertCalledListByAlertStatus( pageNum,  pageSize,par);
        Page<AlertCalledZhDto> pageBean = new Page<>(pageNum, pageSize);
        Integer num=  iAlertCalledService.alertCalledListByAlertStatusCount(par);
        pageBean.setRecords(list);
        pageBean.setTotal(num);
        return ResponseHelper.buildResponse(pageBean);
    }


    /**
     * 保卫目标分页查询
     *
     * @return
     */
    @TycloudOperation( needAuth = true, ApiLevel = UserType.AGENCY)
    @GetMapping(value = "ZDDW/list")
    @ApiOperation(httpMethod = "GET", value = "保卫目标列表分页查询", notes = "保卫目标列表分页查询")
    public ResponseModel<IPage<CompanyDto>> listPageZDDW(Integer pageNum, Integer pageSize, RequestData par) {
        Page<CompanyDto> pageBean = new Page<>(pageNum, pageSize);
        List<CompanyDto>  list= iOrgUsrService.listContractDto(pageNum,pageSize,par);
        Integer num=  iOrgUsrService.listContractDtoCount(par);
        pageBean.setRecords(list);
        pageBean.setTotal(num);
        return ResponseHelper.buildResponse(pageBean);
    }

   /**
    * * @param null
    * @return
    * <PRE>
    * author tw
    * date 2021/7/21
    * </PRE>
    * 保卫目标详情
    */
    @TycloudOperation( needAuth = true, ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/ZDDW", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "保卫目标详情", notes = "保卫目标详情")
    public ResponseModel<OrgUsrFormDto> selectZDDWById( Long id) throws Exception {
    	OrgUsrFormDto orgUsrFormDto=  iOrgUsrService.selectCompanyById(id);
        return ResponseHelper.buildResponse(orgUsrFormDto);
    }




    /**
     * 微型消防站列表分页查询
     *
     * @return
     */
    @TycloudOperation( needAuth = true, ApiLevel = UserType.AGENCY)
    @GetMapping(value = "WX/list")
    @ApiOperation(httpMethod = "GET", value = "微型消防站列表分页查询", notes = "微型消防站列表分页查询")
    public ResponseModel<IPage<FireStationzhDto>> listPageWx(Integer pageNum, Integer pageSize, RequestData par) {
        Page<FireStationzhDto> pageBean = new Page<>(pageNum, pageSize);
        List<FireStationzhDto>  list= iFireStationService.getStationList(pageNum,pageSize,par);
        Integer num=  iFireStationService.getStationListCount(par);
        pageBean.setRecords(list);
        pageBean.setTotal(num);
        return ResponseHelper.buildResponse(pageBean);
    }
    /**
     * 水源列表分页查询
     *
     * @return
     */
    @TycloudOperation( needAuth = true, ApiLevel = UserType.AGENCY)
    @GetMapping(value = "SY500/list")
    @ApiOperation(httpMethod = "GET", value = "500水源列表分页查询", notes = "500水源列表分页查询")
    public ResponseModel<IPage<WaterResourceZhDto>> listPageSY500(Integer pageNum, Integer pageSize, RequestData par) {

        par.setDistance(500D);

        Page<WaterResourceZhDto> pageBean = new Page<>(pageNum, pageSize);
        List<WaterResourceZhDto>  list= iWaterResourceService.getWaterResourceList(pageNum,pageSize,par);
        Integer num=  iWaterResourceService.getWaterResourceListCount(par);
        pageBean.setRecords(list);
        pageBean.setTotal(num);
        return ResponseHelper.buildResponse(pageBean);
    }




    /**
     * 水源列表分页查询
     *
     * @return
     */
    @TycloudOperation( needAuth = true, ApiLevel = UserType.AGENCY)
    @GetMapping(value = "video/list")
    @ApiOperation(httpMethod = "GET", value = " 视频分页查询88", notes = "视频分页查询88")
    public ResponseModel<Object> getVideo(Integer pageNum, Integer pageSize, RequestData par) {

      if(par.getAlertId()!=null){
          AlertCalled alertCalled=   iAlertCalledService.getAlertCalledById(par.getAlertId());
          par.setLatitude(alertCalled.getCoordinateX());
          par.setLongitude(alertCalled.getCoordinateY());
      }
        ResponseModel<Page<Map<String, Object>>> data=  equipFeignClient.pageVideo(pageNum==0?1:pageNum,pageSize,par.getLongitude(),par.getLatitude(),par.getDistance());


        Page<Map<String, Object>>  pag=  data!=null?data.getResult():null;
        List<Map<String, Object>> records =pag!=null?pag.getRecords():null;
        if(records!=null&&records.size()>0){
            for (Map<String, Object> record : records) {
                ResponseModel<String> da=videoFeignClient.videoUrlByIndexCode(record.get("code")+"");
                String url=  da!=null?da.getResult().substring(da.getResult().indexOf("openUrl")):null;
                record.put("url",url);
            }
            pag.setRecords(records);
        }
        return ResponseHelper.buildResponse(pag);
    }






    @TycloudOperation( needAuth = true,ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/video/page", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "分页获取视频", notes = "分页获取视频")
    public ResponseModel<Object> getVideopage(String current,
                                              String size,
                                              String equipmentName,
                                              String code,
                                              String buildingId
    )throws Exception {

        ResponseModel<Page<Map<String, Object>>>  data= equipFeignClient.getVideopag(current,size,buildingId,code,equipmentName);
        Page<Map<String, Object>>  pag=  data!=null?data.getResult():null;
        List<Map<String, Object>> records =pag!=null?pag.getRecords():null;
        if(records!=null&&records.size()>0){
            for (Map<String, Object> record : records) {
                ResponseModel<String> da=videoFeignClient.videoUrlByIndexCode(record.get("code")+"");
                String url=  da!=null?da.getResult().substring(da.getResult().indexOf("openUrl")):null;
                record.put("url",url);
            }
            pag.setRecords(records);
        }
        return ResponseHelper.buildResponse(pag);
    }

    /**
     * 水源列表分页查询
     *
     * @returngetVideo
     */
    @TycloudOperation( needAuth = true, ApiLevel = UserType.AGENCY)
    @PostMapping (value = "video/pageList")
    @ApiOperation(httpMethod = "POST", value = " app视频分页查询88", notes = "app视频分页查询88")
    public ResponseModel<Object> pageList(@RequestBody PageDto pageDto) {
        ResponseModel<Page<VideoDto>> data=  equipFeignClient.pageList(pageDto.getCurrent(),
                pageDto.getSize(),
                pageDto.getCode()==null?"":pageDto.getCode(),
                pageDto.getName()==null?"":pageDto.getName(),
                pageDto.getTypeCode()==null?"":pageDto.getTypeCode());
        Page<VideoDto>  pag=  data!=null?data.getResult():null;
        List<VideoDto> records =pag!=null?pag.getRecords():null;
        if(records!=null&&records.size()>0){
            for (VideoDto record : records) {
                ResponseModel<String> da=videoFeignClient.videoUrlByIndexCode(record.getCode());
                String url=  da!=null?da.getResult():null;
                record.setUrl(url);
            }
            pag.setRecords(records);
        }
        return ResponseHelper.buildResponse(pag);
    }







    /**
     * 水源列表分页查询
     *
     * @return
     */
    @TycloudOperation( needAuth = true, ApiLevel = UserType.AGENCY)
    @GetMapping(value = "video/{id}")
    @ApiOperation(httpMethod = "GET", value = " 视频详情88", notes = "视频详情88")
    public ResponseModel<Object> getVideoByid(@PathVariable Long id) {
        ResponseModel<Map<String, Object>> data=  equipFeignClient.getByid(id);
        return ResponseHelper.buildResponse(data!=null?data.getResult():null);
    }

    /**
     * 水源列表分页查询
     *
     * @return
     */
    @TycloudOperation( needAuth = true, ApiLevel = UserType.AGENCY)
    @GetMapping(value = "SY1000/list")
    @ApiOperation(httpMethod = "GET", value = "1000水源列表分页查询", notes = "1000水源列表分页查询")
    public ResponseModel<IPage<WaterResourceZhDto>> listPageSY1000(Integer pageNum, Integer pageSize, RequestData par) {
        par.setDistance(1000D);
        Page<WaterResourceZhDto> pageBean = new Page<>(pageNum, pageSize);
        List<WaterResourceZhDto>  list= iWaterResourceService.getWaterResourceList(pageNum,pageSize,par);
        Integer num=  iWaterResourceService.getWaterResourceListCount(par);
        pageBean.setRecords(list);
        pageBean.setTotal(num);
        return ResponseHelper.buildResponse(pageBean);
    }



//    /**
//     * 水源列表分页查询
//     *
//     * @return
//     */
//    @TycloudOperation( needAuth = true, ApiLevel = UserType.AGENCY)
//    @GetMapping(value = "SYTY/list")
//    @ApiOperation(httpMethod = "GET", value = "水源列表分页查询", notes = "水源列表分页查询")
//    public ResponseModel<IPage<WaterResourceZhDto>> listPageSYTY(Integer pageNum, Integer pageSize, RequestData par) {
//        Page<WaterResourceZhDto> pageBean = new Page<>(pageNum, pageSize);
//        List<WaterResourceZhDto>  list= iWaterResourceService.getWaterResourceList(pageNum,pageSize,par);
//        Integer num=  iWaterResourceService.getWaterResourceListCount(par);
//        pageBean.setRecords(list);
//        pageBean.setTotal(num);
//        return ResponseHelper.buildResponse(pageBean);
//    }


    /**
     * 消防队伍列表分页查询
     *
     * @return
     */
    @TycloudOperation( needAuth = true, ApiLevel = UserType.AGENCY)
    @GetMapping(value = "DW/list")
    @ApiOperation(httpMethod = "GET", value = "消防队伍列表分页查询", notes = "消防队伍列表分页查询")
    public ResponseModel<IPage<FireTeamZhDto>> listPage(Integer pageNum, Integer pageSize, RequestData par) {
        par.setTypeCode(AlertStageEnums.YWDD.getCode());
        Page<FireTeamZhDto> pageBean = new Page<>(pageNum, pageSize);
        List<FireTeamZhDto>  list= iFireTeamService.getFireTeamList(pageNum,pageSize,par);
        Integer num=  iFireTeamService.getFireTeamListCount(par);
        pageBean.setRecords(list);
        pageBean.setTotal(num);
        return ResponseHelper.buildResponse(pageBean);
    }

    /**
     * 联动力量列表分页查询
     *
     * @return
     */
    @TycloudOperation( needAuth = true, ApiLevel = UserType.AGENCY)
    @GetMapping(value = "linkageForce/list")
    @ApiOperation(httpMethod = "GET", value = "联动力量列表分页查询", notes = "联动力量列表分页查询")
    public ResponseModel<IPage<LinkageUnitZhDto>> linkageForcelistPage(Integer pageNum, Integer pageSize, RequestData par) {
        Page<LinkageUnitZhDto> pageBean = new Page<>(pageNum, pageSize);
        List<LinkageUnitZhDto>  list= iLinkageUnitService.listLinkageUnitZhDto(pageNum,pageSize,par);
        Integer num=  iLinkageUnitService.listLinkageUnitZhDtoCount(par);
        pageBean.setRecords(list);
        pageBean.setTotal(num);
        return ResponseHelper.buildResponse(pageBean);
    }

    /**
     * * @param null
     * @return
     * <PRE>
     * author tw
     * date 2021/7/21
     * </PRE>
     * 联动单位详情
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/linkageForce")
    @ApiOperation(httpMethod = "GET", value = "根据sequenceNbr查询单个联动单位", notes = "根据sequenceNbr查询单个联动单位")
    public ResponseModel<LinkageUnitDto> selectlinkageForceOne( Long id) {
        return ResponseHelper.buildResponse(iLinkageUnitService.queryOne(id));
    }


    /**
     * 消防队伍列表分页查询
     *
     * @return
     */
    @TycloudOperation( needAuth = true, ApiLevel = UserType.AGENCY)
    @GetMapping(value = "ZQ/list")
    @ApiOperation(httpMethod = "GET", value = "执勤实力列表分页查询", notes = "执勤实力列表分页查询")
    public ResponseModel<IPage<FireTeamZhDto>> ZQlistPage(Integer pageNum, Integer pageSize, RequestData par) {
        if(par.getTypeCode()==null){
            par.setTypeCode( AlertStageEnums.ZZZD.getCode()+","+AlertStageEnums.YLJY.getCode());
        }
        Page<FireTeamZhDto> pageBean = new Page<>(pageNum, pageSize);
        List<FireTeamZhDto>  list= iFireTeamService.getFireTeamList(pageNum,pageSize,par);
        Integer num=  iFireTeamService.getFireTeamListCount(par);
        pageBean.setRecords(list);
        pageBean.setTotal(num);
        return ResponseHelper.buildResponse(pageBean);
    }
    /**
     *
     * 根据id查询警情详情
     *
     * **/

    @TycloudOperation( needAuth = true, ApiLevel = UserType.AGENCY)
    @GetMapping(value = "JQ/{id}")
    @ApiOperation(httpMethod = "GET", value = "根据id查询灾情详情", notes = "根据id查询灾情详情")
    public ResponseModel<Object> selectById( @PathVariable Long id) {

        return ResponseHelper.buildResponse(iAlertCalledService.selectAlertCalledKeyValueLabelById(id));

    }



    /**
     * 根据id查询微型消防站
     *
     * @param id 主键
     *
     */
    @TycloudOperation( needAuth = true,ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/WX")
    @ApiOperation(httpMethod = "GET", value = "根据id查询微型消防站", notes = "根据id查询微型消防站")
    public ResponseModel<FireStationDto> seleteOne( Long id) {
        return ResponseHelper.buildResponse(iFireStationService.selectBySequenceNbr(id));
    }




    /**
     * 根据id查询水源
     *
     * @param id 主键
     *
     */
    @TycloudOperation( needAuth = true,ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/SY")
    @ApiOperation(httpMethod = "GET", value = "根据id查询水源", notes = "根据id查询水源")
    public ResponseModel<JSONObject> selectOne( Long id) {
    	JSONObject jsonObject= 	JSONObject.parseObject(JSONObject.toJSONString(iWaterResourceService.selectBySequenceNbr(id)));
    	jsonObject.remove("managementUnit");
        return ResponseHelper.buildResponse(jsonObject);
    }


    /**
     * 根据id查询队伍信息
     *
     * @param id
     * @return
     */
    @TycloudOperation( needAuth = true,ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/DW", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "根据id查询队伍信息", notes = "根据id查询队伍信息")
    public ResponseModel<FireTeam> selectById(HttpServletRequest request, Long id) {
        return ResponseHelper.buildResponse(iFireTeamService.getFireTeamBySequenceNbr(id));
    }


    /**
     * 跑马灯
     *
     * @param
     * @return
     */
    @TycloudOperation( needAuth = true,ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/seismometeorology", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "跑马灯", notes = "跑马灯")
    public ResponseModel<Object> seismometeorology()throws Exception {
        RequestData requestData = new RequestData();
        requestData.setWhether24(true);
        List<AlertCalledZhDto> list= iAlertCalledService.alertCalledListByAlertStatus(null,null,requestData);
        List<SeismometeorologyDto> li= seismometeorologyDtoDao.findCarStateByWatchSn();
        //数据组装
        for (AlertCalledZhDto alertCalledZhDto : list) {

            StringBuffer st=new StringBuffer();

            String time= DateUtil.formatDate(alertCalledZhDto.getCallTime(),"yyyy-MM-dd HH:mm:ss");

            st.append("【").append(alertCalledZhDto.getAlertType()).append("】").append(" ").append(time).append(" ").append(alertCalledZhDto.getAddress());

            SeismometeorologyDto sto= new SeismometeorologyDto(alertCalledZhDto.getSequenceNbr(), "1", "警情通知", null,alertCalledZhDto.getCallTime(), null, st.toString()) ;
            li.add(sto);
            }
       return ResponseHelper.buildResponse(li);
    }



    /**
     * 根据id指令
     *
     * @param id
     * @return
     */
    @TycloudOperation( needAuth = true,ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "ZL/{id}", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "根据警情id查询指令信息", notes = "根据警情id查询指令信息")
    public ResponseModel<List<InstructionsZHDto>> selectZL(@PathVariable Long id) {
        return ResponseHelper.buildResponse(alertSubmittedService.getInstructionsZHDtoList(id));
    }


    @TycloudOperation( needAuth = true, ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/gwmcDataDictionary/FireChemical/{type}", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "根据字典类型查询危险品字典", notes = "根据字典类型查询危险品字典")
    public ResponseModel<Object> gwmcDataDictionaryFireChemical(@PathVariable String type) throws Exception {
       Object list = dataDictionaryService.getFireChemical(type);
         return ResponseHelper.buildResponse(list);
     }

    @TycloudOperation( needAuth = true,ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/page")
    @ApiOperation(httpMethod = "GET", value = "危化品分页查询", notes = "危化品分页查询")
    public ResponseModel<Page<FireChemicalDto>> queryForPage(@RequestParam(value = "pageNum") int pageNum,
                                                             @RequestParam(value = "pageSize") int pageSize, String casNo,
                                                             String formula, String name, String typeCode) {
        Page<FireChemicalDto> page = new Page<FireChemicalDto>();
        page.setCurrent(pageNum);
        page.setSize(pageSize);
        boolean isDelete = false;
        return ResponseHelper.buildResponse(fireChemicalService.queryForFireChemicalPage(page, casNo, formula,
                name, typeCode, isDelete));
    }


    @TycloudOperation( needAuth = true, ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/gwmcDataDictionary/{type}", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "根据字典类型查询字典", notes = "根据字典类型查询字典")
    public ResponseModel<Object> gwmcDataDictionary(@PathVariable String type) throws Exception {

        Object list = dataDictionaryService.gwmcDataDictionary(type);
        return ResponseHelper.buildResponse(list);

    }

    @TycloudOperation( needAuth = true,ApiLevel = UserType.AGENCY)
    @GetMapping(value = "fireExperts/page")
    @ApiOperation(httpMethod = "GET", value = "外部专家分页查询", notes = "外部专家分页查询")
    public ResponseModel<IPage<FireExpertsDto>> queryForPage(@RequestParam(value = "pageNum") int pageNum,
                                                             @RequestParam(value = "pageSize") int pageSize,
                                                             FireExpertsDto fireExpertsDto) {
        Page<FireExpertsDto> page = new Page<>();
        page.setCurrent(pageNum);
        page.setSize(pageSize);
         Page<FireExpertsDto> fireExpertsDtoPage = fireExpertsService.queryForFireExpertsPage(page, false,
                fireExpertsDto.getName(), fireExpertsDto.getExpertCode());
        return ResponseHelper.buildResponse(fireExpertsDtoPage);
    }


    @TycloudOperation( needAuth = true,ApiLevel = UserType.AGENCY)
    @GetMapping(value = "LinkageUnitDto/page")
    @ApiOperation(httpMethod = "GET", value = "联动单位分页查询", notes = "联动单位分页查询")
    public ResponseModel<Page<LinkageUnitDto>> LinkageUnitDtoQueryForPage(@RequestParam(value = "pageNum") int pageNum, @RequestParam(value = "pageSize") int pageSize,String unitName,String linkageUnitTypeCode, String linkageUnitType, String inAgreement) {
        Page<LinkageUnitDto> page = new Page<LinkageUnitDto>();
        page.setCurrent(pageNum);
        page.setSize(pageSize);
        Page<LinkageUnitDto> linkageUnitDtoPage = iLinkageUnitService.queryForLinkageUnitPage(page, false, unitName,linkageUnitTypeCode, linkageUnitType, null, inAgreement);
        return ResponseHelper.buildResponse(linkageUnitDtoPage);
    }

    
    
    @TycloudOperation( needAuth = true, ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/getFirefighters", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "内部专家列表分页查询", notes = "内部专家列表分页查询")
    public ResponseModel<Page<FirefightersZhDto>> getFirefighters(Integer pageNum, Integer pageSize,
                                                             FirefightersDto firefighters) {   	
    	if(firefighters.getAreasExpertiseCode()==null) {
    		firefighters.setAreasExpertiseCode("0");
    	}  	
        //条件分页
        if (null == pageNum || null == pageSize) {
            pageNum = 1;
            pageSize = Integer.MAX_VALUE;
        }
        List<FirefightersZhDto> list = firefightersService.getFirefighters((pageNum - 1) * pageSize, pageSize,
                firefighters);
        Map<String, Long> num = firefightersService.getFirefightersCount((pageNum - 1) * pageSize, pageSize,
                firefighters);
        Page<FirefightersZhDto> pageBean = new Page<>(pageNum, pageSize, num.get("num"));
        pageBean.setRecords(list);
        return ResponseHelper.buildResponse(pageBean);
    }
    
    
    /**
    *
    * 火灾现场统计
    *
    * **/

   @TycloudOperation( needAuth = true, ApiLevel = UserType.AGENCY)
   @GetMapping(value = "statistics/{id}")
   @ApiOperation(httpMethod = "GET", value = "火灾现场统计", notes = "火灾现场统计")
   public ResponseModel<Object> getStatistics(@PathVariable Long id) {
       return ResponseHelper.buildResponse(iAlertCalledService.selectAlertCalledcount(id));
   }
    /**
     * * @param null
     * @return
     * <PRE>
     * author tw
     * date 2021/7/22
     * </PRE>
     * 到场力量统计
     */
    @TycloudOperation( needAuth = true, ApiLevel = UserType.AGENCY)
    @GetMapping(value = "getpower/{id}")
    @ApiOperation(httpMethod = "GET", value = "到场力量统计", notes = "到场力量统计")
    public ResponseModel<Object> getpower(@PathVariable Long id) {
        return ResponseHelper.buildResponse(iAlertCalledService.powercount(id));
    }
   
    /**
     * * @param null
     * @return
     * <PRE>
     * author tw
     * date 2021/7/22
     * </PRE>
     * 到场力量统计列表
     */
    @TycloudOperation( needAuth = true, ApiLevel = UserType.AGENCY)
    @GetMapping(value = "getPowerDataList/{id}")
    @ApiOperation(httpMethod = "GET", value = "到场力量统计列表", notes = "到场力量统计列表")
    public ResponseModel<Object> getPowerDataList(@PathVariable Long id) {
        return ResponseHelper.buildResponse(iAlertCalledService.getPowerDataList(id));
    }

    /**
     *
     * 力量统计当前灾情阶段
     *
     * */
    @TycloudOperation( needAuth = true, ApiLevel = UserType.AGENCY)
    @GetMapping(value = "getstate/{id}")
    @ApiOperation(httpMethod = "GET", value = "获取灾情当前阶段", notes = "获取灾情当前阶段")
    public ResponseModel<Object> getstate(@PathVariable Long id) {
        AlertCalled AlertCalled=iAlertCalledService.getAlertCalledById(id);
        List<StateDot> list=new ArrayList<>();
        list.add(new StateDot("警情接报"));
        list.add(new StateDot("力量调派"));
        list.add(new StateDot("值班确警"));
        list.add(new StateDot("处置跟踪"));
        list.add(new StateDot("处置结束"));
        list.stream().forEach(stateDot->{
            if(AlertCalled.getAlertStage().equals(stateDot.getName())){
                stateDot.setFlag(true);
            }
        });
        return ResponseHelper.buildResponse(list);
    }

    /**
     * * @param null
     * @return
     * <PRE>
     * author tw
     * date 2021/7/22
     * </PRE>
     * 到场力量 列表统计
     */
    @TycloudOperation( needAuth = true, ApiLevel = UserType.AGENCY)
    @GetMapping(value = "getPowerCompanyCountDtocount/{id}")
    @ApiOperation(httpMethod = "GET", value = "到场力量 列表统计", notes = "到场力量 列表统计")
    public ResponseModel<Object> getPowerCompanyCountDtocount(@PathVariable Long id) {
        return ResponseHelper.buildResponse(powerTransferService.getPowerCompanyCountDtocount(id));
    }


    @TycloudOperation( needAuth = true, ApiLevel = UserType.AGENCY)
    @GetMapping(value = "currentPermissionTree")
    @ApiOperation(httpMethod = "GET", value = "用户菜单", notes = "用户菜单")
    public ResponseModel<List<PermissionModelDto>> currentPermissionTree() {
        //获取用户app 菜单
        List<PermissionModelDto>  list= remoteSecurityService.currentPermissionTree();
        List<PermissionModelDto>  listdate= getHomePermissionModel(list);
        getPermissionModel(listdate);
        return ResponseHelper.buildResponse(listdate);
    }

    public List<PermissionModelDto>   getHomePermissionModel(List<PermissionModelDto> list) {
        if(list!=null && !list.isEmpty()){
            for (PermissionModelDto itme : list) {
                if("Home".equals(itme.getFrontComponent())){
                    String userStr = JSON.toJSONString(itme.getChildren());
                    List<PermissionModelDto> userList = JSON.parseArray(userStr, PermissionModelDto.class);
                    return userList;
                }
                if(itme.getChildren()!=null&&!itme.getChildren().isEmpty()){
                    String userStr = JSON.toJSONString(itme.getChildren());
                    List<PermissionModelDto> userList = JSON.parseArray(userStr, PermissionModelDto.class);
                    return  getHomePermissionModel(userList);
                }
            }

        }
        return null;
    }


     public void  getPermissionModel(List<PermissionModelDto> list) {
         if(list!=null && !list.isEmpty()){
             list.forEach(itme->{
                 HomePageEnum homePageEnum=  HomePageEnum.statOf(itme.getFrontComponent());
                   if(itme.getFrontComponent()!=null&&homePageEnum !=null){
                       try {
                           Class clz = Class.forName(homePageEnum.getUrl());
                           Object entity = clz.newInstance();
                           Method repay1 = clz.getDeclaredMethod("getHomePageData");
                           Object value = repay1.invoke(entity);
                           itme.setValue(value!=null?Double.valueOf(value.toString()):0);
                           if(itme.getChildren()!=null&&!itme.getChildren().isEmpty()){
                               String userStr = JSON.toJSONString(itme.getChildren());
                               List<PermissionModelDto> userList = JSON.parseArray(userStr, PermissionModelDto.class);
                               getPermissionModel(userList);
                               itme.setChildren(userList);
                           }
                       } catch (Exception e) {
                           e.printStackTrace();
                       }
                   }else{
                       if(itme.getChildren()!=null&&!itme.getChildren().isEmpty()){
                           String userStr = JSON.toJSONString(itme.getChildren());
                           List<PermissionModelDto> userList = JSON.parseArray(userStr, PermissionModelDto.class);
                           getPermissionModel(userList);
                           itme.setChildren(userList);
                       }
                   }
             });
         }
     }


    /**
	 * 
	 * 	 
	 * @return
	 */
    @TycloudOperation( needAuth = false, ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/lookHtmlText")
	@ApiOperation(value = "查看文件内容", notes = "查看文件内容")
	public ResponseModel<Object> lookHtmlText( HttpServletResponse response,@RequestParam(value = "fileUrl")String fileUrl ,@RequestParam(value = "product")String product,@RequestParam(value = "appKey")String appKey,@RequestParam(value = "token")String token /* @PathVariable String fileName */)
			throws Exception {		
			String  fileName =readUrl+fileUrl; //目标文件
		 if (fileName.endsWith(".doc") || fileName.endsWith(".docx")) {
			String htmlPath= System.getProperty("user.dir")+File.separator+"lookHtml"+File.separator+"file"+File.separator;
			String imagePathStr= System.getProperty("user.dir")+File.separator+"lookHtml"+File.separator+"image"+File.separator;
			String name = fileUrl.substring(fileUrl.lastIndexOf('/')+1);
			String htmlFileName = htmlPath + name.substring(0, name.indexOf(".")) +".html";
			File htmlP = new File(htmlPath);
   			if (!htmlP.exists()) {
   				htmlP.mkdirs();
   			}
			File htmlFile = new File(htmlFileName);			
			WordConverterUtils.wordToHtml(fileName, htmlFileName,  imagePathStr,readUrl, remoteSecurityService,product, appKey, token);
			FileInputStream fis = new FileInputStream(htmlFile);					
//			response.setContentType("multipart/form-data");
//			response.setCharacterEncoding("UTF-8");
//			response.setContentType("text/html");
			ServletOutputStream out;
			out = response.getOutputStream();
			int b = 0;
			byte[] buffer = new byte[1024];
			while ((b = fis.read(buffer)) != -1) {
				// 4.写到输出流(out)中
				out.write(buffer, 0, b);
			}
			fis.close();
			out.flush();
			out.close();			
			return ResponseHelper.buildResponse("");
		} else {
			return null;
		}

	}

    /**
     * 根据sequenceNbr查询
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "GET", value = "根据灾情查询单个航空器信息", notes = "根据灾情查询单个航空器信息")
    public ResponseModel<AircraftDto> seleteaircraftOne(@PathVariable Long sequenceNbr) {
    	// 警情动态表单数据
    			List<AlertFormValue> list = alertFormValueService.getzqlist(sequenceNbr);
    			for (AlertFormValue alertFormValue : list) {
    				if("aircraftModel".equals(alertFormValue.getFieldCode())) {
    					String  aircraftModel=alertFormValue.getFieldValue();
    					if(aircraftModel!=null&&!"".equals(aircraftModel)) {
    						AircraftDto aircraftDto=aircraftService.queryByAircraftSeq(RequestContext.getAgencyCode(),1411994005943717890L);
    						//现场照片 待完成，
    						return	ResponseHelper.buildResponse(aircraftDto);
    					}
    				}
    			}
        return ResponseHelper.buildResponse(null);
    }

    @TycloudOperation( needAuth = true, ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/getOrgUsrzhDto/{id}")
    @ApiOperation(httpMethod = "GET", value = "根据灾情id处置对象单位详情", notes = "根据灾情id处置对象单位详情")
    public ResponseModel<OrgusrDataxDto> getOrgUsrzhDto(@PathVariable Long id) {
        AlertCalled AlertCalled = iAlertCalledService.getAlertCalledById(id);
        String buildId = null;
        OrgusrDataxDto orgusrDataxDto = new OrgusrDataxDto();
        if (AlertCalled.getUnitInvolved() != null && !"".equals(AlertCalled.getUnitInvolved())) {
            List<OrgUsrzhDto> orgUsrzhDto = iOrgUsrService.getOrgUsrzhDto(AlertCalled.getUnitInvolved());
            orgusrDataxDto.setOrgUsrzhDto(orgUsrzhDto != null && orgUsrzhDto.size() > 0 ? orgUsrzhDto.get(0) : null);
            if (orgUsrzhDto != null && orgUsrzhDto.size() > 0 && orgUsrzhDto.get(0) != null) {
                buildId = orgUsrzhDto.get(0).getBuildId();
            }
        }
       if (buildId != null) {
            List<Map<String, Object>> list = equipFeignClient.findImgByFileCategory(buildId, "fourImg").getResult();
            List<String> url = new ArrayList<>();
            if (list != null && list.size() > 0) {
                list.stream().forEach(map -> {
                    url.add(map.get("filePath").toString());
                });
            }

            //通道
            List<Map<String, Object>> list1 = equipFeignClient.findImgByFileCategory(buildId, "secondImg").getResult();
            List<String> url1 = new ArrayList<>();
            if (list1 != null && list1.size() > 0) {
                list1.stream().forEach(map -> {
                    url1.add(map.get("filePath").toString());
                });
            }
            //立面
            List<Map<String, Object>> list2 = equipFeignClient.findImgByFileCategory(buildId, "threeImg").getResult();
            List<String> url2 = new ArrayList<>();
            if (list2 != null && list2.size() > 0) {
                list2.stream().forEach(map -> {
                    url2.add(map.get("filePath").toString());
                });
            }
            orgusrDataxDto.setPlanePicture(url);
            orgusrDataxDto.setScenePicture(url1);
            orgusrDataxDto.setFacadePicture(url2);
        }
        return ResponseHelper.buildResponse(orgusrDataxDto);
    }





    @TycloudOperation( needAuth = true, ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/AlertCalledcountTime")
    @ApiOperation(httpMethod = "GET", value = "执勤动态警情信息统计", notes = "执勤动态警情信息统计")
    public ResponseModel<Object> AlertCalledcountTime() {
        List<KeyValueLabel> listdate =new ArrayList<>();
        listdate.add(new KeyValueLabel("今年警情数量","",iAlertCalledService.AlertCalledcountTime(1)));
        listdate.add(new KeyValueLabel("当月警情数量","",iAlertCalledService.AlertCalledcountTime(2)));
        listdate.add(new KeyValueLabel("昨天警情数量","",iAlertCalledService.AlertCalledcountTime(4)));
        listdate.add(new KeyValueLabel("今天警情数量","",iAlertCalledService.AlertCalledcountTime(3)));
        return ResponseHelper.buildResponse(listdate);
    }


    @TycloudOperation( needAuth = true, ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/getTodayPowerTransferCompany")
    @ApiOperation(httpMethod = "GET", value = "当天力量调派", notes = "当天力量调派")
    public ResponseModel<Object> getTodayPowerTransferCompany() {
        return ResponseHelper.buildResponse(powerTransferCompanyService.getTodayPowerTransferCompany());
    }

    @TycloudOperation( needAuth = true, ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/getTodayAlertCalled")
    @ApiOperation(httpMethod = "GET", value = "当天接警记录", notes = "当天接警记录")
    public ResponseModel<Object> getTodayAlertCalled() {
        return ResponseHelper.buildResponse(iAlertCalledService.getTodayAlertCalled());
    }

    @TycloudOperation( needAuth = true, ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/getFireTeamCountList")
    @ApiOperation(httpMethod = "GET", value = "执勤力量", notes = "执勤力量")
    public ResponseModel<Object> getFireTeamCountList() {
        return ResponseHelper.buildResponse(iFireTeamService.getFireTeamCountList());
    }

    @TycloudOperation(needAuth = true,ApiLevel = UserType.AGENCY)
    @ApiOperation("当天值班人信息列表")
    @GetMapping("/getonDuty/list")
    public ResponseModel listOnDutyPerson() {
        return ResponseHelper.buildResponse(iDutyPersonService.listOnDutyPerson());
    }

    /**
     * 跑马灯
     *
     * @param
     * @return
     */
    @TycloudOperation( needAuth = true,ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/findDutyCarStateBy", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "当日气象预警", notes = "当日气象预警")
    public ResponseModel<Object> findDutyCarStateBy()throws Exception {
        List<SeismometeorologyDto> li= seismometeorologyDtoDao.findDutyCarStateBy();
        return ResponseHelper.buildResponse(li);
    }

    /**
     * 分页获取视频
     *
     * @param
     * @return
     */
    @TycloudOperation( needAuth = true,ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/getVideo", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "分页获取视频", notes = "分页获取视频")
    public ResponseModel<Object> getVideo(long current, long size)throws Exception {
        Page page = new Page(current,  size);
        List<OrderItem>  list= OrderItem.ascs("id");
        page.setOrders(list);
        ResponseModel<Page<Map<String, Object>>>  data= equipFeignClient.getVideo(current,size,0l);

        Page<Map<String, Object>>  pag=  data!=null?data.getResult():null;
        List<Map<String, Object>> records =pag!=null?pag.getRecords():null;
        if(records!=null&&records.size()>0){
            for (Map<String, Object> record : records) {
                ResponseModel<String> da=videoFeignClient.videoUrlByIndexCode(record.get("code")+"");
                String url=  da!=null?da.getResult().substring(da.getResult().indexOf("openUrl")):null;
                record.put("url",url);
            }
            pag.setRecords(records);
        }
        return ResponseHelper.buildResponse(pag);
    }

    
    
    
    @TycloudOperation( needAuth = true, ApiLevel = UserType.AGENCY)
    @GetMapping(value = "fireCar/list")
    @ApiOperation(httpMethod = "GET", value = "车辆资源", notes = "车辆资源")
    public ResponseModel<Object> getTeamCarList(RequestData par) {
/*bug 2583 地图屏，消防车辆类型时，左侧车辆状态显示错误 陈召 开始 */
      ResponseModel<List<Map<String, Object>>> date= equipFeignClient.getTeamCarList(par.getLongitude(),par.getLatitude());
        List<Map<String, Object>> result = date.getResult();
        QueryWrapper<PowerTransferCompanyResources> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("status", FireCarStatusEnum.执行中.getCode() );
        List<PowerTransferCompanyResources> alertFormValue = powerTransferCompanyResourcesMapper.selectList(queryWrapper);
        result.stream().forEach(e->{
            if (e.get("carState").equals("在位")){
                e.put("carState",FireCarStatusEnum.执勤.getName());
            }
            String sequenceNbr = e.get("sequenceNbr").toString();
            //同步力量调派车辆任务状态
            alertFormValue.stream().forEach(v->{
                if (v.getResourcesId().equals(sequenceNbr)) {
                    String carStatus = v.getCarStatus();
                    e.put("carState",carStatus!=null?FireCarStatusEnum.getEnum(carStatus).getName():null);
                }
            });
        });
        return ResponseHelper.buildResponse(date!=null?date.getResult():null);
        /*bug 2583 地图屏，消防车辆类型时，左侧车辆状态显示错误 2021-10-26 陈召 结束 */
    }

    @TycloudOperation( needAuth = true, ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/fireCar")
    @ApiOperation(httpMethod = "GET", value = "车辆资源详情", notes = "车辆资源详情")
    public ResponseModel<Map<String,Object>> getCarDetailById(Long id ) {
    	ResponseModel<Map<String, Object>> date= equipFeignClient.getCarDetailById(id);
        return ResponseHelper.buildResponse(date!=null?date.getResult():null);
    }




//    @TycloudOperation( needAuth = true, ApiLevel = UserType.AGENCY)
//    @GetMapping(value = "/testPostApi")
//    @ApiOperation(httpMethod = "GET", value = "视频地址", notes = "视频地址")
//    public Object testPost(Integer pageNum, Integer pageSize) throws URISyntaxException {
//        RestTemplate restTemplate = new RestTemplate();
//        URI uri = new URI(videoUrl+"artemis/api/resource/v1/camera/advance/cameraList");
//        HttpHeaders headers = new HttpHeaders();
////        headers.add("Authorization", "APPCODE " + appCode);
//        //添加参数,因为HttpEntity里面的参数是MultiValueMap类型的，所以使用这个map集合
//        MultiValueMap<String, Object> map = new LinkedMultiValueMap<>();
//        map.add("pageSize", 100);
//        map.add("pageNo", 1);
//        //添加请求的实体类，这里第一个参数是要发送的参数，第二个参数是请求头里的数据
//        HttpEntity<Object> requestEntity = new HttpEntity<Object>(map, headers);
//        ResponseEntity<String> exchange = restTemplate.exchange(uri, HttpMethod.POST, requestEntity, String.class);
//        JSONObject jsonObject = JSON.parseObject(exchange.getBody());
//        System.out.println(jsonObject);
//        return jsonObject;
//
//    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET",value = "根据灾情id建筑部位树",   notes = "根据灾情id建筑部位树")
    @GetMapping(value = "/getBuildTree/{id}")
    public  ResponseModel<List<OrgMenuDto>> getBuildTree(@PathVariable Long id) throws Exception{

        AlertCalled AlertCalled=iAlertCalledService.getAlertCalledById(id);
        Long buildId=null;
        String buildIdName="";
        Long zdid=null;
        String zdname="";
        OrgusrDataxDto orgusrDataxDto=new OrgusrDataxDto();
        if(AlertCalled.getUnitInvolved()!=null&&!"".equals(AlertCalled.getUnitInvolved())) {
            List<OrgUsrzhDto> orgUsrzhDto= iOrgUsrService.getOrgUsrzhDto( AlertCalled.getUnitInvolved());
            if(orgUsrzhDto!=null&&orgUsrzhDto.size()>0&&orgUsrzhDto.get(0)!=null){
                buildId=orgUsrzhDto.get(0).getBuildId()==null?null:Long.valueOf(orgUsrzhDto.get(0).getBuildId());
                buildIdName=orgUsrzhDto.get(0).getBuildId()==null?null:orgUsrzhDto.get(0).getBuildName();
            }
        }


        // 警情动态表单数据
        List<KeyValueLabel> listdate = new ArrayList<>();
        List<AlertFormValue> list = buildId==null?null:iAlertFormValueService.getzqlist(id);
        if (list != null && list.size() > 0) {
            for (AlertFormValue alertFormValue : list) {
               if("keySiteExcle".equals(alertFormValue.getFieldCode())&&alertFormValue.getFieldValue()!=null){
                   List<OrgMenuDto> list1 = new ArrayList<OrgMenuDto>();
                   List<OrgMenuDto> children = new ArrayList<OrgMenuDto>();
                   OrgMenuDto date= new OrgMenuDto( Long.valueOf(alertFormValue.getFieldValueCode()),  Long.valueOf(alertFormValue.getFieldValueCode()),  alertFormValue.getFieldValue(),  alertFormValue.getFieldValue(),null);
                   children.add(date);
                   OrgMenuDto orgMenuDto =new OrgMenuDto();
                   orgMenuDto.setKey(buildId);
                   orgMenuDto.setValue(buildId);
                   orgMenuDto.setChildren(children);
                   orgMenuDto.setName(buildIdName);
                   orgMenuDto.setTitle(buildIdName);
                   list1.add(orgMenuDto);
                   return ResponseHelper.buildResponse(list1);
               }
            }
        }
            return ResponseHelper.buildResponse(buildId==null?null:keySiteService.getBuildAndKeyTree(buildId));
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET",value = "根据重点部位id查询详情",   notes = "根据重点部位id查询详情")
    @GetMapping(value = "/getkeySite/{sequenceNbr}")
    public ResponseModel<KeySiteDto> getkeySite(@PathVariable Long sequenceNbr) {
        Map<String, List<AttachmentDto>> files = sourceFileService.getAttachments(sequenceNbr);
        KeySiteDto dto=  keySiteService.getSequenceNbr(sequenceNbr);
        List<String> list = new ArrayList<String>();
        if(files!=null && dto!=null) {
            if(files!=null && dto!=null) {
                dto.setAttachments(files);
                JSONArray array=	JSONArray.parseArray(JSONArray.toJSONString(files.get("keySitePhoto")));
                if(array!=null &&array.size()>0) {
                    for(Object i :array) {
                        JSONObject object = JSONObject.parseObject(JSONObject.toJSONString(i));
                        list.add(object.getString("url"));
                    }
                }
            }
            dto.setAttachmentsList(list);
        }
        return ResponseHelper.buildResponse(dto);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET",value = "app-根据警情id查询力量调派列表",   notes = "app-根据警情id查询力量调派列表")
    @GetMapping(value = "/app/transferList")
    public ResponseModel getPowerTransferList(@RequestParam String alertId,@RequestParam(defaultValue = "team") String type, @RequestParam(value = "current") int current, @RequestParam(value = "size") int size) {
        Page page = new Page();
        page.setSize(size);
        page.setCurrent(current);
        return ResponseHelper.buildResponse(powerTransferService.getPowerTransferPageByParam(Long.valueOf(alertId), type, page));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET",value = "app-根据警情id查询力量调派资源统计",   notes = "app-根据警情id查询力量调派资源统计")
    @GetMapping(value = "/app/transfer/statistics")
    public ResponseModel getPowerTransferStatistics(@RequestParam String alertId,  @RequestParam(defaultValue = "team") String type) {
        return ResponseHelper.buildResponse(powerTransferService.getPowerTransferStatistics(Long.valueOf(alertId), type));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "PUT", value = "app-更新车辆状态", notes = "app-更新车辆状态")
    @PutMapping(value = "/app/carStatus")
    public ResponseModel<Boolean> updateCarStatus(@RequestParam String carId, @RequestParam String carStatus) {
        CarStatusInfoDto carStatusInfoDto = new CarStatusInfoDto();
        carStatusInfoDto.setSequenceNbr(carId);
        carStatusInfoDto.setStatus(carStatus);
        try {
            equipFeignClient.updateCarStatus(Lists.newArrayList(carStatusInfoDto));
        } catch (Exception e) {
            throw new BaseException("更新车辆状态异常", "", e.getMessage());
        }
        return ResponseHelper.buildResponse(true);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "app-警情详情-处置对象", notes = "app-警情详情-处置对象")
    @GetMapping(value = "/app/disposalObject")
    public ResponseModel<List<JSONObject>> queryDisposalObject(@RequestParam String alertId) {
        List<JSONObject> resultList;
        try {
            resultList = iAlertCalledService.queryDisposalObjectList(alertId);
        } catch (Exception e) {
            throw new BaseException("获取处置对象异常", "", e.getMessage());
        }
        return ResponseHelper.buildResponse(resultList);
    }

    /**
     * app-根据id查询警情详情
     **/
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "alertCalled/{id}")
    @ApiOperation(httpMethod = "GET", value = "app-根据id查询灾情详情", notes = "app-根据id查询灾情详情")
    public ResponseModel<Object> selectByAlertCalledId(@PathVariable Long id) {
        return ResponseHelper.buildResponse(iAlertCalledService.queryAlertCalledById(id));
    }

    /**
     * app-根据id查询警情力量统计
     **/
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "alertCalled/statistics/{alertId}")
    @ApiOperation(httpMethod = "GET", value = "app-根据id查询警情力量统计", notes = "app-根据id查询警情力量统计")
    public ResponseModel<Object> statisticsByAlertCalledId(@PathVariable Long alertId) {
        return ResponseHelper.buildResponse(powerTransferService.getPowerTransferCarResourceStatistics(alertId));
    }

    /**
     * app-车辆状态列表
     **/
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/app/carStatus/list")
    @ApiOperation(httpMethod = "GET", value = "app-车辆状态列表", notes = "app-车辆状态列表")
    public ResponseModel<Object> carStatusList() {
        return ResponseHelper.buildResponse(powerTransferService.getFireCarStatusList());
    }

    /**
     * app-调派任务状态列表
     **/
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/app/dispatchTaskStatus/list")
    @ApiOperation(httpMethod = "GET", value = "app-调派任务状态列表", notes = "app-调派任务状态列表")
    public ResponseModel<Object> powerTransferResourceStatusList() {
        return ResponseHelper.buildResponse(powerTransferService.getDispatchTaskStatusList());
    }

    /**
     * app-当前登陆人是否是驾驶员
     **/
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/app/personPost")
    @ApiOperation(httpMethod = "GET", value = "app-当前登陆人是否是驾驶员", notes = "app-当前登陆人是否是驾驶员")
    public ResponseModel<Object> isFireCarDriver() {
        return ResponseHelper.buildResponse(iDutyCarService.isFireCarDriver());
    }



    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/DynamicFlightInfo/{dynamicFlightId}")
    @ApiOperation(httpMethod = "GET", value = "航班信息", notes = "航班信息")
    public ResponseModel<Object> DynamicFlightInfo(@PathVariable String dynamicFlightId) {
        ResponseModel<Object> dataModel = iotFeignClient.DynamicFlightInfo(dynamicFlightId);
        if (dataModel != null) {
            return ResponseHelper.buildResponse(dataModel.getResult());
        }
        return ResponseHelper.buildResponse(null);
    }



    @TycloudOperation( needAuth = true, ApiLevel = UserType.AGENCY)
    @GetMapping(value = "AlertCalledStatusPage")
    @ApiOperation(httpMethod = "GET", value = "未结束的灾情列表", notes = "未结束的灾情列表")
    public ResponseModel<Page<AlertCalled>> AlertCalledStatusPage(  @RequestParam(value = "current") Integer current, @RequestParam(value = "size") Integer size) {
        if (null == current || null == size) {
            current = 1;
            size = Integer.MAX_VALUE;
        }
        List<AlertCalled>  list= iAlertCalledService.AlertCalledStatusPage( current,  size);
        int num= iAlertCalledService.AlertCalledcount(0);
        Page<AlertCalled> pageBean = new Page<>(current, size, num);
        pageBean.setRecords(list);
        return ResponseHelper.buildResponse(pageBean);
    }





    @TycloudOperation( needAuth = true, ApiLevel = UserType.AGENCY)
    @GetMapping(value = "equipmentCarList")
    @ApiOperation(httpMethod = "GET", value = "车辆列表", notes = "车辆列表")
    public ResponseModel<Object> equipmentCarList(   String name,
                                                     String code ,
                                                     String pageNum,
                                                     String pageSize,
                                                     Boolean isNo ) {
        //获取用户所属单位id
        AgencyUserModel agencyUserModel= getUserInfo();
        Long  teamId=null;
//        Firefighters orgUsr= firefightersService.selectByAmosOrgId(Long.valueOf(agencyUserModel.getUserId()));
//        teamId=orgUsr!=null?Long.valueOf(orgUsr.getFireTeamId()):null;
        Long id =null;
        //获取用户已绑定车辆id、
        UserCar userCar=userCarService.selectByAmosUserId(Long.valueOf(agencyUserModel.getUserId()));
        if(isNo!=null&&isNo){
            id =userCar!=null?userCar.getCarId():null;
        }
        ResponseModel<Object> data=  equipFeignClient.equipmentCarList(teamId,name,code , pageNum,pageSize,id);
        Map map =new HashMap();
        map.put("select",userCar!=null?userCar.getCarId():null);
        map.put("data",data!=null?data.getResult():null);
        return ResponseHelper.buildResponse(map);
    }


    @TycloudOperation( needAuth = true, ApiLevel = UserType.AGENCY)
    @GetMapping(value = "gettree")
    @ApiOperation(httpMethod = "GET", value = "车辆分类", notes = "车辆分类")
    public ResponseModel<Object> gettree(  ) {

        ResponseModel<Object> data=  equipFeignClient.gettree();
        return ResponseHelper.buildResponse(data!=null?data.getResult():null);
    }


    @TycloudOperation( needAuth = true, ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "adduserCar/{type}", produces = "application/json;charset=UTF-8", method = RequestMethod.POST)
    @ApiOperation(httpMethod = "POST", value = "增加绑定", notes = "增加绑定")
    public ResponseModel<Object> adduserCar(@PathVariable String type, @RequestBody  UserCar userCar  ) {
        AgencyUserModel agencyUserModel= getUserInfo();
        userCar.setAmosUserId(Long.valueOf(agencyUserModel.getUserId()));
        userCar.setAmosUserName(agencyUserModel.getUserName());
        if("1".equals(type)){
            userCarService.add(userCar);
        }else{
            userCarService.delete(userCar);
        }
        return ResponseHelper.buildResponse(true);
    }


    @TycloudOperation( needAuth = true, ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "getAlertCalledId", produces = "application/json;charset=UTF-8", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "获取绑定车辆装", notes = "获取绑定车辆装")
    public ResponseModel<UserCar> getAlertCalledId() {
        AgencyUserModel agencyUserModel= getUserInfo();
         Long id =null;
        //获取用户已绑定车辆id、
        UserCar userCar=userCarService.selectByAmosUserId(Long.valueOf(agencyUserModel.getUserId()));
        return ResponseHelper.buildResponse(userCar);


    }

    @TycloudOperation( needAuth = true, ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "getAlertCalledData", produces = "application/json;charset=UTF-8", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "获取当前执行灾情", notes = "获取当前执行灾情")
    public ResponseModel<Object> getAlertCalled() {
        AgencyUserModel agencyUserModel= getUserInfo();
        Long id =null;
        //获取用户已绑定车辆id、
        UserCar userCar=userCarService.selectByAmosUserId(Long.valueOf(agencyUserModel.getUserId()));
        //获取正在进行的灾情null
        if(userCar!=null){
            AlertCalled alertCalled= powerTransferCompanyResourcesService.getByPowerTransferCompanyResourId(userCar.getCarId());
            return ResponseHelper.buildResponse(alertCalled);
        }
        return ResponseHelper.buildResponse(null);
    }


    @TycloudOperation( needAuth = true, ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "getPowerTransferCompanyResourcesService/{carid}/{alertCalledId}", produces = "application/json;charset=UTF-8", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "获取当前任务，车辆状态", notes = "获取当前任务，车辆状态")
    public ResponseModel<Object> getPowerTransferCompanyResourcesService(@PathVariable Long carid,
                                                                            @PathVariable Long alertCalledId) {
        //获取正在进行的灾情
        PowerTransferCompanyResources powerTransferCompanyResources= powerTransferCompanyResourcesService.getByAlertCalledIdCarId(alertCalledId,carid);

        return ResponseHelper.buildResponse(powerTransferCompanyResources);
    }
    @TycloudOperation( needAuth = true, ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "updatePowerTransferCompanyResourcesService", produces = "application/json;charset=UTF-8", method = RequestMethod.POST)
    @ApiOperation(httpMethod = "POST", value = "修改任务，车辆状态", notes = "修改任务，车辆状态")
    public ResponseModel<Object> updatePowerTransferCompanyResourcesService(@RequestBody CarTaskDto carTaskDto) {
        //获取正在进行的灾情
        powerTransferCompanyResourcesService.updatePowerTransferCompanyResourcesService(
                carTaskDto.getAlertCalledId(),
                carTaskDto.getCarid(),
                carTaskDto.getCode(),
                carTaskDto.getType(),
                carTaskDto.getRemarks());
        return ResponseHelper.buildResponse(null);
    }


}