package com.yeejoin.amos.boot.module.common.biz.controller;
import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import java.util.List;
import com.yeejoin.amos.boot.module.common.biz.service.impl.DynamicFormInstanceServiceImpl;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.common.api.dto.DynamicFormInstanceDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;


/**
* 动态表单实例表
*
* @author system_generator
* @date 2021-07-06
*/
@RestController
@Api(tags = "动态表单实例表Api")
@RequestMapping(value = "/common/dynamic-form-instance")
public class DynamicFormInstanceController extends BaseController {

    @Autowired
    DynamicFormInstanceServiceImpl dynamicFormInstanceServiceImpl;

    /**
             * 新增动态表单实例表
    * @return
    */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增动态表单实例表", notes = "新增动态表单实例表")
	public ResponseModel<DynamicFormInstanceDto> save(@RequestBody DynamicFormInstanceDto model)
	{
	    model=dynamicFormInstanceServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}
	/**
             * 根据sequenceNbr更新
    * @param sequenceNbr 主键
    * @return
    */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新动态表单实例表", notes = "根据sequenceNbr更新动态表单实例表")
	public ResponseModel<DynamicFormInstanceDto> updateBySequenceNbrDynamicFormInstance(@RequestBody DynamicFormInstanceDto model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(dynamicFormInstanceServiceImpl.updateWithModel(model));
	}
	/**
             * 根据sequenceNbr删除
    * @param sequenceNbr 主键
    * @return
    */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除动态表单实例表", notes = "根据sequenceNbr删除动态表单实例表")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(dynamicFormInstanceServiceImpl.removeById(sequenceNbr));
    }
    /**
             * 根据sequenceNbr查询
    * @param sequenceNbr  主键
    * @return
    */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个动态表单实例表",  notes = "根据sequenceNbr查询单个动态表单实例表")
	public ResponseModel<DynamicFormInstanceDto> seleteOne(@PathVariable Long sequenceNbr)
	{
	    return ResponseHelper.buildResponse(dynamicFormInstanceServiceImpl.queryBySeq(sequenceNbr));
	}
	/**
             * 列表分页查询
    *@param current 当前页
    *@param current 每页大小
    * @return
    */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "动态表单实例表分页查询",  notes = "动态表单实例表分页查询")
	public ResponseModel<Page<DynamicFormInstanceDto>> queryForPage(@RequestParam(value = "current") int current,@RequestParam(value = "size") int size)
	{
	    Page<DynamicFormInstanceDto> page=new Page<DynamicFormInstanceDto>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(dynamicFormInstanceServiceImpl.queryForDynamicFormInstancePage(page));
	}
	/**
	*列表全部数据查询
	*@return
	*/
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "动态表单实例表列表全部数据查询",   notes = "动态表单实例表列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<DynamicFormInstanceDto>>  selectForList()
	{
	    return ResponseHelper.buildResponse(dynamicFormInstanceServiceImpl.queryForDynamicFormInstanceList());
	}
}
