package com.yeejoin.amos.latentdanger.business.service.intfc;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.bo.RoleBo;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import com.yeejoin.amos.feign.systemctl.model.DictionarieValueModel;
import com.yeejoin.amos.latentdanger.business.dto.DangerExecuteSubmitDto;
import com.yeejoin.amos.latentdanger.business.dto.ExecuteSubmitDto;
import com.yeejoin.amos.latentdanger.business.param.LatentDangerDto;
import com.yeejoin.amos.latentdanger.business.param.LatentDangerExecuteParam;
import com.yeejoin.amos.latentdanger.business.param.LatentDangerListParam;
import com.yeejoin.amos.latentdanger.business.param.PageParam;
import com.yeejoin.amos.latentdanger.business.util.CommonResponse;
import com.yeejoin.amos.latentdanger.business.vo.DangerTimeAxisVo;
import com.yeejoin.amos.latentdanger.business.vo.LatentDangerDetailVo;
import com.yeejoin.amos.latentdanger.core.common.response.DangerListResponse;
import com.yeejoin.amos.latentdanger.dao.entity.LatentDanger;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.List;
import java.util.Map;

/**
 * @author keyong
 * @title: ILatentDangerService
 * <pre>
 * @description: TODO
 * </pre>
 * @date 2021/1/26 14:44
 */
public interface ILatentDangerService {

    CommonResponse saveNormal(LatentDangerDto latentDangerParam, String userId, String userRealName,
                              String departmentId, String departmentName, String companyId, String orgCode, RoleBo role);

    List<LatentDanger> savePatrol(List<LatentDangerDto> latentDangerDtoList, String userId, String userRealName,
                                                    String departmentId, String departmentName, String companyId, String orgCode, RoleBo role) throws Exception;

    CommonResponse list(String toke, String product, String appKey, LatentDangerListParam latentDangerListParam, AgencyUserModel user, String loginOrgCode, String deptId);

    /**
     * 隐患流程执行
     *
     * @param latentDangerExecuteParam
     * @param userId
     * @param userRealName
     * @param departmentId
     * @param departmentName
     * @param role
     * @return
     */
    DangerExecuteSubmitDto execute(LatentDangerExecuteParam latentDangerExecuteParam, String userId,
                                   String userRealName, String departmentId, String departmentName, ReginParams reginParams) throws Exception;

    ResponseModel<LatentDangerDetailVo> detail(Long dangerId, String userId, boolean isFinish) throws Exception;

    CommonResponse getByInstanceId(String instanceId);

    DangerExecuteSubmitDto executeCallBack(String instanceId, Integer actionType, String remark, String token, String userId,
                                           String userRealName, String departmentId, String departmentName);

    void updateDangerStateOfOvertime();

    LatentDangerDetailVo listFlowRecord(String token, String product, String appKey, Long id) throws Exception;

    void sendLatentDangerExecuteResult(DangerExecuteSubmitDto executeSubmitDto);

    void freshRiskJudgmentLangerCount(LatentDangerExecuteParam latentDangerExecuteParam);

    /**
     * 获取隐患等级字典值
     *
     * @return
     */
    List<DictionarieValueModel> getDangerLevel();

    /**
     * 获取隐患治理方式字典值
     *
     * @return
     */
    List<DictionarieValueModel> getDangerGovernance();

//    /**
//     * 根据等级字符串获取等级字典对象
//     *
//     * @param dangerLevelStr 等级（"1","2","0"）
//     * @return
//     */
//    JSONObject getDangerLevelJsonObject(String dangerLevelStr, String token, String product, String appKey, String dictCode);

    /**
     * 根据隐患id获取评审信息
     *
     * @param dangerId
     * @return
     */
    JSONObject getReviewInfo(Long dangerId);

    IPage<LatentDanger> pageListDanger(PageParam pageParam) throws Exception;

    List<DangerListResponse> export(PageParam pageParam);

    List<DangerTimeAxisVo> queryExecuteLog(Integer dateTime);

    /**
     * 查询所有隐患列表
     *
     * @param searchParam
     * @return
     */
    List<LatentDanger> listAllDanger(LatentDangerListParam searchParam);

    /**
     * 根据ids(逗号分割)删除隐患
     *
     * @param ids
     * @return
     */
    Boolean delete(String ids) throws Exception;

    /**
     * 获取隐患状态
     *
     * @return
     */
    List<Map<String, String>> getDangerState();

    /**
     * 隐患审核
     *
     * @return
     * @param latentDangerDto
     * @param executeType 执行类型(通过0、驳回1)
     * @exception Exception
     */
    ExecuteSubmitDto dangerAudit(LatentDangerDto latentDangerDto, Integer executeType, String userId, String userName,
                                 String deptId, String deptName, ReginParams reginParams) throws Exception;

    /**
     * 防火监督-隐患审核分页查询
     *
     * @param pageParam
     * @return
     */
    IPage<LatentDanger> reviewListDanger(PageParam pageParam) throws Exception;

    /**
     * 获取多个业务的隐患等级
     *
     * @return
     */
    List<Map<String, String>> getAllDangerLevel();

    /**
     * 获取多个业务的隐患治理方式
     *
     * @return
     */
    List<Map<String, String>> getAllDangerGovernance();

    /**
     * 获取所有隐患治理进度
     * @return
     */
    List<Map<String, String>> getAllDangerState();

    /**
     * 获取所有未完成的隐患数量
     *
     * @return
     */
    Integer getUnFinishedDangerCount();
}
