package com.yeejoin.amos.supervision.common.enums;


public enum ExecuteStateEnum {

    未执行("未执行", 1, ""),
    通过("通过", 2, "{\"action\": \"complete\",\"variables\": [{\"name\": \"rejected\",\"value\": false}]}"),
    驳回("驳回", 3, "{\"action\": \"complete\",\"variables\": [{\"name\": \"rejected\",\"value\": true}]}"),
    已确认("已确认", 4, ""),
    停止执行("停止执行", 5, ""),
    作业开始执行("作业开始执行", 6, ""),
    作业完成("作业完成", 7, "");

    /**
     * 名称，描述
     */
    private String name;
    /**
     * 编码
     */
    private Integer code;

    private String requestBody;

    ExecuteStateEnum(String name, Integer code, String requestBody) {
        this.name = name;
        this.code = code;
        this.requestBody = requestBody;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getRequestBody() {
        return requestBody;
    }

    public void setRequestBody(String requestBody) {
        this.requestBody = requestBody;
    }

    public static ExecuteStateEnum getByCode(Integer code) {
        for (ExecuteStateEnum e : ExecuteStateEnum.values()) {
            if (code.equals(e.getCode())) {
                return e;
            }
        }
        return null;
    }
}
