package com.yeejoin.amos.boot.module.common.api.dto;

import com.google.common.collect.Lists;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * 消防队伍下资源dto
 *
 * @author DELL
 */
@Data
public class FireBrigadeResourceDto extends BaseDto {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "资源id")
    private String id;

    @ApiModelProperty(value = "资源名称")
    private String name;

    @ApiModelProperty(value = "资源图片")
    private List<String> image;


    /*2403 队伍未显示图片 陈召 2021-09-23*/
    private String pic;

    @ApiModelProperty(value = "资源类型")
    private String type;

    @ApiModelProperty(value = "所属队伍id")
    private String teamId;

    @ApiModelProperty(value = "所属队伍名称")
    private String teamName;

    @ApiModelProperty(value = "车辆牌号")
    private String carNum;

    @ApiModelProperty(value = "车辆状态code")
    private String carState;

    @ApiModelProperty(value = "车辆状态描述")
    private String carStateDesc;

    @ApiModelProperty(value = "队伍下人员数量")
    private int personCount;

    @ApiModelProperty(value = "车辆类型")
    private String categoryName;

    @ApiModelProperty(value = "执勤车辆个数")
    private Integer onDutyCount;

    @ApiModelProperty(value = "出动车辆个数")
    private Integer outCount;

    @ApiModelProperty(value = "子资源节点")
    private List<FireBrigadeResourceDto> children = Lists.newArrayList();
}
