package com.yeejoin.amos.boot.module.statistcs.biz.service.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yeejoin.amos.boot.module.ymt.api.entity.EquipmentCategory;
import com.yeejoin.amos.boot.module.ymt.api.enums.EquipmentTypeEnum;
import com.yeejoin.amos.boot.module.ymt.api.mapper.EquipmentCategoryMapper;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author Administrator
 */
@Service
public class EquipmentBizServiceImpl {

    // 一码通复制功能url参数key
    private static final String COPY_KEY = "stashType";

    private final EquipmentCategoryMapper equipmentCategoryMapper;

    public EquipmentBizServiceImpl(EquipmentCategoryMapper equipmentCategoryMapper) {
        this.equipmentCategoryMapper = equipmentCategoryMapper;
    }

    /**
     * 设备字典,通过设备父类code,获得子类
     */
    public List<EquipmentCategory> getChildren(String code) {
        List<EquipmentCategory> equipmentCategories = new ArrayList<>();
        if(StrUtil.isEmpty(code)){
            return equipmentCategories;
        }
        LambdaQueryWrapper<EquipmentCategory> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(EquipmentCategory::getCode, code);
        EquipmentCategory equipmentCategory = equipmentCategoryMapper.selectOne(wrapper);
        LambdaQueryWrapper<EquipmentCategory> wrapper2 = new LambdaQueryWrapper<>();
        wrapper2.eq(EquipmentCategory::getParentId, equipmentCategory.getId());
        equipmentCategories = equipmentCategoryMapper.selectList(wrapper2);
        return equipmentCategories;
    }

    public Map<String, Object> getFormRecordByIdMap(Map<String, Object> map) {
        String alias = String.valueOf(map.get("alias"));
        if (ObjectUtils.isEmpty(alias)) {
            return new HashMap<>();
        }
        EquipmentTypeEnum equipmentMessage = EquipmentTypeEnum.getEnumByCode(alias);
        if (equipmentMessage == null && ObjectUtils.isEmpty(equipmentMessage)) {
            return new HashMap<>();
        }
        HashMap<String, Map<String, Object>> result = new HashMap<>();
        // 使用信息
        Map<String, Object> useInfo = getUseInfo(map);
        result.put(equipmentMessage.getUseInfo(), useInfo);
        // 设计信息
        Map<String, Object> desInfo = getDesInfo(map);
        result.put(equipmentMessage.getDesInfo(), desInfo);
        // 监督管理信息
        Map<String, Object> supInfo = getSupInfo(map);
        if(!ValidationUtil.isEmpty(supInfo.get("produceDate"))){
            LocalDate produceDate = LocalDate.parse(supInfo.get("produceDate").toString().substring(0, 10), DateTimeFormatter.ofPattern("yyyy-MM-dd"));
            LocalDate localDate = LocalDate.now().minusYears(15);
            if(produceDate.isBefore(localDate)){
                supInfo.put("OVER_FIFTEEN_YEARS","0");
            }else{
                supInfo.put("OVER_FIFTEEN_YEARS","1");
            }
        }
        if ("1".equals(useInfo.get("IS_NOT_XIXIAN"))) {
            supInfo.put("CITY", "咸阳");
        } else {
            supInfo.put("CITY", useInfo.get("CITY_NAME"));
        }
        result.put(equipmentMessage.getSupInfo(), supInfo);
        // 施工信息
        Map<String, Object> comInfo = getComInfo(map);
        result.put(equipmentMessage.getComInfo(), comInfo);
        // 维保信息(只有电梯有)
        if (!ObjectUtils.isEmpty(map) && EquipmentTypeEnum.DT.getCode().equals(alias)) {
            Map<String, Object> mainInfo = getMainInfo(map);
            result.put(equipmentMessage.getMainInfo(), mainInfo);
        }
        // 检验检测信息
        Map<String, Object> insInfo = getInsInfo(map);
        result.put(equipmentMessage.getInsInfo(), insInfo);
        // 注册信息
        Map<String, Object> jriInfo = getJriInfo(map, equipmentMessage);
        result.put(equipmentMessage.getJriInfo(), jriInfo);
        if (!ObjectUtils.isEmpty(map.get(COPY_KEY))) {
            result.get(EquipmentTypeEnum.DT.getSupInfo()).remove("CLAIM_STATUS");
            result.get(EquipmentTypeEnum.DT.getSupInfo()).remove("CODE96333");
            result.get(EquipmentTypeEnum.DT.getSupInfo()).remove("SUPERVISORY_CODE");
        }

        Map<String,Object> resultMapNew = new HashMap<>();
        result.forEach((key, value) -> {
            resultMapNew.putAll(value);
        });
        return resultMapNew;
    }

    /**
     * 使用信息
     *
     * @param map
     * @return
     */
    private Map<String, Object> getUseInfo(Map<String, Object> map) {
        Map<String, Object> useInfo = equipmentCategoryMapper.selectTzsUseInfo(String.valueOf(map.get("id")));
        if (ObjectUtils.isEmpty(useInfo)) {
            return new HashMap<>();
        }
        useInfo.put("LONGITUDE_LATITUDE", JSON.parse(String.valueOf(useInfo.get("LONGITUDE_LATITUDE"))));
        return useInfo;
    }

    /**
     * 施工信息
     *
     * @param map
     * @return
     */
    private Map<String, Object> getComInfo(Map<String, Object> map) {
        List<Map<String, Object>> comList = equipmentCategoryMapper.selectTzsConInfo(String.valueOf(map.get("id")));
        if (ObjectUtils.isEmpty(comList)) {
            return new HashMap<>();
        }
        HashMap<String, Object> comMap = new HashMap<>();
        comList.forEach(item -> {
            if (!comMap.containsKey("id")) {
                comMap.put("id", item.get("RECORD"));
            }
            if (!comMap.containsKey("sequenceNbr")) {
                comMap.put("sequenceNbr", item.get("SEQUENCE_NBR"));
            }
            item.put("Symbol_key", item.get("SEQUENCE_NBR"));
        });
        comMap.put("subForm_b2x2wmcy2s", comList);
        return comMap;
    }

    /**
     * 设计信息
     *
     * @param map
     * @return
     */
    private Map<String, Object> getDesInfo(Map<String, Object> map) {
        Map<String, Object> desInfo = equipmentCategoryMapper.selectTzsDesInfo(String.valueOf(map.get("id")));
        if (ObjectUtils.isEmpty(desInfo)) {
            return new HashMap<>();
        }
        desInfo.put("DESIGN_DOC", JSON.parseArray(String.valueOf(desInfo.get("DESIGN_DOC"))));
        desInfo.put("SUPERVISION_AGENCY_CREDENTIAL", JSON.parseArray(String.valueOf(desInfo.get("SUPERVISION_AGENCY_CREDENTIAL"))));
        desInfo.put("INS_USE_MAINTAIN_EXPLAIN", JSON.parseArray(String.valueOf(desInfo.get("INS_USE_MAINTAIN_EXPLAIN"))));
        desInfo.put("TYPE_TEST_CREDENTIAL", JSON.parseArray(String.valueOf(desInfo.get("TYPE_TEST_CREDENTIAL"))));
        desInfo.put("FACTORY_STANDARD", JSON.parseArray(String.valueOf(desInfo.get("FACTORY_STANDARD"))));
        desInfo.put("DESIGN_STANDARD", JSON.parseArray(String.valueOf(desInfo.get("DESIGN_STANDARD"))));
        desInfo.put("PRODUCT_QUALITY_YIELD_PROVE", JSON.parseArray(String.valueOf(desInfo.get("PRODUCT_QUALITY_YIELD_PROVE"))));
        return desInfo;
    }

    /**
     * 检验检测信息
     *
     * @param map
     * @return
     */
    private Map<String, Object> getInsInfo(Map<String, Object> map) {
        List<Map<String, Object>> InsInfo = equipmentCategoryMapper.selectTzsInsInfo(String.valueOf(map.get("id")));
        if (ObjectUtils.isEmpty(InsInfo)) {
            return new HashMap<>();
        }
        HashMap<String, Object> insInfoMap = new HashMap<>();
        InsInfo.forEach(item -> {
            item.put("INSPECT_REPORT", JSON.parseArray(String.valueOf(item.get("INSPECT_REPORT"))));
            if (!insInfoMap.containsKey("id")) {
                insInfoMap.put("id", item.get("RECORD"));
            }
            if (!insInfoMap.containsKey("sequenceNbr")) {
                insInfoMap.put("sequenceNbr", item.get("SEQUENCE_NBR"));
            }
            item.put("Symbol_key", item.get("SEQUENCE_NBR"));
        });
        insInfoMap.put("subForm_pbim1pfid8", InsInfo);
        return insInfoMap;
    }

    /**
     * 维保信息
     *
     * @param map
     * @return
     */
    private Map<String, Object> getMainInfo(Map<String, Object> map) {
        List<Map<String, Object>> mainInfo = equipmentCategoryMapper.selectTzsMainInfo(String.valueOf(map.get("id")));
        if (ObjectUtils.isEmpty(mainInfo)) {
            return new HashMap<>();
        }
        HashMap<String, Object> mainInfoMap = new HashMap<>();
        mainInfo.forEach(item -> {
            item.put("REPAIR_INFORM", JSON.parseArray(String.valueOf(item.get("REPAIR_INFORM"))));
            if (!mainInfoMap.containsKey("id")) {
                mainInfoMap.put("id", item.get("RECORD"));
            }
            if (!mainInfoMap.containsKey("sequenceNbr")) {
                mainInfoMap.put("sequenceNbr", item.get("SEQUENCE_NBR"));
            }
            item.put("Symbol_key", item.get("SEQUENCE_NBR"));
        });
        mainInfoMap.put("subForm_6i16fox27e", mainInfo);
        return mainInfoMap;
    }

    /**
     * 监督管理信息
     *
     * @param map
     * @return
     */
    private Map<String, Object> getSupInfo(Map<String, Object> map) {
        Map<String, Object> supInfo = equipmentCategoryMapper.selectTzsSupInfo(String.valueOf(map.get("id")));
        return supInfo;
    }

    /**
     * 注册信息
     *
     * @param map
     * @return
     */
    private Map<String, Object> getJriInfo(Map<String, Object> map, EquipmentTypeEnum equipmentMessage) {
        Map<String, Object> result;
        switch (equipmentMessage.getCode()) {
            case "3000":
                // 电梯
                result = equipmentCategoryMapper.selectTzsqzjJriInfo(String.valueOf(map.get("id")), equipmentMessage.getTableName());
                if (ObjectUtils.isEmpty(result)) {
                    return new HashMap<>();
                }
                result.put("EXPLOSIONPROOF_SIGN_COMPLETE", JSON.parseArray(String.valueOf(result.get("EXPLOSIONPROOF_SIGN_COMPLETE"))));
                break;
            case "4000":
                // 起重机械
                result = equipmentCategoryMapper.selectTzsqzjJriInfo(String.valueOf(map.get("id")), equipmentMessage.getTableName());
                if (ObjectUtils.isEmpty(result)) {
                    return new HashMap<>();
                }
                List<Map<String, Object>> lbjJriInfo = equipmentCategoryMapper.selectTzslbjJriInfo(String.valueOf(map.get("id")));
                List<Map<String, Object>> aqfjJriInfo = equipmentCategoryMapper.selectTzsaqfjJriInfo(String.valueOf(map.get("id")));
                result.put("subForm_bqirdyvztt", lbjJriInfo);
                result.put("subForm_29yy3pdzhl", aqfjJriInfo);
                result.put("subForm_h5h4x0zhur", aqfjJriInfo);
                break;
            case "5000":
                // 厂车
                result = equipmentCategoryMapper.selectTzsqzjJriInfo(String.valueOf(map.get("id")), equipmentMessage.getTableName());
                if (ObjectUtils.isEmpty(result)) {
                    return new HashMap<>();
                }
                List<Map<String, Object>> celbjJriInfo = equipmentCategoryMapper.selectTzslbjJriInfo(String.valueOf(map.get("id")));
                result.put("subForm_sey164b51a", celbjJriInfo);
                result.put("subForm_tef7yf5fbr", celbjJriInfo);
                break;
            case "1000":
                // 锅炉
                result = equipmentCategoryMapper.selectTzsqzjJriInfo(String.valueOf(map.get("id")), equipmentMessage.getTableName());
                if (ObjectUtils.isEmpty(result)) {
                    return new HashMap<>();
                }
                List<Map<String, Object>> glaqfjJriInfo = equipmentCategoryMapper.selectTzsaqfjJriInfo(String.valueOf(map.get("id")));
                result.put("subForm_1hh88r4m69", glaqfjJriInfo);
                break;
            case "2000":
                // 压力容器
                result = equipmentCategoryMapper.selectTzsqzjJriInfo(String.valueOf(map.get("id")), equipmentMessage.getTableName());
                if (ObjectUtils.isEmpty(result)) {
                    return new HashMap<>();
                }
                List<Map<String, Object>> ylrqaqfjJriInfo = equipmentCategoryMapper.selectTzsaqfjJriInfo(String.valueOf(map.get("id")));
                List<Map<String, Object>> ylrqjJriInfo = equipmentCategoryMapper.selectTzslbjJriInfo(String.valueOf(map.get("id")));
                result.put("subForm_fie04854f2", ylrqjJriInfo);
                result.put("subForm_d4xdzhsgdj", ylrqaqfjJriInfo);
                break;
            case "8000":
                // 压力容器
                result = equipmentCategoryMapper.selectTzsqzjJriInfo(String.valueOf(map.get("id")), equipmentMessage.getTableName());
                if (ObjectUtils.isEmpty(result)) {
                    return new HashMap<>();
                }
                List<Map<String, Object>> ylgdjJriInfo = equipmentCategoryMapper.selectTzslbjJriInfo(String.valueOf(map.get("id")));
                result.put("subForm_9n7nu55z8r", ylgdjJriInfo);
                break;
            case "6000":
                // 游乐设施
                result = equipmentCategoryMapper.selectTzsqzjJriInfo(String.valueOf(map.get("id")), equipmentMessage.getTableName());
                if (ObjectUtils.isEmpty(result)) {
                    return new HashMap<>();
                }
                break;
            case "9000":
                // 游乐设施
                result = equipmentCategoryMapper.selectTzsqzjJriInfo(String.valueOf(map.get("id")), equipmentMessage.getTableName());
                if (ObjectUtils.isEmpty(result)) {
                    return new HashMap<>();
                }
                List<Map<String, Object>> sdJriLbjInfo = equipmentCategoryMapper.selectTzslbjJriInfo(String.valueOf(map.get("id")));
                result.put("subForm_5fi0jewuyh", sdJriLbjInfo);
                break;
            default:
                result = new HashMap<>();
        }
        result.put("PRODUCT_PHOTO", JSON.parseArray(String.valueOf(result.get("PRODUCT_PHOTO"))));
        result.put("USE_REGISTRATION_CERTIFICATE", JSON.parseArray(String.valueOf(result.get("USE_REGISTRATION_CERTIFICATE"))));
        result.put("USE_SIGN", JSON.parseArray(String.valueOf(result.get("USE_SIGN"))));
        return result;
    }
}
