package com.yeejoin.amos.boot.module.ys.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.ys.api.dto.YsEmergencyPlanDto;
import com.yeejoin.amos.boot.module.ys.api.entity.YsEmergencyPlan;
import com.yeejoin.amos.boot.module.ys.api.mapper.YsEmergencyPlanMapper;
import com.yeejoin.amos.boot.module.ys.api.service.IYsEmergencyPlanService;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.util.Date;
import java.util.List;

/**
 * 应急预案管理服务实现类
 *
 * @author system_generator
 * @date 2024-09-24
 */
@Service
public class YsEmergencyPlanServiceImpl extends BaseService<YsEmergencyPlanDto, YsEmergencyPlan, YsEmergencyPlanMapper> implements IYsEmergencyPlanService {

    @Autowired
    private YsEmergencyPlanMapper ysEmergencyPlanMapper;

    /**
     * 分页查询
     */
    public Page<YsEmergencyPlanDto> queryForYsEmergencyPlanPage(Page<YsEmergencyPlanDto> page) {
        return this.queryForPage(page, null, false);
    }

    /**
     * 列表查询 示例
     */
    public List<YsEmergencyPlanDto> queryForYsEmergencyPlanList() {
        return this.queryForList("", false);
    }

    @Override
    public Page<YsEmergencyPlanDto> queryForYsEmergencyPlanPage(Page<YsEmergencyPlanDto> page, YsEmergencyPlanDto dto) {
        return ysEmergencyPlanMapper.queryForYsEmergencyPlanPage(page, dto);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Boolean saveOrUpdate(YsEmergencyPlanDto dto, AgencyUserModel userModel) {
        YsEmergencyPlan emergencyPlan = new YsEmergencyPlan();
        if (ValidationUtil.isEmpty(dto.getSequenceNbr())) {//新增
            dto.setCreateDate(new Date());
            dto.setCreateUserId(userModel.getUserId());
            dto.setCreateUserName(userModel.getUserName());
        }
        emergencyPlan.setPlanFile(JSON.toJSONString(dto.getPlanFile()));
        BeanUtils.copyProperties(dto, emergencyPlan);
        return this.saveOrUpdate(emergencyPlan);
    }

    @Override
    public YsEmergencyPlanDto detailBySeq(String sequenceNbr) {
        YsEmergencyPlanDto emergencyPlanDto = new YsEmergencyPlanDto();
        YsEmergencyPlan emergencyPlan = this.baseMapper.selectById(sequenceNbr);
        BeanUtils.copyProperties(emergencyPlan, emergencyPlanDto);
        emergencyPlanDto.setPlanFile(JSON.parseArray(emergencyPlan.getPlanFile()));
        return emergencyPlanDto;
    }

    @Override
    public Boolean deleteBySeq(String sequenceNbr) {
        YsEmergencyPlan emergencyPlan = new YsEmergencyPlan();
        emergencyPlan.setSequenceNbr(Long.valueOf(sequenceNbr));
        emergencyPlan.setIsDelete(Boolean.TRUE);
        return this.baseMapper.updateById(emergencyPlan) > 0;
    }
}